/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.DatagramSocketImpl;
import java.net.DualStackPlainDatagramSocketImpl;
import java.net.SocketException;
import java.net.TwoStacksPlainDatagramSocketImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.action.GetPropertyAction;

class DefaultDatagramSocketImplFactory {
    static Class prefixImplClass = null;
    private static String osName;
    private static float version;
    private static boolean preferIPv4Stack;
    private static boolean useDualStackImpl;

    DefaultDatagramSocketImplFactory() {
    }

    static DatagramSocketImpl createDatagramSocketImpl(boolean bl) throws SocketException {
        if (prefixImplClass != null) {
            try {
                return (DatagramSocketImpl)prefixImplClass.newInstance();
            }
            catch (Exception exception) {
                throw new SocketException("can't instantiate DatagramSocketImpl");
            }
        }
        if (useDualStackImpl && !bl) {
            return new DualStackPlainDatagramSocketImpl();
        }
        return new TwoStacksPlainDatagramSocketImpl();
    }

    static {
        preferIPv4Stack = false;
        useDualStackImpl = false;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block2: {
                    version = 0.0f;
                    try {
                        osName = System.getProperties().getProperty("os.name");
                        version = Float.parseFloat(System.getProperties().getProperty("os.version"));
                        preferIPv4Stack = Boolean.parseBoolean(System.getProperties().getProperty("java.net.preferIPv4Stack"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)numberFormatException);
                    }
                }
                return null;
            }
        });
        if (!osName.equals("OS/2") && (double)version >= 6.0 && !preferIPv4Stack) {
            useDualStackImpl = true;
        }
        String string = null;
        try {
            string = AccessController.doPrivileged(new GetPropertyAction("impl.prefix", null));
            if (string != null) {
                prefixImplClass = Class.forName("java.net." + string + "DatagramSocketImpl");
            }
        }
        catch (Exception exception) {
            System.err.println("Can't find class: java.net." + string + "DatagramSocketImpl: check impl.prefix property");
        }
    }
}

