/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import sun.awt.windows.WComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.opengl.WGLGraphicsConfig;

public abstract class WGLSurfaceData
extends OGLSurfaceData {
    protected WComponentPeer peer;
    private WGLGraphicsConfig graphicsConfig;

    private native void initOps(long var1, long var3, int var5, int var6);

    protected native boolean initPbuffer(long var1, long var3, boolean var5, int var6, int var7);

    protected WGLSurfaceData(WComponentPeer wComponentPeer, WGLGraphicsConfig wGLGraphicsConfig, ColorModel colorModel, int n) {
        super(wGLGraphicsConfig, colorModel, n);
        this.peer = wComponentPeer;
        this.graphicsConfig = wGLGraphicsConfig;
        long l = wGLGraphicsConfig.getNativeConfigInfo();
        long l2 = 0L;
        int n2 = 0;
        int n3 = 0;
        if (wComponentPeer != null) {
            Component component = (Component)wComponentPeer.getTarget();
            if (component instanceof Container) {
                Insets insets = ((Container)component).getInsets();
                n2 = -insets.left;
                n3 = -insets.bottom;
            }
            l2 = wComponentPeer.getData();
        }
        this.initOps(l, l2, n2, n3);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static WGLWindowSurfaceData createData(WComponentPeer wComponentPeer) {
        WGLGraphicsConfig wGLGraphicsConfig = WGLSurfaceData.getGC(wComponentPeer);
        return new WGLWindowSurfaceData(wComponentPeer, wGLGraphicsConfig);
    }

    public static WGLOffScreenSurfaceData createData(WComponentPeer wComponentPeer, Image image) {
        WGLGraphicsConfig wGLGraphicsConfig = WGLSurfaceData.getGC(wComponentPeer);
        Rectangle rectangle = wComponentPeer.getBounds();
        return new WGLOffScreenSurfaceData(wComponentPeer, wGLGraphicsConfig, rectangle.width, rectangle.height, image, wComponentPeer.getColorModel(), 4);
    }

    public static WGLOffScreenSurfaceData createData(WGLGraphicsConfig wGLGraphicsConfig, int n, int n2, ColorModel colorModel, Image image, int n3) {
        return new WGLOffScreenSurfaceData(null, wGLGraphicsConfig, n, n2, image, colorModel, n3);
    }

    public static WGLGraphicsConfig getGC(WComponentPeer wComponentPeer) {
        if (wComponentPeer != null) {
            return (WGLGraphicsConfig)wComponentPeer.getGraphicsConfiguration();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return (WGLGraphicsConfig)graphicsDevice.getDefaultConfiguration();
    }

    public static class WGLOffScreenSurfaceData
    extends WGLSurfaceData {
        private Image offscreenImage;
        private int width;
        private int height;

        public WGLOffScreenSurfaceData(WComponentPeer wComponentPeer, WGLGraphicsConfig wGLGraphicsConfig, int n, int n2, Image image, ColorModel colorModel, int n3) {
            super(wComponentPeer, wGLGraphicsConfig, colorModel, n3);
            this.width = n;
            this.height = n2;
            this.offscreenImage = image;
            this.initSurface(n, n2);
        }

        public SurfaceData getReplacement() {
            return WGLOffScreenSurfaceData.restoreContents(this.offscreenImage);
        }

        public Rectangle getBounds() {
            if (this.type == 4) {
                Rectangle rectangle = this.peer.getBounds();
                rectangle.y = 0;
                rectangle.x = 0;
                return rectangle;
            }
            return new Rectangle(this.width, this.height);
        }

        public Object getDestination() {
            return this.offscreenImage;
        }
    }

    public static class WGLWindowSurfaceData
    extends WGLSurfaceData {
        public WGLWindowSurfaceData(WComponentPeer wComponentPeer, WGLGraphicsConfig wGLGraphicsConfig) {
            super(wComponentPeer, wGLGraphicsConfig, wComponentPeer.getColorModel(), 1);
        }

        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        public Rectangle getBounds() {
            Rectangle rectangle = this.peer.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            return rectangle;
        }

        public Object getDestination() {
            return this.peer.getTarget();
        }
    }
}

