/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.windows;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.image.WritableRasterNative;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.Region;
import sun.java2d.windows.DDBlitLoops;
import sun.java2d.windows.DDRenderer;
import sun.java2d.windows.DDScaleLoops;
import sun.java2d.windows.Win32SurfaceData;
import sun.java2d.windows.Win32SurfaceDataProxy;
import sun.java2d.windows.WinVolatileSurfaceManager;
import sun.java2d.windows.WindowsFlags;

public class Win32OffScreenSurfaceData
extends SurfaceData {
    protected int width;
    protected int height;
    protected int transparency;
    protected GraphicsConfiguration graphicsConfig;
    protected Image image;
    protected RenderLoops solidloops;
    private boolean ddSurfacePunted = false;
    protected static DDRenderer ddPipe;
    protected static PixelToShapeConverter ddTxPipe;
    private WritableRasterNative wrn = null;

    private static native void initIDs();

    public static SurfaceType getSurfaceType(ColorModel colorModel, int n) {
        boolean bl = n == 2;
        switch (colorModel.getPixelSize()) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    if (((DirectColorModel)colorModel).getRedMask() == 0xFF0000) {
                        return bl ? Win32SurfaceData.IntRgbDD_BM : Win32SurfaceData.IntRgbDD;
                    }
                    return bl ? Win32SurfaceData.IntRgbxDD_BM : Win32SurfaceData.IntRgbxDD;
                }
                return bl ? Win32SurfaceData.ThreeByteBgrDD_BM : Win32SurfaceData.ThreeByteBgrDD;
            }
            case 15: {
                return bl ? Win32SurfaceData.Ushort555RgbDD_BM : Win32SurfaceData.Ushort555RgbDD;
            }
            case 16: {
                if (colorModel instanceof DirectColorModel && ((DirectColorModel)colorModel).getBlueMask() == 62) {
                    return bl ? Win32SurfaceData.Ushort555RgbxDD_BM : Win32SurfaceData.Ushort555RgbxDD;
                }
                return bl ? Win32SurfaceData.Ushort565RgbDD_BM : Win32SurfaceData.Ushort565RgbDD;
            }
            case 8: {
                if (colorModel.getColorSpace().getType() == 6 && colorModel instanceof ComponentColorModel) {
                    return bl ? Win32SurfaceData.ByteGrayDD_BM : Win32SurfaceData.ByteGrayDD;
                }
                if (colorModel instanceof IndexColorModel && Win32OffScreenSurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                    return bl ? Win32SurfaceData.Index8GrayDD_BM : Win32SurfaceData.Index8GrayDD;
                }
                return bl ? Win32SurfaceData.ByteIndexedDD_BM : Win32SurfaceData.ByteIndexedOpaqueDD;
            }
        }
        throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize());
    }

    public SurfaceDataProxy makeProxyFor(SurfaceData surfaceData) {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.graphicsConfig;
        return Win32SurfaceDataProxy.createProxy(surfaceData, win32GraphicsConfig);
    }

    public static Win32OffScreenSurfaceData createData(int n, int n2, ColorModel colorModel, Win32GraphicsConfig win32GraphicsConfig, Image image, int n3) {
        if (n3 == 3) {
            return null;
        }
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)win32GraphicsConfig.getDevice();
        if (!win32GraphicsDevice.isOffscreenAccelerationEnabled()) {
            return null;
        }
        return new Win32OffScreenSurfaceData(n, n2, Win32OffScreenSurfaceData.getSurfaceType(colorModel, n3), colorModel, win32GraphicsConfig, image, n3, win32GraphicsDevice.getScreen());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.antialiasHint != 2) {
            if (sunGraphics2D.paintState <= 1) {
                if (sunGraphics2D.compositeState <= 0) {
                    if (sunGraphics2D.clipState != 2 && this.transparency != 3) {
                        PixelToShapeConverter pixelToShapeConverter = ddTxPipe;
                        DDRenderer dDRenderer = ddPipe;
                        sunGraphics2D.imagepipe = imagepipe;
                        if (sunGraphics2D.transformState >= 3) {
                            sunGraphics2D.drawpipe = pixelToShapeConverter;
                            sunGraphics2D.fillpipe = pixelToShapeConverter;
                        } else if (sunGraphics2D.strokeState != 0) {
                            sunGraphics2D.drawpipe = pixelToShapeConverter;
                            sunGraphics2D.fillpipe = dDRenderer;
                        } else {
                            sunGraphics2D.drawpipe = dDRenderer;
                            sunGraphics2D.fillpipe = dDRenderer;
                        }
                        sunGraphics2D.shapepipe = dDRenderer;
                        block0 : switch (sunGraphics2D.textAntialiasHint) {
                            case 0: 
                            case 1: {
                                sunGraphics2D.textpipe = solidTextRenderer;
                                break;
                            }
                            case 2: {
                                sunGraphics2D.textpipe = aaTextRenderer;
                                break;
                            }
                            default: {
                                switch (sunGraphics2D.getFontInfo().aaHint) {
                                    case 4: 
                                    case 6: {
                                        sunGraphics2D.textpipe = lcdTextRenderer;
                                        break block0;
                                    }
                                    case 2: {
                                        sunGraphics2D.textpipe = aaTextRenderer;
                                        break block0;
                                    }
                                }
                                sunGraphics2D.textpipe = solidTextRenderer;
                            }
                        }
                        sunGraphics2D.loops = this.solidloops;
                        return;
                    }
                }
            }
        }
        super.validatePipe(sunGraphics2D);
    }

    public static boolean isDDScaleEnabled() {
        return WindowsFlags.isDDScaleEnabled();
    }

    public synchronized Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.wrn == null) {
            this.wrn = WritableRasterNative.createNativeRaster(this.getColorModel(), this, this.width, this.height);
            if (this.wrn == null) {
                throw new InternalError("Unable to create native raster");
            }
        }
        return this.wrn;
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState <= 1) {
            if (sunGraphics2D.compositeState <= 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    private native void initOps(int var1, int var2);

    private native void initSurface(int var1, int var2, int var3, int var4, boolean var5, int var6);

    public native void restoreSurface();

    protected Win32OffScreenSurfaceData(int n, int n2, SurfaceType surfaceType, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, int n3) {
        super(surfaceType, colorModel);
        this.width = n;
        this.height = n2;
        this.graphicsConfig = graphicsConfiguration;
        this.image = image;
        this.transparency = n3;
        this.solidloops = ((Win32GraphicsConfig)this.graphicsConfig).getSolidLoops(surfaceType);
        this.initOps(colorModel.getPixelSize(), n3);
    }

    private Win32OffScreenSurfaceData(int n, int n2, SurfaceType surfaceType, ColorModel colorModel, Win32GraphicsConfig win32GraphicsConfig, Image image, int n3, int n4) {
        this(n, n2, surfaceType, colorModel, win32GraphicsConfig, image, n3);
        this.initSurface(colorModel.getPixelSize(), n, n2, n4, image instanceof SunVolatileImage, n3);
        this.setBlitProxyKey(win32GraphicsConfig.getProxyKey());
    }

    public int getTransparency() {
        return this.transparency;
    }

    public SurfaceData getReplacement() {
        return Win32OffScreenSurfaceData.restoreContents(this.image);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.width, this.height);
    }

    protected native void nativeInvalidate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (this.isValid()) {
            Win32OffScreenSurfaceData win32OffScreenSurfaceData = this;
            synchronized (win32OffScreenSurfaceData) {
                this.wrn = null;
            }
            this.nativeInvalidate();
            super.invalidate();
        }
    }

    public native void setTransparentPixel(int var1);

    public native void flush();

    public boolean surfacePunted() {
        return this.ddSurfacePunted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markSurfaceLost() {
        Object object = this;
        synchronized (object) {
            this.wrn = null;
        }
        this.setSurfaceLost(true);
        if (this.image != null) {
            object = SurfaceManager.getManager(this.image);
            ((SurfaceManager)object).acceleratedSurfaceLost();
        }
    }

    protected void disableDD() {
        SurfaceManager surfaceManager;
        this.markSurfaceLost();
        if (this.image != null && (surfaceManager = SurfaceManager.getManager(this.image)) instanceof WinVolatileSurfaceManager) {
            ((WinVolatileSurfaceManager)surfaceManager).setAccelerationEnabled(false);
        }
        this.setBlitProxyKey(null);
    }

    public Object getDestination() {
        return this.image;
    }

    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (sunGraphics2D.transformState < 3) {
            if (sunGraphics2D.clipState != 2 && (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType))) {
                int n7 = (n += sunGraphics2D.transX) + n5;
                int n8 = (n2 += sunGraphics2D.transY) + n6;
                int n9 = n7 + n3;
                int n10 = n8 + n4;
                Region region = sunGraphics2D.getCompClip();
                if (n7 < region.getLoX()) {
                    n7 = region.getLoX();
                }
                if (n8 < region.getLoY()) {
                    n8 = region.getLoY();
                }
                if (n9 > region.getHiX()) {
                    n9 = region.getHiX();
                }
                if (n10 > region.getHiY()) {
                    n10 = region.getHiY();
                }
                if (n7 < n9 && n8 < n10) {
                    ddPipe.devCopyArea(this, n7 - n5, n8 - n6, n5, n6, n9 - n7, n10 - n8);
                }
                return true;
            }
        }
        return false;
    }

    static {
        Win32OffScreenSurfaceData.initIDs();
        if (WindowsFlags.isDDEnabled() && WindowsFlags.isDDOffscreenEnabled()) {
            if (WindowsFlags.isDDBlitEnabled()) {
                DDBlitLoops.register();
            }
            if (WindowsFlags.isDDScaleEnabled()) {
                DDScaleLoops.register();
            }
        }
        ddPipe = new DDRenderer();
        if (GraphicsPrimitive.tracingEnabled()) {
            ddPipe = ddPipe.traceWrapDD();
        }
        ddTxPipe = new PixelToShapeConverter(ddPipe);
    }
}

