/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.windows;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.SunWritableRaster;
import sun.java2d.InvalidPipeException;
import sun.java2d.StateTracker;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.windows.Win32OffScreenSurfaceData;
import sun.java2d.windows.Win32SurfaceData;
import sun.java2d.windows.WindowsFlags;

public abstract class Win32SurfaceDataProxy
extends SurfaceDataProxy {
    private static final int MAX_SIZE = 65536;
    int srcTransparency;
    Win32GraphicsConfig wgc;

    public static SurfaceDataProxy createProxy(SurfaceData surfaceData, Win32GraphicsConfig win32GraphicsConfig) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)win32GraphicsConfig.getDevice();
        if (!win32GraphicsDevice.isDDEnabledOnDevice() || surfaceData instanceof Win32SurfaceData || surfaceData instanceof Win32OffScreenSurfaceData) {
            return UNCACHED;
        }
        ColorModel colorModel = surfaceData.getColorModel();
        int n = colorModel.getTransparency();
        if (n == 1) {
            return new Opaque(win32GraphicsConfig);
        }
        if (n == 2 && Bitmask.isCompatible(colorModel, surfaceData)) {
            return new Bitmask(win32GraphicsConfig);
        }
        return UNCACHED;
    }

    public Win32SurfaceDataProxy(Win32GraphicsConfig win32GraphicsConfig, int n) {
        this.wgc = win32GraphicsConfig;
        this.srcTransparency = n;
        this.activateDisplayListener();
    }

    public SurfaceData validateSurfaceData(SurfaceData surfaceData, SurfaceData surfaceData2, int n, int n2) {
        block3: {
            if (surfaceData2 == null || !surfaceData2.isValid() || surfaceData2.isSurfaceLost()) {
                ColorModel colorModel = this.wgc.getDeviceColorModel();
                try {
                    surfaceData2 = Win32OffScreenSurfaceData.createData(n, n2, colorModel, this.wgc, null, this.srcTransparency);
                }
                catch (InvalidPipeException invalidPipeException) {
                    Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)this.wgc.getDevice();
                    if (win32GraphicsDevice.isDDEnabledOnDevice()) break block3;
                    this.invalidate();
                    this.flush();
                    return null;
                }
            }
        }
        return surfaceData2;
    }

    public static class Bitmask
    extends Win32SurfaceDataProxy {
        int transPixel;
        Color transColor;
        SurfaceData accelData;
        private static final int ICM_HISTOGRAM_SIZE = 256;
        private static final int ICM_HISTOGRAM_MASK = 255;
        private static final int DCM_HISTOGRAM_SIZE = 1024;
        private static final int DCM_HISTOGRAM_MASK = 1023;

        public static boolean isCompatible(ColorModel colorModel, SurfaceData surfaceData) {
            if (colorModel instanceof IndexColorModel) {
                return true;
            }
            if (colorModel instanceof DirectColorModel) {
                return Bitmask.isCompatibleDCM((DirectColorModel)colorModel, surfaceData);
            }
            return false;
        }

        public static boolean isCompatibleDCM(DirectColorModel directColorModel, SurfaceData surfaceData) {
            if (!(surfaceData instanceof BufImgSurfaceData)) {
                return false;
            }
            Rectangle rectangle = surfaceData.getBounds();
            if (rectangle.width <= 0 || 65536 / rectangle.width < rectangle.height) {
                return false;
            }
            return directColorModel.getPixelSize() == 25 && directColorModel.getTransferType() == 3 && directColorModel.getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255;
        }

        public Bitmask(Win32GraphicsConfig win32GraphicsConfig) {
            super(win32GraphicsConfig, 2);
        }

        public boolean isSupportedOperation(SurfaceData surfaceData, int n, CompositeType compositeType, Color color) {
            return CompositeType.SrcOverNoEa.equals(compositeType) && color == null && n < 3;
        }

        public SurfaceData validateSurfaceData(SurfaceData surfaceData, SurfaceData surfaceData2, int n, int n2) {
            ColorModel colorModel = this.wgc.getDeviceColorModel();
            if (colorModel.getPixelSize() <= 8) {
                return null;
            }
            this.accelData = super.validateSurfaceData(surfaceData, this.accelData, n, n2);
            return this.accelData != null && this.findTransparentPixel(surfaceData, this.accelData) ? this.accelData : null;
        }

        public StateTracker getRetryTracker(SurfaceData surfaceData) {
            return surfaceData.getStateTracker();
        }

        public void updateSurfaceData(SurfaceData surfaceData, SurfaceData surfaceData2, int n, int n2) {
            this.updateSurfaceDataBg(surfaceData, surfaceData2, n, n2, this.transColor);
        }

        public synchronized void flush() {
            SurfaceData surfaceData = this.accelData;
            if (surfaceData != null) {
                this.accelData = null;
                surfaceData.flush();
            }
            super.flush();
        }

        public boolean findTransparentPixel(SurfaceData surfaceData, SurfaceData surfaceData2) {
            ColorModel colorModel = surfaceData.getColorModel();
            boolean bl = false;
            if (colorModel instanceof IndexColorModel) {
                bl = this.findUnusedPixelICM((IndexColorModel)colorModel, surfaceData2);
            } else if (colorModel instanceof DirectColorModel) {
                bl = this.findUnusedPixelDCM((BufImgSurfaceData)surfaceData, surfaceData2);
            }
            if (bl) {
                int n = surfaceData2.rgbFor(this.transPixel);
                this.transColor = new Color(n);
                Win32OffScreenSurfaceData win32OffScreenSurfaceData = (Win32OffScreenSurfaceData)surfaceData2;
                win32OffScreenSurfaceData.setTransparentPixel(this.transPixel);
            } else {
                this.transColor = null;
            }
            return bl;
        }

        private boolean findUnusedPixelICM(IndexColorModel indexColorModel, SurfaceData surfaceData) {
            int n;
            int n2 = indexColorModel.getMapSize();
            int[] nArray = new int[256];
            int[] nArray2 = new int[n2];
            indexColorModel.getRGBs(nArray2);
            for (n = 0; n < n2; ++n) {
                int n3 = surfaceData.pixelFor(nArray2[n]);
                int n4 = n3 & 0xFF;
                nArray[n4] = nArray[n4] + 1;
            }
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] != 0) continue;
                this.transPixel = n;
                return true;
            }
            return false;
        }

        private boolean findUnusedPixelDCM(BufImgSurfaceData bufImgSurfaceData, SurfaceData surfaceData) {
            int n;
            BufferedImage bufferedImage = (BufferedImage)bufImgSurfaceData.getDestination();
            DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
            int[] nArray = SunWritableRaster.stealData(dataBufferInt, 0);
            int[] nArray2 = new int[1024];
            for (n = 0; n < nArray.length; ++n) {
                int n2 = surfaceData.pixelFor(nArray[n]);
                int n3 = n2 & 0x3FF;
                nArray2[n3] = nArray2[n3] + 1;
            }
            for (n = 0; n < nArray2.length; ++n) {
                if (nArray2[n] != 0) continue;
                this.transPixel = n;
                return true;
            }
            return false;
        }
    }

    public static class Opaque
    extends Win32SurfaceDataProxy {
        static int TXMAX = WindowsFlags.isDDScaleEnabled() ? 3 : 2;

        public Opaque(Win32GraphicsConfig win32GraphicsConfig) {
            super(win32GraphicsConfig, 1);
        }

        public boolean isSupportedOperation(SurfaceData surfaceData, int n, CompositeType compositeType, Color color) {
            return n <= TXMAX && (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType));
        }
    }
}

