/********************************************************copyrite.xic***/
/*                                                                     */
/*   Licensed Materials - Property of IBM                              */
/*                                                                     */
/*   This product contains "Restricted Materials of IBM":              */
/*      Program Number:   5798RXW                                      */
/*      Program Name:     IBM TCP/IP Version 1.2 for OS/2              */
/*   (C) Copyright IBM Corporation. 1990, 1991.                        */
/*                                                                     */
/*   All rights reserved.                                              */
/*                                                                     */
/*   US Government Users Restricted Rights -                           */
/*   Use, duplication or disclosure restricted by GSA ADP Schedule     */
/*   Contract with IBM Corp.                                           */
/*                                                                     */
/*   See IBM Copyright Instructions.                                   */
/*                                                                     */
/********************************************************copyrite.xic***/
#ifndef KERNEL
#ifdef __32BIT__
short _Far16 _Cdecl ioctl(short,short,char * _Seg16,short);
#else
ioctl(int , int, char far *, int);
#endif
#endif
#define ioc(x,y)       ((x<<8)|y)

#define FIONREAD        ioc('f', 127)
#define FIONBIO         ioc('f', 126)
#define FIOASYNC        ioc('f', 125)
#define FIOTCPCKSUM     ioc('f', 128)
#define FIONSTATUS      ioc('f', 120)
#define FIONURG         ioc('f', 121)

#define SIOCSHIWAT      ioc('s',  0)
#define SIOCGHIWAT      ioc('s',  1)
#define SIOCSLOWAT      ioc('s',  2)
#define SIOCGLOWAT      ioc('s',  3)
#define SIOCATMARK      ioc('s',  7)
#define SIOCSPGRP       ioc('s',  8)
#define SIOCGPGRP       ioc('s',  9)

#define SIOCADDRT       ioc('r', 10)
#define SIOCDELRT       ioc('r', 11)
#define SIOMETRIC1RT    ioc('r', 12)
#define SIOMETRIC2RT    ioc('r', 13)
#define SIOMETRIC3RT    ioc('r', 14)
#define SIOMETRIC4RT    ioc('r', 15)

#define SIOCREGADDNET   ioc('r', 12)
#define SIOCREGDELNET   ioc('r', 13)
#define SIOCREGROUTES   ioc('r', 14)
#define SIOCFLUSHROUTES ioc('r', 15)

#define SIOCSIFADDR     ioc('i', 12)
#define SIOCGIFADDR     ioc('i',13)
#define SIOCSIFDSTADDR  ioc('i', 14)
#define SIOCGIFDSTADDR  ioc('i',15)
#define SIOCSIFFLAGS    ioc('i', 16)
#define SIOCGIFFLAGS    ioc('i',17)
#define SIOCGIFBRDADDR  ioc('i',18)
#define SIOCSIFBRDADDR  ioc('i',19)
#define SIOCGIFCONF     ioc('i',20)
#define SIOCGIFNETMASK  ioc('i',21)
#define SIOCSIFNETMASK  ioc('i',22)
#define SIOCGIFMETRIC   ioc('i',23)
#define SIOCSIFMETRIC   ioc('i',24)
#define SIOCSIFSETSIG   ioc('i', 25)
#define SIOCSIFCLRSIG   ioc('i', 26)
#define SIOCSIFBRD      ioc('i', 27)

#define SIOCGIFLOAD     ioc('i', 27)
#define SIOCSIFFILTERSRC ioc('i', 28)
#define SIOCGIFFILTERSRC ioc('i',29)

#define SIOCSARP        ioc('i', 30)
#define SIOCGARP        ioc('i', 31)
#define SIOCDARP        ioc('i', 32)
#define SIOCSIFSNMPSIG  ioc('i', 33)
#define SIOCSIFSNMPCLR  ioc('i', 34)
#define SIOCSIFSNMPCRC  ioc('i', 35)
#define SIOCSIFPRIORITY ioc('i', 36)
#define SIOCGIFPRIORITY ioc('i', 37)
#define SIOCSIFFILTERDST ioc('i', 38)
#define SIOCGIFFILTERDST ioc('i',39)
#define SIOCSIF802_3     ioc('i',40)
#define SIOCSIFNO802_3     ioc('i',41)
#define SIOCSIFNOREDIR   ioc('i',42)
#define SIOCSIFYESREDIR   ioc('i',43)

#define SIOCSIFMTU      ioc('i',45)
#define SIOCSIFFDDI     ioc('i',46)
#define SIOCSIFNOFDDI   ioc('i',47)
#define SIOCSRDBRD      ioc('i',48)

/* NETSTAT stuff */
#define SIOSTATMBUF     ioc('n',40)
#define SIOSTATTCP      ioc('n',41)
#define SIOSTATUDP      ioc('n',42)
#define SIOSTATIP       ioc('n',43)
#define SIOSTATSO       ioc('n',44)
#define SIOSTATRT       ioc('n',45)
#define SIOFLUSHRT      ioc('n',46)
#define SIOSTATICMP     ioc('n',47)
#define SIOSTATIF       ioc('n',48)
#define SIOSTATAT       ioc('n',49)
#define SIOSTATARP      ioc('n',50)
