/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                OS/2 2.0 SLIP Driver for IBM TCP/IP version 2.0           */
/*                                                                          */
/*                                DIRECT.CMD                                */
/*                                                                          */
/*            ..................................................            */
/*                                                                          */
/* Sample attachment script for direct connection between to asynchronous   */
/* lines.  This script should be specified using                            */
/* the "attachcmd" and "attachparm" elements in the configuration file.     */
/* For example:                                                             */
/*                                                                          */
/*              interface sl0 {                                             */
/*                 attachcmd  = direct                                      */
/*              }                                                           */
/*                                                                          */
/*                                                                          */
/* When the script runs, it is automatically passed the interface name for  */
/* the interface it is running on as the first argument, and the user       */
/* arguments (from the configuration file) as the remaining parameters.     */
/*--------------------------------------------------------------------------*/

parse arg interface , ipaddress, ipdest, comport baud

/* Setup modem for autoanswer mode */
/* check for input arg */

say ''
say 'DIRECT - SL/IP NULL Modem Connection script',
    '(interface' interface')'

/* Set some definitions for easier COM strings */
cr='0d'x
crlf='0d0a'x

/* check input args and take default if not specified in DIRECT.CFG */
if interface='' | interface='*' then do
   call lineout , ' DIRECT: INTERFACE not specified.  Default SL0 '
   interface='sl0'
  end

if comport= '' | comport='*' then do
   call lineout , ' DIRECT: COM Port was not specified.  Default COM1 '
   comport='COM1'
  end

if baud='' | baud='*' then do
   call lineout , ' DIRECT: BAUD was not specified.  Default 38400 '
   baud='38400'
  end

if ipaddress='' | ipaddress='*' then do
   ipaddress='222.222.222.10'
   call lineout , ' DIRECT: IPADDRESS was not specified.  Default ' ipaddress
  end

if ipdest='' | ipdest='*' then do
   ipdest='222.222.222.20'
   call lineout , ' DIRECT: IPDEST was not specified.  Default ' ipdest
  end

/* Setup TCPIP info for this machine */
call lineout , ' DIRECT: Setting up TCPIP info for this machine ...'

/*
 * Comment or Uncomment as appropriate for your configuration
 */
/* 'arp -f' */

'ifconfig ' interface ipaddress ipdest ' netmask 255.255.240.0'

/* 'route add default ' ipdest '1' */

/* Setup COM Port */
call lineout , ' DIRECT: COM Port settings: mode 'comport baud',n,8,1'
'mode 'comport baud',n,8,1,BUFFER=ON'

/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code                    */
/*--------------------------------------------------------------------------*/


/* Flush any stuff left over from previous COM activity */
call flush_receive

/* Setup All done, returning control to SLIP */
exit 0


/*--------------------------------------------------------------------------*/
/*                            send ( sendstring)                            */
/*..........................................................................*/
/*                                                                          */
/* Routine to send a character string off to the modem.                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call slip_com_output interface , sendstring

   return

/*--------------------------------------------------------------------------*/
/*                    waitfor ( waitstring , [timeout] )                    */
/*..........................................................................*/
/*                                                                          */
/* Waits for the supplied string to show up in the COM input.  All input    */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.                   */
/*                                                                          */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port.                                                      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

waitfor:

   parse arg waitstring , timeout

   waitfor_buffer = '' ; done = 0 ; curpos = 1

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   do while done = 0
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
      end
      else do
         line = slip_com_input(interface)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 1
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
    end

  return


/*--------------------------------------------------------------------------*/
/*                               readpass ()                                */
/*..........................................................................*/
/*                                                                          */
/* Routine used to read a password from the user without echoing the        */
/* password to the screen.                                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

readpass:

  answer = ''
  do until key = cr
    key = slip_getch()
    if key \= cr then do
      answer = answer || key
    end
  end
  say ''
  return answer


/*--------------------------------------------------------------------------*/
/*                             flush_receive ()                             */
/*..........................................................................*/
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/* The optional echo argument, if 1, says to echo flushed information.      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Eat anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = slip_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return
