/* Process an UltiMail delivery event.
*/
parse arg parms
'GETHEADER' message.index
call say 'Mail delivered to' message.userid 'from' header.from.1

/* next block is an example how to use sendpage
if translate(subword(header.subject, 1, 1)) = 'PAGE' then do
  text = subword(header.subject, 2, words(header.subject)-1)
  call say 'paging GCuomo from UltiMail:' text
  address CMD 'sendpage gcuomo' text
end
*/

return 0


Say: procedure
  parse arg message
  say message
  'LOGPRINT' message
return


/* Display the header fields that we know about. */
ShowHeader:
  call say 'Message file:' message.file
  If header.from.0 > 0 then
    do i = 1 to header.from.0
      call say "From:   " header.from.i
    end
  If header.to.0 > 0 then
    do i = 1 to header.to.0
      call say "To:     " header.to.i
    end
  If header.cc.0 > 0 then
    do i = 1 to header.cc.0
      call say "CC:     " header.cc.i
    end
  If header.subject <> '' then call say "Subject:" header.subject
  If header.content.type <> '' then call say "Content type:" header.content.type
  If header.content.subtype <> '' then call say "Content subtype:" header.content.subtype
  If header.unknown <> '' then call say "Unknown:" header.unknown
  If header.full <> '' then call say "Full:" header.full
return
