
#include <os2.h>
#include <types.h>
#include <string.h>
#include <stdio.h>
 

char  buffer[2 << 15];


BOOL patch(const char *, const char *, const char *, int, int);

int  fsize(FILE *);


void main( int argc, char *argv[]) {


  if (argc!=2) {

    printf("usage: lprpatch <directory>\n");
    printf("where <directory> is where lpr.exe & lprmon.exe are located.\n\n");

  } else {

    if ( !patch(argv[1], "lpr.exe", "lpr2.exe", 0x4358, 20655) ||
         !patch(argv[1], "lprmon.exe", "lprmon2.exe", 0x5e3b, 27739) )

      printf("Make sure you have installed the latest TCP/IP base kit patch UN64092.\n");

  }

}



int fsize(FILE *f) {
int p;
  fseek(f, 0L, SEEK_END);
  p = ftell(f);
  fseek(f, 0L, SEEK_SET);
  return(p);
}



BOOL patch(const char *path, const char *oname, const char *nname, int offset, int size) {

FILE  *ifile, *ofile;

BOOL  ret=1;

char  sname[256],
      tname[256];

  strcpy(sname, path);
  strcpy(tname, path);

  if (sname[strlen(sname)-1]!='\\') {
    strcat(sname, "\\");
    strcat(tname, "\\");
  }

  strcat(sname, oname);
  strcat(tname, nname);

  if ( (ifile=fopen(sname, "rb")) != NULL) {

    if ( (ofile=fopen(tname, "wb")) != NULL) {

      if ( (fsize(ifile)==size) &&
           (fread(buffer, sizeof(char), size, ifile)==size) &&
           (buffer[offset]=='L') ) {

        buffer[offset]='J';

        if (fwrite(buffer, sizeof(char), size, ofile)==size)
          printf("Source: '%s', target: '%s'.\n", sname, tname);
        else
          printf("Error writing target file '%s' ?\n", tname);


      } else {

        ret--;
        printf("Invalid source file '%s' ?\n", sname);

      }

      fclose(ofile);

    } else
      printf("Can't create target file '%s' ?\n", tname);

    fclose(ifile);

  } else
    printf("Can't open source file '%s' ?\n", sname);

  return(ret);

}


