/* Innotek RunTime installation                                            */
/*                                                                         */
/* Place Innotek Runtime here under the name runtime.exe                   */
/* Warp 3 users: place warp_3_fix.zip under the name warp3fix.zip here     */
/*                                                                         */
/* 18.09.2004: created                                                     */
/* 30.09.2005: aligned with os2mt                                          */
/* 13.03.2007: runtime did not install on Warp 3                           */

parse arg target source mode

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
product_drv       = value("PRODUCT_DRV"      , ,"OS2ENVIRONMENT")
product_path      = value("PRODUCT_PATH"     , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* check if we are in uninstall mode */
if mode = 'UNINSTALL' then do
	call uninstall
	exit
end

/* exit if package does not exist */
if stream(inst_dir'\runtime.exe', 'c', 'query exists') = '' then exit 9

/* install Innotek RunTime */
Say
Say 'Installing files...'
'@'inst_dir'\runtime.exe /directory='product_drv'\'product_path' /update=force /unattended >> 'product_log' 2>>&1'

/* find out os major version */
tempfile = '$tmp$.txt'
'@ver > 'tempfile' 2>>&1'
call linein(tempfile)
parse value linein(tempfile) with . . . . . os_version
call lineout tempfile
'@del 'tempfile' >nul 2>>&1'

/* install will fail on Warp 3, so we have to fix it */
if os_version = '3.00' & stream(inst_dir'\warp3fix.zip', 'c', 'query exists') <> '' then do

	/* first install optional warp3 fix */
	if stream(target'\os2\system\REGCONV.EXE', 'c', 'query exists') = '' then do
		Say 'Installing Warp3 fixes. Please wait...'
		'@unzip -oC 'inst_dir'\warp3fix.zip *.dll -d 'target'\os2\dll\. >> 'product_log' 2>>&1'
		'@unzip -oC 'inst_dir'\warp3fix.zip *.sym -d 'target'\os2\dll\. >> 'product_log' 2>>&1'
		'@unzip -oC 'inst_dir'\warp3fix.zip *.exe -d 'target'\os2\.     >> 'product_log' 2>>&1'
	end

	/* unpack runtime exe manually */
	'@'inst_dir'\runtime.exe /directory='product_drv'\'product_path' /extract >> 'product_log' 2>>&1'

	/* patch innowin.dll */
	dll = product_drv'\'product_path'\innowin.dll'
	c = charin(dll,1,stream(dll,'c','query size'))
	call charout dll
	p = pos('PMMERGE', c)
	if p > 0 then c = substr(c,1,p-1)'WMMERGE'substr(c,p+length('WMMERGE'))
	'@del 'dll' >> 'product_log' 2>>&1'
	call charout dll, c
	call charout dll

	/* run installer manually */
	c_dir = directory()
	call directory product_drv'\'product_path
	'@innoinst.exe >> 'product_log' 2>>&1'

	/* check installation */
	'@iwquery.exe >> 'product_log' 2>>&1'
	'@iwquery.exe >> 'product_log' 2>>&1'
	call directory c_dir

end

Say
Say 'Completed.'

exit

/* uninstall mode */
uninstall:

	inst_dir'\runtime.exe /uninstall /complete >> 'product_log' 2>>&1'

return
