/*
 * erasepcf.cmd - This is a utility REXX exec that erases the miscpcf and
 * 75dpipcf PMX font directories.  Those directories are backup directories
 * created the first time the PMX CSD containing native PM fonts is installed.
 * This version deletes ONLY the directories explicitly created by the install code.
 * This version checks that XFILES environment variable has been
 * set up properly and both TCPBASE and TCPPMX have already been installed.
 */
'ECHO OFF'
XFILES = envvarcheck('XFILES')
ETC = envvarcheck('ETC')
prompt = 1
arg arglist
do forever
    parse var arglist nextarg arglist
    select
    when nextarg = '-Y' then do
        prompt = 0
        end
    when nextarg = '-?' then do
        say "The following command line parms are supported."
        say "-y  Delete the MISCPCF and/or 75DPIPCF directories without prompting."
        exit 1
        end
    when nextarg = "" then
        leave
    otherwise
        say "The following command line parms are supported."
        say "-y  Delete the MISCPCF and/or 75DPIPCF directories without prompting."
        exit 1
    end /* select */
end

X11PATH=filespec("path",XFILES)
if substr(X11PATH, length(X11PATH), 1) = '\' then
    X11PATH = substr(X11PATH, 1, length(X11PATH) - 1)
X11BASE=filespec("drive",XFILES)||X11PATH
/*
    Assume X11BASE and BASE are the same for now. Eventually we may want to
    allow them to be different.  I.e. look down the PATH variable for
    the BIN files, the LIBPATH for the DLLs, and so on.
    Better yet, prompt the user for an optional change and then check to find
    the files that we should update.
*/
BASE = X11BASE
/* Must CD after direxist, as that proc leaves the dir arg current, if it
 * exists.  That causes failures with RENAME and RD commands.
 */
if (direxist(X11BASE'\X11\MISCPCF')) then do
   'CD' X11BASE
   if prompt then 
      'ERASE' X11BASE'\X11\MISCPCF\*.*'
   else
      'ERASE /N' X11BASE'\X11\MISCPCF\*.*'
   'RD' X11BASE'\X11\MISCPCF'
   if rc \= 0 then
      call bailout("RD" X11BASE'\X11\MISCPCF')
   end
if (direxist(X11BASE'\X11\75DPIPCF')) then do
   'CD' X11BASE
   if prompt then
      'ERASE' X11BASE'\X11\75DPIPCF\*.*'
   else
      'ERASE /N' X11BASE'\X11\75DPIPCF\*.*'
   'RD' X11BASE'\X11\75DPIPCF'
   if rc \= 0 then
      call bailout("RD" X11BASE'\X11\75DPIPCF')
   end
return

envvarcheck: procedure
arg envvar
ENV = 'OS2ENVIRONMENT'
retvar = VALUE(envvar,,ENV)
if retvar = '' then
    do
    call beep 524,200
    call beep 440,250
    say ""
    say "WARNING!"
    say "You do NOT have the environment variable" envvar "defined!"
    say "You already should have installed the OS/2 TCP/IP 2.0 base"
    say "or its equivalent, and you already should have installed"
    say "the X Window System option.  This update package only provides"
    say "changes and additions to the already installed product."
    say "Installation will not continue!"
    say ""
    exit 1
    end
return retvar

fileexists: procedure
arg file
progname = STREAM(file, 'C', 'QUERY EXISTS')
return progname \= ''

direxist: procedure
arg dir
curdir = directory()
newdir = directory(dir)
call directory(curdir)
return newdir \= ''

bailout: procedure
arg arglist
parse var arglist operation dir
/* This proc is called to report a failure of 'operation' */
/* performed with 'dir' as its parameter. */
/* Write the message, if not CID, pause.  Then exit */
say operation "FAILURE on directory" dir
say "Ensure no other process is using the directory."
say "ABORTING."
pause
exit 1
