/*   
 * gimmePCF.cmd - This is a utility REXX exec that restores the miscPCF and/or
 * 75dpiPCF font directories to misc and 75dpi respectively.  This is done via
 * a rename, therefor the contents of miscPCF and 75dpiPCF should be maintained.
 * If the Japanese and/or Korean .pcf fonts are found in the current misc font
 * directory, they will be maintained in the restored misc font dir.  mkfontdir
 * will be run in the restored misc and 75dpi directory.  
 * This version checks that XFILES environment variable has been
 * set up properly and both TCPBASE and TCPPMX have already been installed.
 */
'ECHO OFF'
XFILES = envvarcheck('XFILES')
ETC = envvarcheck('ETC')

X11PATH=filespec("path",XFILES)
if substr(X11PATH, length(X11PATH), 1) = '\' then
    X11PATH = substr(X11PATH, 1, length(X11PATH) - 1)
X11BASE=filespec("drive",XFILES)||X11PATH
/*
    Assume X11BASE and BASE are the same for now. Eventually we may want to
    allow them to be different.  I.e. look down the PATH variable for
    the BIN files, the LIBPATH for the DLLs, and so on.
    Better yet, prompt the user for an optional change and then check to find
    the files that we should update.
*/
BASE = X11BASE

arg arglist
progname = "resetPCF.cmd"
do forever
    parse var arglist nextarg arglist
    select
    when nextarg = '-Y' then 
        leave
    when (nextarg = '-?' | nextarg = "?") then do
        'cls'
        say " "
        say progname "- This is a  REXX exec that restores the "
        say X11BASE'\X11\miscPCF' " font directory to " X11BASE'X11\MISC'
        say X11BASE'\X11\75dpiPCF' "font directory to  "X11BASE'\X11\75DPI'
        say " "
        say "This is done via a rename, therefore the contents of miscPCF "
        say "and 75dpiPCF should be maintained. The current misc and 75dpi "
        say "directories will be DELETED!"
        say "If the Japanese and/or Korean .pcf (DBCS) fonts are found in "
        say "the current misc font directory,  they will be maintained in "
        say "the  restored  misc font dir.  mkfontdr  will be  run in the "
        say "restored misc and 75dpi directories.  "
        say " WARNING: Any modifications to fonts.ali or fonts added to "
        say "    either misc or 75dpi will be lost!                     "
        exit 1
        end
    when nextarg = "" then
        leave
    otherwise do
        'cls'
        say " "
        say progname "- This is a  REXX exec that restores the "
        say X11BASE'\X11\miscPCF' " font directory to " X11BASE'X11\MISC'
        say X11BASE'\X11\75dpiPCF' "font directory to  "X11BASE'\X11\75DPI'
        say " "
        say "This is done via a rename, therefore the contents of miscPCF "
        say "and 75dpiPCF should be maintained. The current misc and 75dpi "
        say "directories will be DELETED!"
        say "If the Japanese and/or Korean .pcf (DBCS) fonts are found in "
        say "the current misc font directory,  they will be maintained in "
        say "the  restored  misc font dir.  mkfontdr  will be  run in the "
        say "restored misc and 75dpi directories.  "
        say " WARNING: Any modifications to fonts.ali or fonts added to "
        say "    either misc or 75dpi will be lost!                     "
        exit 1
        end
    end /* select */
end

/* Note that calls to direxist leaves the drive in the directory
 * arg passed, if it exists.  A 'CD' is necessary after calling
 * direxist, if a RENAME or RD will be performed.
 */
call dircheck X11BASE'\X11\MISC'
if (direxist(X11BASE'\X11\MISCPCF')) then do
   'CD' X11BASE
   'RENAME' X11BASE'\X11\MISC' MISCDEL
    if rc \= 0 then
       call bailout("RENAME" X11BASE'\X11\MISC')
   'RENAME' X11BASE'\X11\MISCPCF' MISC
    if rc \= 0 then
       call bailout("RENAME" X11BASE'\X11\MISCPCF')

    /* move the Asian DBCS fonts, if present */
    moverc = 0
    if fileexists(X11BASE'\x11\MISCDEL\jiskan16.pcf') then do
        'MOVE' X11BASE'\x11\MISCDEL\jiskan16.pcf' X11PATH'\x11\misc'
        moverc = moverc + rc
        end
    if fileexists(X11BASE'\x11\MISCDEL\jiskan24.pcf') then do
        'MOVE' X11BASE'\x11\MISCDEL\jiskan24.pcf' X11PATH'\x11\misc'
        moverc = moverc + rc
        end
    if fileexists(X11BASE'\x11\MISCDEL\k14.pcf')  then do
        'MOVE' X11BASE'\x11\MISCDEL\k14.pcf' X11PATH'\x11\misc'
        moverc = moverc + rc
        end
    if fileexists(X11BASE'\x11\MISCDEL\hanglg16.pcf') then do
        'MOVE' X11BASE'\x11\MISCDEL\hanglg16.pcf' X11PATH'\x11\misc'
        moverc = moverc + rc
        end
    if fileexists(X11BASE'\x11\MISCDEL\hanglm16.pcf') then do
        'MOVE' X11BASE'\x11\MISCDEL\hanglm16.pcf' X11PATH'\x11\misc'
        moverc = moverc + rc
        end
    if fileexists(X11BASE'\x11\MISCDEL\hanglm24.pcf') then do
        'MOVE' X11BASE'\x11\MISCDEL\hanglm24.pcf' X11PATH'\x11\misc'
        moverc = moverc + rc
        end
    if moverc \= 0 then
       call bailout("MOVE" X11BASE'\X11\MISCDEL')
   'ERASE /N' X11BASE'\X11\MISCDEL\*.*'
   'RD' X11BASE'\X11\MISCDEL'
    if rc \= 0 then
       call bailout("RD" X11BASE'\X11\MISCDEL')
   call buildfontsdir 'misc'
   end
else do
   say " WARNING!! " X11BASE'\X11\MISCPCF' "not found.  No action taken."
   end

call dircheck X11BASE'\X11\75DPI'
if (direxist(X11BASE'\X11\75DPIPCF')) then do
   'CD' X11BASE
   'RENAME' X11BASE'\X11\75DPI' 75DPIDEL
    if rc \= 0 then
       call bailout("RENAME" X11BASE'\X11\75DPI')
   'RENAME' X11BASE'\X11\75DPIPCF' 75DPI
    if rc \= 0 then
       call bailout("RENAME" X11BASE'\X11\75DPIPCF')
   'ERASE /N' X11BASE'\X11\75DPIDEL\*.*'
   'RD' X11BASE'\X11\75DPIDEL'
    if rc \= 0 then
       call bailout("RD" X11BASE'\X11\75DPIDEL')
   call buildfontsdir '75dpi'
   end
else do
   say " WARNING!! " X11BASE'\X11\75DPIPCF' "not found.  No action taken."
   end
return
/* --------------end main program--------------------- */

envvarcheck: procedure
arg envvar
ENV = 'OS2ENVIRONMENT'
retvar = VALUE(envvar,,ENV)
if retvar = '' then
    do
    call beep 524,200
    call beep 440,250
    say ""
    say "WARNING!"
    say "You do NOT have the environment variable" envvar "defined!"
    say "You already should have installed the OS/2 TCP/IP 2.0 base"
    say "or its equivalent, and you already should have installed"
    say "the X Window System option.  This update package only provides"
    say "changes and additions to the already installed product."
    say "Installation will not continue!"
    say ""
    exit 1
    end
return retvar

fileexists: procedure
arg file
progname = STREAM(file, 'C', 'QUERY EXISTS')
return progname \= ''

direxist: procedure
arg dir
curdir = directory()
newdir = directory(dir)
call directory(curdir)
return newdir \= ''

dircheck: procedure
arg dir
curdir = directory()
newdir = directory(dir)
call directory(curdir)
if newdir \= '' then
    do
    return newdir
    end
else
    do
    call beep 524,200
    call beep 440,250
    say ""
    say "Directory '"dir"' could not be found even though the XFILES"
    say "environment variable is defined as '"XFILES"'!"
    say "The directory was supposed to be created when the TCP/IP 2.0"
    say "base and X Window System 2.0 option were installed."
    say "Installation is terminated!"
    exit 1
    end

buildfontsdir: procedure expose X11BASE
arg dir
/* build the fonts.dir in the x11\dir directory. */
/* save the user's current directory */
currentdir = directory()
/* make dir font directory the current one */
call directory X11BASE'\X11\'dir
say "Making a new fonts.dir file in "X11BASE"\X11\"dir "directory..."
X11BASE'\bin\mkfontdr'
/* restore the user's current directory */
call directory(currentdir)
return

bailout: procedure
arg arglist
parse var arglist operation dir
/* This proc is called to report a failure of 'operation' */
/* performed with 'dir' as its parameter. */
/* Write the message, if not CID, pause.  Then exit */
say operation "FAILURE on directory" dir
say "Ensure no other process is using the directory."
say "Install is ABORTING."
pause
exit 1
