/*****************************************************************************
 * $Id: names.c,v 2.4 1995/03/29 00:08:09 ak Exp $
 *****************************************************************************
 * $Log: names.c,v $
 * Revision 2.4  1995/03/29  00:08:09  ak
 * Add/strip .gz suffix to compressed files.
 * File handle bugfix.
 * No true statically linked version.
 *
 * Revision 2.3  1994/07/11  16:07:26  edvkai
 * .
 *
 * Revision 2.2  1994/07/05 18:45:06  edvkai
 * 2.35: Posix support for long filenames and magic name.
 *
 * Lots of changes in filename handling, I hope I found all places. Added
 * decode_filename() with result in var 'filename' for this. header.name
 * should no longer be used. The diffarch kludge FILENAME is no longer
 * necessary.
 *
 * Treatment of links is not up-to-date, I fear - what's defined by Posix
 * about long link names?
 *
 * Due to NONAMES, prior versions created "oldarch" style archives without
 * magic name. Now magic is "ustar\0""00" for Posix and "ustar  \0" else.
 *
 * Unused header space is used to support multi-volume archives in Posix -
 * THIS IS SPECIFIC TO GTAK.
 *
 * Note that Posix conflicts with atime/ctime.
 *
 * Revision 2.1  1993/08/08 19:10:00  ak
 * Merge of network TAR with 2.12.
 *
 * Revision 1.1.1.2  1993/08/08  17:51:30  ak
 * - Network tape access.
 * - Dynamically loaded modules for disk/scsi/network interfaces.
 *
 * Revision 1.2  1992/09/02  20:08:26  ak
 * Version AK200
 * - Tape access
 * - Quick file access
 * - OS/2 extended attributes
 * - Some OS/2 fixes
 * - Some fixes of Kai Uwe Rommel
 *
 * Revision 1.1.1.1  1992/09/02  19:22:08  ak
 * Original GNU Tar 1.10 with some filenames changed for FAT compatibility.
 *
 * Revision 1.1  1992/09/02  19:22:06  ak
 * Initial revision
 *
 *****************************************************************************/

static char *rcsid = "$Id: names.c,v 2.4 1995/03/29 00:08:09 ak Exp $";

/*
 * Modified by Andreas Kaiser July 92.
 * See CHANGES.AK for info.
 */

/* Look up user and/or group names.
   Copyright (C) 1988 Free Software Foundation

This file is part of GNU Tar.

GNU Tar is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Tar is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Tar; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * Look up user and/or group names.
 *
 * This file should be modified for non-unix systems to do something
 * reasonable.
 *
 * @(#)names.c 1.3 10/30/87 - gnu
 */ 
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "tar.h"

extern	char	*strncpy();

#ifndef NONAMES

#ifdef MSDOS

void
finduname(uname, uid)
	char	uname[TUNMLEN];
	int	uid;
{
	uname[0] = '\0';
}

int
finduid(uname)
	char	uname[TUNMLEN];
{
	return -3;
}


void
findgname(gname, gid)
	char	gname[TGNMLEN];
	int	gid;
{
	gname[0] = '\0';
}


int
findgid(gname)
	char	gname[TUNMLEN];
{
	return -3;
}

#else

/* Whole module goes away if NONAMES defined.  Otherwise... */
#include <pwd.h>
#include <grp.h>

static int	saveuid = -993;
static char	saveuname[TUNMLEN];
static int	my_uid = -993;

static int	savegid = -993;
static char	savegname[TGNMLEN];
static int	my_gid = -993;

#define myuid	( my_uid < 0? (my_uid = getuid()): my_uid )
#define	mygid	( my_gid < 0? (my_gid = getgid()): my_gid )

/*
 * Look up a user or group name from a uid/gid, maintaining a cache.
 * FIXME, for now it's a one-entry cache.
 * FIXME2, the "-993" is to reduce the chance of a hit on the first lookup.
 *
 * This is ifdef'd because on Suns, it drags in about 38K of "yellow
 * pages" code, roughly doubling the program size.  Thanks guys.
 */
void
finduname(uname, uid)
	char	uname[TUNMLEN];
	int	uid;
{
	struct passwd	*pw;
	extern struct passwd *getpwuid ();

	if (uid != saveuid) {
		saveuid = uid;
		saveuname[0] = '\0';
		pw = getpwuid(uid); 
		if (pw) 
			strncpy(saveuname, pw->pw_name, TUNMLEN);
	}
	strncpy(uname, saveuname, TUNMLEN);
}

int
finduid(uname)
	char	uname[TUNMLEN];
{
	struct passwd	*pw;
	extern struct passwd *getpwnam();

	if (uname[0] != saveuname[0]	/* Quick test w/o proc call */
	    || 0!=strncmp(uname, saveuname, TUNMLEN)) {
		strncpy(saveuname, uname, TUNMLEN);
		pw = getpwnam(uname); 
		if (pw) {
			saveuid = pw->pw_uid;
		} else {
			saveuid = myuid;
		}
	}
	return saveuid;
}


void
findgname(gname, gid)
	char	gname[TGNMLEN];
	int	gid;
{
	struct group	*gr;
	extern struct group *getgrgid ();

	if (gid != savegid) {
		savegid = gid;
		savegname[0] = '\0';
		(void)setgrent();
		gr = getgrgid(gid); 
		if (gr) 
			strncpy(savegname, gr->gr_name, TGNMLEN);
	}
	(void) strncpy(gname, savegname, TGNMLEN);
}


int
findgid(gname)
	char	gname[TUNMLEN];
{
	struct group	*gr;
	extern struct group *getgrnam();

	if (gname[0] != savegname[0]	/* Quick test w/o proc call */
	    || 0!=strncmp(gname, savegname, TUNMLEN)) {
		strncpy(savegname, gname, TUNMLEN);
		gr = getgrnam(gname); 
		if (gr) {
			savegid = gr->gr_gid;
		} else {
			savegid = mygid;
		}
	}
	return savegid;
}

#endif

#endif

void
add_suffix(char *name, char *suffix)
{
    char *p = memchr(name, '\0', NAMSIZ);
    if (p)
	do *p++ = *suffix; while (*suffix++ && p < name+NAMSIZ);
}

void
strip_suffix(char *name, char *suffix)
{
    int n = strlen(suffix);
    char *p = memchr(name, '\0', NAMSIZ);
    if (p) {
	if (memcmp(p-n, suffix, n) == 0)
	    p[-n] = '\0';
    } else {
	do {
	    if (memcmp(name+NAMSIZ-n, suffix, n) == 0) {
		memset(name+NAMSIZ, '\0', n);
		break;
	    }
	} while (--n);
    }
}

