{

(c) GNU General Public License
(c) 2000 by raVen

raco - (r)aVen's (a)rchive (co)nverter

supported compilers: borland pascal 7.0, virtual pascal 2.0b+

all lacking sources on http://raven66.newmail.ru/sources.html

}
{$IfDef VirtualPascal}
{$B+,D+,H-,I-,J+,P-,Q-,R-,S-,T-,V+,W-,X+,Z-}
{&AlignCode+,AlignData+,AlignRec-,Asm-,Delphi+,Frame+,G3+,LocInfo+,Open32+}
{&Optimise+,OrgName-,SmartLink+,Speed+,Use32+,ZD+}
{$M 262144}
{$EndIf}

{$IfDef Ver70}
{$A+,B+,D+,E+,F+,G+,I-,L+,N+,O+,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 65520,0,655360}
{$EndIf}

{/$Define Debug}

Uses {HeapChk,}
 {$IfDef Win32}
  Windows,
 {$EndIf}
 Objects, rObjects, rCommon, OpCrt, rFbbs, rConfig, rStrings, Strings, rIni,
 RacoArc, Dos, Memory, rMacroz
{$IfDef VirtualPascal}
 ,VPUtils, VPSysLow;
{$EndIf}
{$IfDef Ver70}
;
{$EndIf}

const
 cmlRecurse: pChar = '/r';
 cmlNested : pChar = '/n';
 cmldKeep  : pChar = '/k';
 cfgYes    : pChar = 'yes';
 cLongDesc : pChar = ' >';

type
 tRaco = object(tObject)
{$IfDef Debug}
  mem: Longint;
{$EndIf}
  DescFiles: pCollection;
  StopOnError, KillExist, Recurse, Nested, KeepTime: Boolean;
  Archives, ArcMask, OldDir: pString;
  FileList, ScanProgs, DeleteFiles, AddFiles, PackedFileList: pStringCollection;
  ra: pRacoArchivers;
  constructor Init;
  destructor Done; virtual;
  procedure Abort(Reason: String);
  function GetTempDirName: String;
  procedure ProcessEveryFile(FileName: String);
  procedure Run;
 end;

constructor tRaco.Init;
 var
  cfg: pTextConfig;
  s: String;
  x: Integer;
  ifi: pIniFiles;
 begin
{$IfDef Debug}
{$IfDef Ver70}
  mem:=MemAvail;
{$EndIf}
{$IfDef VirtualPascal}
  mem:=MemUsed;
{$EndIf}
{$EndIf}
  WriteLn(#13#10'raVen''s archive converter v0.4');
  WriteLn('(c) 2000 by raVen'#13#10);
  if (ParamCount=0) or (ParamCount>4) then
   begin
    WriteLn('usage: raco [/r] [/n] [/k] <filemask>');
    WriteLn(#13#10'       /r - recursive scan (with subfolders)');
    WriteLn(      '       /n - convert nested archives');
    WriteLn(      '       /k - don''t keep archive filetime');
    Abort('');
   end;

  s:=AddBackSlash(JustPathName(ParamStr(0)))+'raco.ctl';
  if not Exist(s) then Abort('config file ['+s+'] not found');
  New(cfg,Init);
  with cfg^ do
   begin
    AddWord('Recurse');
    AddWord('Nested');
    AddWord('KeepTime');
    AddWord('StopOnError');
    AddWord('KillExist');
    AddWord('Archives');
    AddWord('AddFile');
    AddWord('DeleteFile');
    AddWord('Scan');
    AddWord('FileList');
    if Load(s)<>0 then Abort('can''t load config file ['+s+']');
    Recurse:=UpStr(GetValue(1,1))=UpStr(StrPas(cfgYes));
    Nested:=UpStr(GetValue(2,1))=UpStr(StrPas(cfgYes));
    KeepTime:=UpStr(GetValue(3,1))=UpStr(StrPas(cfgYes));
    StopOnError:=UpStr(GetValue(4,1))=UpStr(StrPas(cfgYes));
    KillExist:=UpStr(GetValue(5,1))=UpStr(StrPas(cfgYes));
    Archives:=NewStr(GetValue(6,1));
    if JustPathName(GetPS(Archives))='' then ReallocStr(Archives,AddBackSlash(JustPathName(ParamStr(0)))+GetPS(Archives));
    New(AddFiles,Init(16,16));
    for x:=1 to GetValueCount(7) do AddFiles^.Insert(NewStr(UpStr(GetValue(7,x))));
    New(DeleteFiles,Init(16,16));
    for x:=1 to GetValueCount(8) do DeleteFiles^.Insert(NewStr(UpStr(GetValue(8,x))));
    New(ScanProgs,Init(16,16));
    for x:=1 to GetValueCount(9) do ScanProgs^.Insert(NewStr(UpStr(GetValue(9,x))));
    New(FileList,Init(16,16));
    for x:=1 to GetValueCount(10) do FileList^.Insert(NewStr(UpStr(GetValue(10,x))));
    if GetBadLineCount>0 then
     begin
      for x:=1 to GetBadLineCount do WriteLn('wrong line [#'+NToC(GetBadLine(x))+'] in ['+s+']');
      WriteLn('pause (3 seconds)...');
      Delay(3000);
     end;
   end;
  DisposeObj(Cfg);

  if not Exist(GetPS(Archives)) then
   begin
    Abort('canot open archives file ['+GetPS(Archives)+']');
   end;

  New(ifi,Init);
  New(ra,Init);
  with ifi^ do
   begin
    FindSection(True,GetPS(Archives),s);
    while not SectionError do
     begin
      ra^.AddArchiver(
                      ReadString(GetPS(Archives),s,'extension'),
                      ReadString(GetPS(Archives),s,'ident'),
                      ReadString(GetPS(Archives),s,'extract'),
                      ReadString(GetPS(Archives),s,'add'),
                      ReadString(GetPS(Archives),s,'test')
                     );
      FindSection(False,GetPS(Archives),s);
     end;
   end;
  DisposeObj(ifi);

  for x:=1 to ParamCount do if UpStr(ParamStr(x))=UpStr(StrPas(cmlRecurse)) then Recurse:=True
  else if UpStr(ParamStr(x))=UpStr(StrPas(cmlNested)) then Nested:=True
  else if UpStr(ParamStr(x))=UpStr(StrPas(cmldKeep)) then KeepTime:=False;
  s:=ParamStr(ParamCount);
  if JustPathName(s)='' then
   begin
    GetDir(0,s);
    s:=AddBackSlash(s)+ParamStr(ParamCount);
   end;
  ReallocStr(ArcMask,s);
  New(DescFiles,Init(16,16));
  New(PackedFileList,Init(16,16));
  OldDir:=NewStr(' ');
 end;

destructor  tRaco.Done;
 begin
  DisposeObj(DescFiles);
  DisposeObj(FileList);
  DisposeObj(ScanProgs);
  DisposeObj(DeleteFiles);
  DisposeObj(AddFiles);
  DisposeObj(ra);
  DisposeObj(PackedFileList);
  ReallocStr(Archives,'');
  ReallocStr(ArcMask,'');
  ReallocStr(OldDir,'');
{$IfDef Debug}
{$IfDef VirtualPascal}
  WriteLn('memory leak is ',MemUsed-mem,' bytes.');
{$EndIf}
{$IfDef Ver70}
  WriteLn('memory leak is ',mem-MemAvail,' bytes.');
{$EndIf}
{$EndIf}
 end;

procedure tRaco.Abort;
 begin
  WriteLn(Reason);
  WriteLn('exiting...');
  Done;
  Halt(Random(255));
 end;

function tRaco.GetTempDirName;
 function GetMSGID: String;
  var
   stamp: Longint;
   stampW: record
    L,H: System.Word
   end absolute stamp;
   Year,Month,Day,Dow,Hour,Min,Sec,Sec100: Word;
   q: DateTime;
  begin
   Dos.GetDate(Year,Month,Day,Dow);
   GetTime(Hour,Min,Sec,Sec100);
   Stamp:=LongInt(Year)*365*24*60*60;
   Stamp:=Stamp+LongInt(Month)*30*24*60*60;
   Stamp:=Stamp+LongInt(Day)*24*60*60;
   Stamp:=Stamp+LongInt(Hour)*60*60;
   Stamp:=Stamp+LongInt(Min)*60;
   stamp:=stamp+Longint(Sec);
   stamp:=(stamp shl 7) or (Sec100 and $7F);
   Stamp:=Stamp+Random(65535);
   GetMsgID :=
   Digits[1+Hi(stampW.H) shr 4] +
   Digits[1+Hi(StampW.H) and $F] +
   Digits[1+Lo(StampW.H) shr 4] +
   Digits[1+Lo(StampW.H) and $F] +
   Digits[1+Hi(StampW.L) shr 4] +
   Digits[1+Hi(StampW.L) and $F] +
   Digits[1+Lo(StampW.L) shr 4] +
   Digits[1+Lo(StampW.L) and $F];
  end;
 var
  ext,dir,s: String;
  x: LongInt;
 begin
  dir:='';
  ext:='.tmp';
  if MkTree(Dir) then s:=AddBackSlash(Dir) else s:='';
  repeat
   s:=GetMsgId;
   GetTempDirName:=Dir+s+Ext+BackSlash;
  until not DExist(Dir+s+Ext);
 end;

procedure tRaco.ProcessEveryFile(FileName: String);
 var
  f: File;
  x,y: Integer;
  Attr: Word;
  TempName,s,CmdLine: String;
  fTime: Longint;
  pd: pDesc;
  sr: SearchRec;
  m: pMacros;
 begin
  if UpStr(GetPS(OldDir))<>UpStr(AddBackSlash(JustPathName(FileName))) then
   begin
    {$IfDef Win32}
     SetLength(TempName,Length(FileName));
     CharToOemBuff(@FileName[1],@TempName[1],Length(FileName));
    {$Else}
     TempName:=FileName;
    {$EndIf}
    WriteLn('processing folder ['+JustPathName(TempName)+qBracket2);
    with DescFiles^ do if Count>0 then for x:=0 to Count-1 do
     begin
      Assign(f,GetPS(OldDir)+GetPS(FileList^.At(x)));
      GetFAttr(f,Attr);
      SetFAttr(f,0);
      if Exist(GetPS(OldDir)+GetPS(FileList^.At(x)))
      then pDescCol(At(x))^.Save(GetPS(OldDir)+GetPS(FileList^.At(x)),StrPas(cLongDesc));
      SetFAttr(f,Attr);
     end;
    ReallocStr(OldDir,UpStr(AddBackSlash(JustPathName(FileName))));
    DescFiles^.FreeAll;
    PackedFileList^.FreeAll;
   end;

  ra^.SetArcName(FileName);
  if ra^.CanProcessIt<=0 then
   begin
{    WriteLn(qBracket1+FileName+qBracket2+' cannot be repacked!');}
    exit;
   end;

  s:=UpStr(FileName);
  if PackedFileList^.Search(@s,x) then exit;
  if (DescFiles^.Count=0) and (PackedFileList^.Count=0) then
   begin
    with FileList^ do if Count>0 then for x:=0 to Count-1 do
     begin
      DescFiles^.Insert(New(pDescCol,Init(16,16)));
      if not Exist(AddBackSlash(JustPathName(FileName))+GetPS(FileList^.At(x))) then Continue;
      Assign(f,AddBackSlash(JustPathName(FileName))+GetPS(FileList^.At(x)));
      GetFAttr(f,Attr);
      SetFAttr(f,0);
      pDescCol(DescFiles^.At(DescFiles^.Count-1))^.Load(AddBackSlash(JustPathName(FileName))+
               GetPS(FileList^.At(x)),StrPas(cLongDesc));
      SetFAttr(f,Attr);
     end;
   end;

  if KeepTime then
   begin
    Assign(f,FileName);
    Reset(f);
    GetFTime(f,fTime);
    Close(f);
   end;

  s:=AddBackSlash(JustPathName(FileName))+GetTempDirName;

  if (ra^.UnPackTo(s)<>0) then
   begin
    DelDir(RemoveBackSlash(s),true);
    {$IfDef Win32}
     SetLength(TempName,Length(FileName));
     CharToOemBuff(@FileName[1],@TempName[1],Length(FileName));
    {$Else}
     TempName:=FileName;
    {$EndIf}
    if StopOnError then Abort('extraction mistake on '+qBracket1+TempName+qBracket2+Point) else
     begin
      WriteLn('extraction mistake on '+qBracket1+TempName+qBracket2+Point+' next archive!');
      exit;
     end;
   end;

  if Nested then
   begin
    CmdLine:='';
    for x:=0 to ParamCount-1 do CmdLine:=CmdLine+ParamStr(x)+Space;
    CmdLine:=StrPas(DosExec)+CmdLine+s+StrPas(x_x);
  {$IfDef MsDos}
   {$IfNDef DPMI}
    SetMemTop(HeapPtr);
   {$EndIf}
    SwapVectors;
  {$EndIf}
    Exec(GetEnv(StrPas(Command)),CmdLine);
  {$IfDef MsDos}
    SwapVectors;
   {$IfNDef DPMI}
    SetMemTop(HeapEnd);
   {$EndIf}
  {$EndIf}
   end;

  with DeleteFiles^ do if Count>0 then for x:=0 to Count-1 do
   begin
    FindFirst(s+GetPS(At(x)),AnyFile,sr);
    while (DosError=0) do
     begin
      if (sr.Attr and (VolumeID+Directory))=0 then KillFile(s+AddBackSlash(JustPathName(GetPS(At(x))))+sr.Name);
      FindNext(sr);
     end;
   {$IfDef VirtualPascal}
    FindClose(sr);
   {$EndIf}
   end;

  with ScanProgs^ do if Count>0 then for x:=0 to Count-1 do
   begin
    New(m,Init);
    CmdLine:=StrPas(DosExec)+GetPS(At(x));
    m^.AddStringMacro('@Folder',RemoveBackSlash(s),false);
    m^.ProcessString(CmdLine);
  {$IfDef MsDos}
   {$IfNDef DPMI}
    SetMemTop(HeapPtr);
   {$EndIf}
    SwapVectors;
  {$EndIf}
    Exec(GetEnv(StrPas(Command)),CmdLine);
  {$IfDef MsDos}
    SwapVectors;
   {$IfNDef DPMI}
    SetMemTop(HeapEnd);
   {$EndIf}
  {$EndIf}
    DisposeObj(m);
   end;

  with AddFiles^ do if Count>0 then for x:=0 to Count-1 do
   begin
    FindFirst(GetPS(At(x)),AnyFile,sr);
    while (DosError=0) do
     begin
      if (sr.Attr and (VolumeID+Directory))=0 then
      CopyFile(AddBackSlash(JustPathName(GetPS(At(x))))+sr.Name,s+sr.Name,False);
      FindNext(sr);
     end;
   {$IfDef VirtualPascal}
    FindClose(sr);
   {$EndIf}
   end;

  if (ra^.PackFrom(s)<>0) then
   begin
    DelDir(RemoveBackSlash(s),true);
    {$IfDef Win32}
     SetLength(TempName,Length(FileName));
     CharToOemBuff(@FileName[1],@TempName[1],Length(FileName));
    {$Else}
     TempName:=FileName;
    {$EndIf}
    if StopOnError then Abort('packing mistake on '+qBracket1+TempName+qBracket2+Point) else
     begin
      WriteLn('packing mistake on '+qBracket1+TempName+qBracket2+Point+' next archive!');
      exit;
     end;
   end;

  with ra^ do SetArcName(GetPS(ArcName));

  if not (ra^.TestArc in [0,66]) then
   begin
    DelDir(RemoveBackSlash(s),true);
    {$IfDef Win32}
     SetLength(TempName,Length(FileName));
     CharToOemBuff(@FileName[1],@TempName[1],Length(FileName));
    {$Else}
     TempName:=FileName;
    {$EndIf}
    if StopOnError then Abort('testing mistake on '+qBracket1+TempName+qBracket2+Point) else
     begin
      WriteLn('testing mistake on '+qBracket1+TempName+qBracket2+Point+' next archive!');
      exit;
     end;
   end;

  if Exist(ForceExtension(JustFileName(FileName),JustExtension(GetPS(ra^.ArcName)))) then
   begin
    if KillExist then
     begin
      KillFile(FileName);
      MoveFile(GetPS(ra^.ArcName),ForceExtension(FileName,JustExtension(GetPS(ra^.ArcName))));
     end;
   end
  else
   begin
    KillFile(FileName);
    MoveFile(GetPS(ra^.ArcName),ForceExtension(FileName,JustExtension(GetPS(ra^.ArcName))));
   end;

  DelDir(RemoveBackSlash(s),true);
  if KeepTime then
   begin
    Assign(f,ForceExtension(FileName,JustExtension(GetPS(ra^.ArcName))));
    Reset(f);
    SetFTime(f,fTime);
    Close(f);
   end;
  with DescFiles^ do if Count>0 then for x:=0 to Count-1 do
   begin
    New(pd,Init(JustFileName(FileName)));
    if pDescCol(At(x))^.Search(pd,y) then
    ReallocStr(pDesc(pDescCol(At(x))^.At(y))^.FileName,
               ForceExtension(JustFileName(FileName),JustExtension(GetPS(ra^.ArcName))));
    DisposeObj(pd);
   end;

  PackedFileList^.Insert(NewStr(UpStr(ForceExtension(FileName,JustExtension(GetPS(ra^.ArcName))))));
  {$IfDef Win32}
  SetLength(TempName,Length(FileName));
  CharToOemBuff(@FileName[1],@TempName[1],Length(FileName));
  {$Else}
  TempName:=FileName;
  {$EndIf}
  WriteLn(qBracket1+JustFileName(TempName)+qBracket2+Space+'->'+Space+qBracket1+
          ForceExtension(JustFileName(TempName),JustExtension(GetPS(ra^.ArcName)))+qBracket2+' done!');
 end;


procedure tRaco.Run;
 var
  s,DirPath,Mask: String;
  x: Integer;
  f: File;
  Attr: Word;
 procedure SubVisit(var DirPath: String);
  var
   Looking4: SearchRec;
  begin
   Dos.FindFirst(Concat(DirPath,Mask),AnyFile,Looking4);
   while (DosError=0) do
    begin
     if (Looking4.Attr and (VolumeID+Directory))=0 then ProcessEveryFile(Concat(DirPath,Looking4.Name));
     Dos.FindNext(Looking4);
    end;
{$IfDef VirtualPascal}
   Dos.FindClose(Looking4);
{$EndIf}
   if Recurse then
    begin
     Dos.FindFirst(Concat(DirPath,StrPas(x_x)),AnyFile,Looking4);
     while (DosError=0) and (Looking4.Name[1]=Point) do Dos.FindNext(Looking4);
     while (DosError=0) do
      begin
       if (Looking4.Name[1]<>Point) and (((Looking4.Attr and Directory)=Directory)) then
        begin
         s:=Concat(DirPath,Looking4.Name,BackSlash);
         SubVisit(s);
        end;
       Dos.FindNext(Looking4);
      end;
    end;
{$IfDef VirtualPascal}
   Dos.FindClose(Looking4);
{$EndIf}
  end;
 begin
  DirPath:=GetPS(ArcMask);
  Mask:=JustFileName(DirPath);
  DirPath:=AddBackSlash(JustPathName(DirPath));
  SubVIsIt(DirPath);
  with DescFiles^ do if Count>0 then for x:=0 to Count-1 do
   begin
    Assign(f,GetPS(OldDir)+GetPS(FileList^.At(x)));
    GetFAttr(f,Attr);
    SetFAttr(f,0);
    if Exist(GetPS(OldDir)+GetPS(FileList^.At(x)))
    then pDescCol(At(x))^.Save(GetPS(OldDir)+GetPS(FileList^.At(x)),StrPas(cLongDesc));
    SetFAttr(f,Attr);
   end;
 end;

var
 raco: tRaco;

begin
 raco.Init;
 raco.Run;
 raco.Done;
end.
