%define	_noVersionedDependencies	1
%define	__prefix	/emx

Summary: The Red Hat package management system.
Summary(ja): Red Hat pbP[W}l[WgVXe
Name: rpm
%define version 3.0.6
Version: %{version}
Vendor: OS/2 RPM project
URL:   http://www2s.biglobe.ne.jp/~vtgf3mpr/
Release: 11
Group: System Environment/Base
Source: ftp://ftp.rpm.org/pub/rpm/dist/rpm-3.0.x/rpm-%{version}.tar.gz
Source1: exe.exe
Source2: bz2_100.dll
Source3: rx_t20.dll
Patch: rpm-%{version}-OS2.diff.gz
Copyright: GPL
Prereq: gawk fileutils textutils sh-utils
BuildRequires: bzip2 >= 0.9.0c, sh, gzip
Requires: popt, bzip2 >= 0.9.0c, sh, gzip, sed
#BuildRequires: python-devel >= 1.5.1
BuildRoot: /tmp/%{name}-root
Docdir: %{__prefix}/doc

%description
The Red Hat Package Manager (RPM) is a powerful command line driven
package management system capable of installing, uninstalling,
verifying, querying, and updating software packages.  Each software
package consists of an archive of files along with information about
the package like its version, a description, etc.

%description -l ja
The Red Hat Package Manager (RPM) ̓R}hCœ삷鋭͂
pbP[W}lWgVXełB\tgtFÃCXg[AA
CXg[AmFA₢킹AčXVł܂B\tgEFA
pbP[W͏ɉꂽt@CƃpbP[W̃o[We
Ă̏܂ł܂B


%package devel
Summary: Development files for applications which will manipulate RPM packages.
Group: Development/Libraries
#Requires: popt
#Requires: python >= 1.5.1

%description devel
This package contains the RPM C library and header files.  These
development files will simplify the process of writing programs
which manipulate RPM packages and databases and are intended to make
it easier to create graphical package managers or any other tools
that need an intimate knowledge of RPM packages in order to function.

This package should be installed if you want to develop programs that
will manipulate RPM packages and databases.

%prep
%setup -q
%patch -p1

%build
# CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr
configure --prefix=%{__prefix} --with-included-gettext
make
%ifos linux
make -C python
%endif

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT%{__prefix}/src/redhat/SOURCES
mkdir -p $RPM_BUILD_ROOT%{__prefix}/src/redhat/SPECS
mkdir -p $RPM_BUILD_ROOT%{__prefix}/src/redhat/SRPMS
mkdir -p $RPM_BUILD_ROOT%{__prefix}/src/redhat/BUILD
mkdir -p $RPM_BUILD_ROOT%{__prefix}/src/redhat/RPMS/${RPM_ARCH}
mkdir -p $RPM_BUILD_ROOT%{__prefix}/src/redhat/RPMS/noarch

make prefix="$RPM_BUILD_ROOT"%{__prefix} install
cp -p popt/popt15.dll "$RPM_BUILD_ROOT"%{__prefix}/dll/
cp -p "${RPM_SOURCE_DIR}"/exe.exe "$RPM_BUILD_ROOT"%{__prefix}/bin/
cp -p "${RPM_SOURCE_DIR}"/exe.exe "$RPM_BUILD_ROOT"%{__prefix}/bin/find-requires.exe
cp -p "${RPM_SOURCE_DIR}"/exe.exe "$RPM_BUILD_ROOT"%{__prefix}/bin/find-provides.exe
cp -p "${RPM_SOURCE_DIR}"/rx_t20.dll "$RPM_BUILD_ROOT"%{__prefix}/dll/
cp -p "${RPM_SOURCE_DIR}"/bz2_100.dll "$RPM_BUILD_ROOT"%{__prefix}/dll/
%ifos linux
make DESTDIR="$RPM_BUILD_ROOT"%{__prefix} install -C python
%endif
cp %{_specdir}/rpm-%{version}-os2.spec $RPM_BUILD_ROOT%{__prefix}/src/redhat/SPECS

%clean
rm -rf $RPM_BUILD_ROOT

%post
#/bin/rpm --initdb
#%ifos linux
#if [ ! -e /etc/rpm/macros -a -e /etc/rpmrc -a -f /usr/lib/rpm/convertrpmrc.sh ] 
#then
#	sh /usr/lib/rpm/convertrpmrc.sh 2>&1 > /dev/null
#fi
#%endif


%files
%doc RPM-PGP-KEY CHANGES GROUPS doc/manual/* *.os2
%{__prefix}/.rpmrc
%{__prefix}/.popt
%{__prefix}/.rpmmacros
%{__prefix}/bin/exe.exe
%{__prefix}/bin/gendiff
%{__prefix}/bin/mkinstalldirs
%{__prefix}/bin/find-provides
%{__prefix}/bin/find-requires
%{__prefix}/bin/find-provides.exe
%{__prefix}/bin/find-requires.exe
%{__prefix}/bin/rpm.exe
%{__prefix}/bin/rpm2cpio.exe
%{__prefix}/man/man1/gendiff.1
%{__prefix}/man/man3/popt.3
%{__prefix}/man/man8/rpm.8
%{__prefix}/man/man8/rpm2cpio.8
%{__prefix}/man/ja/man8/rpm.8
%{__prefix}/man/ja/man8/rpm2cpio.8
%{__prefix}/man/ru/man8/rpm.8
%{__prefix}/man/ru/man8/rpm2cpio.8
%{__prefix}/man/pl/man8/rpm.8
%{__prefix}/dll/rpm306.dll
%{__prefix}/dll/popt15.dll
%{__prefix}/dll/rx_t20.dll
%{__prefix}/dll/bz2_100.dll
%{__prefix}/lib/rpm/*
%ifos linux
/usr/lib/python1.5/site-packages/rpmmodule.so
%endif
%dir %{__prefix}/src/redhat
%dir %{__prefix}/src/redhat/BUILD
%dir %{__prefix}/src/redhat/SPECS
%dir %{__prefix}/src/redhat/SOURCES
%dir %{__prefix}/src/redhat/SRPMS
%dir %{__prefix}/src/redhat/RPMS
%{__prefix}/src/redhat/RPMS/*
%{__prefix}/share/locale/*/LC_MESSAGES/rpm.mo


%files devel
%{__prefix}/include/popt.h
%{__prefix}/include/rpm/*
%{__prefix}/dll/rpm306.dll
%{__prefix}/dll/popt15.dll
%{__prefix}/lib/rpm306.a
%{__prefix}/lib/librpmbuild.a
%{__prefix}/lib/popt15.a


%changelog
* Mon Feb 19 2001 Jun Sawataishi <jsawa@attglobal.net>
-   Bug fix: created binary/source rpm package was __not__ compressed
            by zlib or bzlib. 

* Thu Jan 25 2001 Jun Sawataishi <jsawa@attglobal.net>
- Bug fix: Handling of rpm package via HTTP/FTP failed

* Sat Nov  4 2000 Jun Sawataishi <jsawa@attglobal.net>
- find-requires script improved using `ldd.exe', thanks to 
  Shigeru MIYATA <miyata@kusm.kyoto-u.ac.jp>

* Wed Nov  1 2000 Jun Sawataishi <jsawa@attglobal.net>
- updated OS/2 port

* Wed Sep 13 2000 Jeff Johnson <jbj@redhat.com>
- add conflict to avoid incompatible libio interface in glibc-2.2.
- rpm 3.0.6 release.

* Wed Sep 13 2000 Jeff Johnson <jbj@redhat.com>
- popt: support for float/double args.
- fix: honor --test when doing --freshen.
- add alpha* architectures.

* Tue Aug 29 2000 Jeff Johnson <jbj@redhat.com>
- translate rpm.8 man page (Peter Ivanyi <ivanyi@internet.sk>).

* Wed Aug 23 2000 Jeff Johnson <jbj@redhat.com>
- macroize manpath to build on FHS systems.

* Sun Aug 20 2000 Jeff Johnson <jbj@redhat.com>
- python bindings to query and verify signatures.
- add callbacks on package erasure.
- fix: preserve cpio errno when using Fclose with libio.
- fix: initialize sigs everywhere in python header object.

* Thu Aug 10 2000 Jeff Johnson <jbj@redhat.com>
- disable rpmlib(VersionedDependencies) by defining _noVersionedDependencies.

* Sat Jul 22 2000 Jeff Johnson <jbj@redhat.com>
- build rpm with necessary autoconf options to get linux config correct.

* Thu Jul 20 2000 Jeff Johnson <jbj@redhat.com>
- fix: Red Hat 6.0 (5.2?) glibc-2.1.1 fclose fails using libio.
- add /usr/kerberos/man to brp-compress.

* Sun Jul 16 2000 Jeff Johnson <jbj@redhat.com>
- remove (unused) RPMTAG_CAPABILITY.
- remove (legacy) use of RPMTAG_{OBSOLETES,PROVIDES} internally.
- remove (legacy) support for version 1 packaging.
- remove (legacy) support for converting gdbm databases.
- eliminate unused headerGz{Read,Write}.
- support for rpmlib(...) internal feature dependencies.
- display rpmlib provides when invoked with --showrc.
- fix: compare versions if doing --freshen.

* Tue Jul 11 2000 Jeff Johnson <jbj@redhat.com>
- identify package when install scriptlet fails (#12448).

* Sun Jul  9 2000 Jeff Johnson <jbj@redhat.com>
- fix: payload compression tag not nul terminated.

* Thu Jun 22 2000 Jeff Johnson <jbj@redhat.com>
- internalize --freshen (Gordon Messmer <yinyang@eburg.com>).
- support for separate source/binary compression policy.
- support for bzip payloads.

* Wed Jun 21 2000 Jeff Johnson <jbj@redhat.com>
- fix: don't expand macros in false branch of %if (kasal@suse.cz).
- fix: macro expansion problem and clean up (#11484) (kasal@suse.cz).
- uname on i370 has s390 as arch (#11456).
- python: initdb binding (Dan Burcaw <dburcaw@terraplex.com>).

* Tue Jun 20 2000 Jeff Johnson <jbj@redhat.com>
- handle version 4 packaging as input.
- builds against bzip2 1.0
- fix: resurrect symlink unique'ifying property of finger prints.
- fix: broken glob test with empty build directory (Geoff Keating).
- fix: create per-platform directories correctly.
- update brp-* scripts from rpm-4.0, enable in per-platform config.
- alpha: add -mieee to default optflags.
- add RPMTAG_OPTFLAGS, configured optflags when package was built.
- add RPMTAG_DISTURL for rpmfind-like tools (content unknown yet).
- teach brp-compress about /usr/info and /usr/share/info as well.
- update macros.in from rpm-4.0 (w/o dbi configuration).

* Thu Mar 15 2000 Jeff Johnson <jbj@redhat.com>
- portability: skip bzip2 if not available.
- portability: skip gzseek if not available (zlib-1.0.4).
- portability: skip personality if not available (linux).
- portability: always include arpa/inet.h (HP-UX).
- portability: don't use id -u (Brandon Allbery).
- portability: don't chown/chgrp -h w/o lchown.
- portability: splats in rpm.spec to find /usr/{share,local}/locale/*
- fix: better filter in linux.req to avoid ARM specific objdump output.
- fix: use glibc 2.1 glob/fnmatch everywhere.
- fix: noLibio = 0 on Red Hat 4.x and 5.x.
- fix: typo in autodeps/linux.req.

* Thu Mar  2 2000 Jeff Johnson <jbj@redhat.com>
- simpler hpux.prov script (Tim Mooney).

* Wed Mar  1 2000 Jeff Johnson <jbj@redhat.com>
- fix rpmmodule.so python bindings.

* Sun Feb 27 2000 Jeff Johnson <jbj@redhat.com>
- rpm-3.0.4 release candidate.

* Fri Feb 25 2000 Jeff Johnson <jbj@redhat.com>
- fix: filter excluded paths before adding install prefixes (#8709).
- add i18n lookaside to PO catalogue(s) for i18n strings.
- try for /etc/rpm/macros.specspo so that specspo autoconfigures rpm.
- per-platform configuration factored into /usr/lib/rpm subdir.

* Tue Feb 15 2000 Jeff Johnson <jbj@redhat.com>
- new rpm-build package to isolate rpm dependencies on perl/bash2.
- always remove duplicate identical package entries on --rebuilddb.
- add scripts for autogenerating CPAN dependencies.

* Wed Feb  9 2000 Jeff Johnson <jbj@redhat.com>
- brp-compress deals with hard links correctly.

* Mon Feb  7 2000 Jeff Johnson <jbj@redhat.com>
- brp-compress deals with symlinks correctly.

* Mon Jan 24 2000 Jeff Johnson <jbj@redhat.com>
- explicitly expand file lists in writeRPM for rpmputtext.

