#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <errno.h>
#include <sys/param.h>
#define INCL_DOSMODULEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include "which2.h"

static const char * const ext_list[] =
{
  ".com", ".exe", ".cmd", NULL
};

static int try_dir (const char *dir, const char *name)
{
  char path[MAXPATHLEN];
  const char *p, *q;
  size_t len;
  int ok, i;

  ok = FALSE;
  if (strlen (dir) >= sizeof (path))
    return ok;
  strcpy (path, dir);
  len = strlen (path);
  if (len > 0 && !IS_DELIM (path[len-1]))
    {
      if (len + 1 >= sizeof (path))
        return ok;
      path[len++] = (strchr (path, '/') != NULL ? '/' : '\\');
      path[len] = 0;
    }
  if (strlen (path) + strlen (name) >= sizeof (path))
    return ok;
  strcat (path, name);
  q = path;
  for (p = path; *p != 0; ++p)
    if (IS_DELIM (*p))
      q = p + 1;
  if (strchr (q, '.') != NULL)
    {
      if (access (path, 4) == 0)
        {
          printf ("%s\n", path);
          ok = TRUE;
        }
    }
  len = strlen (path);
  if (!((len > 0 && path[len-1] == '.') || len + 4 >= sizeof (path)))
    {
      for (i = 0; ext_list[i] != NULL; ++i)
        {
          strcpy (path+len, ext_list[i]);
          if (access (path, 4) == 0)
            {
              printf ("%s\n", path);
              ok = TRUE;
            }
        }
    }
  return ok;
}

static int find_prog (const char *name, const char *path)
{
  int ok;
  size_t len;
  char dir[MAXPATHLEN];
  const char *list, *end;

  ok = try_dir ("", name);
  if (path != NULL && strpbrk (name, "/\\:") == NULL)
    {
      list = path;
      for (;;)
        {
          while (*list == ' ' || *list == '\t') ++list;
          if (*list == 0) break;
          end = list;
          while (*end != 0 && *end != ';') ++end;
          len = end - list;
          while (len != 0 && (list[len-1] == ' ' || list[len-1] == '\t'))
            --len;
          if (len != 0 && len < sizeof (dir))
            {
              memcpy (dir, list, len);
              dir[len] = 0;
              ok |= try_dir (dir, name);
            }
          if (*end == 0) break;
          list = end + 1;
        }
    }
  if (!ok)
    fprintf (stderr, "%s not found\n", name);
  return ok;
}

int which (char *filename)
{
  int i;
  const char *path;

  path = getenv ("PATH");
  if (!find_prog (filename, path))
     return 2;
  return 0;
}
