/******************************************************************************
* Module:   DSWkly.cmd
* Desc:     This does a (weekly) full DualStor backup of the list of drives
* Inputs:   On the command line, specify a space separated list of drives to
*			be backed up to the same tape; i.e.
*
*			DSWkly c d e
*
*			will backup drives c:, d:, and e: to the same tape(s)
* Outputs:  Disks are backed up
* Errors:   
******************************************************************************/

/*  Bring in the OS/2 function library   */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

/* trace ?I */

?low = 'C'   /* lowest disk mode letter */
?hi  = 'Z'   /* highest disk mode letter*/

/* Get the disk letter(s).  Make them upper case while we're at it */
Parse Upper Arg ?disklist

/* Put them into a compound symbol */
?count = 0
?disks = ""
Do Until ?disklist = ""
	/* Get the next disk letter */
	Parse Var ?disklist ?drive.?count ?disklist
	?drive.?count = Left(?drive.?count, 1)
	?disks = ?disks'-'?drive.?count
	If ?drive.?count < ?low | ?drive.?count > ?hi Then
		Signal Err1  /* check disk arg */
	?count = ?count + 1
End

/* Retension the tape */
?backup_job = '!util /w cn /r'
Call DoAJob ?backup_job

/* Init the tape */
?backup_job = '!init /w cn /i'
Call DoAJob ?backup_job

/* Set the tape to unused */
?backup_job = '!util /w cn /u'
Call DoAJob ?backup_job

/* Name the tape */
?backup_job = '!util /w cn /n "Disk'?disks'-Larry Waibel Backup"'
Call DoAJob ?backup_job

/* Make up the backup .TPF command line    */
?backup_job = "!backup /m /u /w cnso"
/* Now loop through the letters, backing them onto the same tape */
?current = 0
Do While ?current < ?count
	?backup_job = ?backup_job" /b rhs /c 2 /e f /g",
				" /n Weekly"?drive.?current" /q /v /s "?drive.?current":\*.*"
	?current = ?current + 1
End

/* Now do the backup */
Call DoAJob ?backup_job

Exit

 /* $Page */
/******************************************************************************
* Module:   DoAJob
* Desc:     This turns the job line into a .tpf file and executes it
* Inputs:   The job line to be executed
* Outputs:  None
* Errors:   
******************************************************************************/
DoAJob:

?job = ARG(1)

/* Erase old file   */
rc = SysFileDelete('$WORK$.TPF')
If rc > 2 Then Signal Err2

Say "Doing job="?job       /* Remove this at some point   */

/*Return*/

rc = Lineout('$WORK$.TPF', ?job, 1)  /* Write the file  */
If rc \= 0 Then
	Signal Err3   /* Error writing the file  */

rc = Lineout('$WORK$.TPF')  /* Close the file  */
If rc \= 0 Then
	Signal Err3  /* error closing the file  */

/* Execute the job   */
'Dualstrp .\$WORK$'
If rc \= 0 ,
	Then Do
		Say "*** JOB FOR '"?disks"' COMPLETED WITH ERROR OF "rc" ***"
		Select
			When rc = 1 Then
				Say "No tape cartridge in drive"
			When rc = 2 Then
				Say "Tape is full, cannot write"
			When rc = 3 Then
				Say "Tape is write protected"
			When rc = 4 Then
				Say "Mount failed or incompatible tape"
			When rc = 5 Then
				Say "Invalid command line arguments"
			When rc = 6 Then
				Say "Fatal disk error"
			When rc = 7 Then
				Say "Not enough memory available to run"
			When rc = 8 Then
				Say "No tape drive present"
			When rc = 9 Then
				Say "User aborted operation"
			When rc = 10 Then
				Say "Fatal tape error"
			When rc = 11 Then
				Say "Critical verify failure, backup set deleted"
			When rc = 12 Then
				Say "Internal software error"
			When rc = 13 Then
				Say "Disk full on restore"
			When rc = 14 Then
				Say "Disk full in \temp directory"
			When rc = 15 Then
				Say "No files selected"
			When rc = 17 Then
				Say "Non-critical verify warning (Verify miscompares seen in Session log)"
			Otherwise
				Say "Unknown error code"
		End
		Pause
		Exit rc
	End

Return

/***** Errors  Errors  Errors  Errors  Errors  Errors     *******/
Err1:
  Say "*** Hey Dude, you put in garbage for the disk letter ***"
  Pause
  Exit 100   /* Exit with a return code of 100  */

Err2:
  Say "*** Error deleting old $WORK$.TPF file ***"
  Pause
  Exit rc   /* Return the error code received  */

Err3:
  Say "*** Error creating new $WORK$.TPF file ***"
  Pause
  Exit rc   /* Return the error code received  */

