/* RxBMWdrv.cmd                                                    */
/* Load RexxUtil, and RexxLib libraries                            */

IF ADDRESS()<>'RXDLG' THEN
  DO
       SAY 'The REXX Dialog package is required to run RxBMWdrv.cmd'
       EXIT
  END

CALL RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
CALL SysLoadFuncs
CALL RxFuncAdd 'RexxLibRegister', 'REXXLIB', 'RexxLibRegister'
CALL RexxLibRegister
/* Trap ERROR and FAILURE                                          */
SIGNAL ON ERROR
SIGNAL ON FAILURE
RXERR 'FULL'
/* scan all drives and determine window size and position          */
CALL scanDrives
CALL windowSetup
/* =============== Create "Available Drives" Window ============== */

/* Sized to fit a screen with 800x600 or higher resolution         */
drvWindowTitle = '"Available Drives"'
numDrvWindowControls = 8
rescan:
numDrvLines = numDrives + 2

/* determine lower vertical (y) coordinate for text controls       */
/* minimum pels = 75, maximum pels = 455 (position for last drive) */
yMax  = 455
yPosition = MAX(TRUNC(yMax - (numDrvLines * 14) , 0), 75)

/* first control: a button to exit                                 */
RXTYPE.1 = 'PUSH'
RXFLAGS.1 = 'END'
RXLABEL.1 = 'Exit'
RXINFO.1 = '1 1 125'
RXX.1 = 510
RXY.1 = 32
RXVAL.1 = ' '

/* second control: a button to scan the drives again               */
RXTYPE.2 = 'PUSH'
RXFLAGS.2 = 'END'
RXLABEL.2 = 'UPDATE'
RXINFO.2 = '1 1 125'
RXX.2 = 310
RXY.2 = 32
RXVAL.2 = ' '

/* third control: a text window to display drive letter & Label    */
RXTYPE.3 = 'TEXT'
RXFLAGS.3 = 'LEFT'
tempLabel = ' '
RXLABEL.3 = ' '
RXINFO.3 = numDrvLines '1 160'
RXX.3 = 20
RXY.3 = yPosition
RXVAL.3 = ' '

/* fourth control: a text window to display drive capacity         */
RXTYPE.4 = 'TEXT'
RXFLAGS.4 = 'RIGHT'
tempLabel = ' '
RXLABEL.4 = ' '
RXINFO.4 = numDrvLines '1 90'
RXX.4 = 175
RXY.4 = yPosition
RXVAL.4 = ' '

/* fifth control: a text window to display drive free capacity     */
RXTYPE.5 = 'TEXT'
RXFLAGS.5 = 'RIGHT'
tempLabel = ' '
RXLABEL.5 = ' '
RXINFO.5 = numDrvLines '1 90'
RXX.5 = 275
RXY.5 = yPosition
RXVAL.5 = ' '

/* sixth control: a text window to display drive used capacity     */
RXTYPE.6 = 'TEXT'
RXFLAGS.6 = 'RIGHT'
tempLabel = ' '
RXLABEL.6 = ' '
RXINFO.6 = numDrvLines '1 90'
RXX.6 = 375
RXY.6 = yPosition
RXVAL.6 = ' '

/* seventh control: a text window to display drive file system     */
RXTYPE.7 = 'TEXT'
RXFLAGS.7 = 'LEFT'
tempLabel = ' '
RXLABEL.7 = ' '
RXINFO.7 = numDrvLines '1 90'
RXX.7 = 475
RXY.7 = yPosition
RXVAL.7 = ' '

/* eigth control: a text window to display drive location          */
RXTYPE.8 = 'TEXT'
RXFLAGS.8 = 'LEFT'
tempLabel = ' '
RXLABEL.8 = ' '
RXINFO.8 = numDrvLines '1 90'
RXX.8 = 575
RXY.8 = yPosition
RXVAL.8 = ' '

RXDLG numDrvWindowControls drvWindowTitle 'WINDOWSIZE'  'NOCLOSE'

/* load Title and spacer for each field                            */
RXSET drvWindowTitle 3 1 'VAL'  'DRIVE and LABEL'
RXSET drvWindowTitle 4 1 'VAL'  'TOTAL Mb'
RXSET drvWindowTitle 5 1 'VAL'  'FREE Mb'
RXSET drvWindowTitle 6 1 'VAL'  'USED Mb'
RXSET drvWindowTitle 7 1 'VAL'  'FILE SYS'
RXSET drvWindowTitle 8 1 'VAL'  'TYPE   '

RXSET drvWindowTitle 3 2 'VAL' '----------------'
RXSET drvWindowTitle 4 2 'VAL' '---------'
RXSET drvWindowTitle 5 2 'VAL' '--------'
RXSET drvWindowTitle 6 2 'VAL' '--------'
RXSET drvWindowTitle 7 2 'VAL' '--------'
RXSET drvWindowTitle 8 2 'VAL' '-------'

DO i = 1 TO numDrives
     j = i + 2
     RXSET drvWindowTitle 3 j 'VAL'  drvInfo.i.drvLetter||' '||drvInfo.i.drvLetter.label
     RXSET drvWindowTitle 4 j 'VAL'  Format( (drvInfo.i.drvLetter.size / 1024) / 1024 , , 2)
     RXSET drvWindowTitle 5 j 'VAL'  Format( (drvInfo.i.drvLetter.free / 1024) / 1024 , , 2)
     RXSET drvWindowTitle 6 j 'VAL'  Format( (drvInfo.i.drvLetter.used / 1024) / 1024 , , 2)
     RXSET drvWindowTitle 7 j 'VAL'  drvInfo.i.drvLetter.fileSys
     RXSET drvWindowTitle 8 j 'VAL'  drvInfo.i.drvLetter.type
END

drmore:
RXDLG drvWindowTitle 0
IF RXID < 0 THEN  CALL closeUp
IF RXID = 1 THEN CALL closeUp

/* Scan for new or updated drives                                  */
IF RXID = 2 THEN
  DO
       CALL scanDrives
       RXDLG drvWindowTitle 4
       SIGNAL reScan
  END

SIGNAL drmore
EXIT

windowSetup:
/* Window size is: 'width height xpos ypos' (in pixels)            */
/* get the current resolution                                      */
   parse value GetDisplayResolution() with ,
         xResolution yResolution ColorDepth resolutionChangePending
IF xResolution < 800 | yResolution < 600 then do
RXSAY 'The display resolution is 'xResolution'x'yResolution
RXSAY 'RxBMW requires at least '||CRLF|| '800x600 resolution for proper display |' 7 'Error'
end
winWidth  = 725
winHeight = 540
xpos = Trunc((xResolution - winWidth) / 2) + 20
ypos = Trunc((yResolution - winHeight) / 2) + 20
windowSize = winWidth winHeight xpos ypos
/* determine vertical (y) coordinate for controls                  */
yPosition = 100
RETURN

GetDisplayResolution: PROCEDURE
/* taken from REXX tips & Tricks                                   */
/* function: Get the current display resolution                    */
/* call:     GetDisplayResolution                                  */
/* returns:  xValue yValue depth changePending                     */
/* where:    xValue - horizontal size                              */
/*           yValue - vertical size                                */
/*           depth  - colorDepth                                   */
/*           changePending - 1 = the resolution was changed but no */
/*                               reboot occurred until now         */
/*                           0 = the resolution is active          */
/* note:  unknown1 and unknown2 are unknown values in the INI file */
/*        entry (see below).                                       */
/*        This routine needs the REXXUTIL function SYSINI and the  */
/*        subroutine LSB2MSB                                       */
/* init the return code                                            */
PARSE VALUE 0 0 0 0 WITH xValue yValue colorDepth changePending

SIGNAL ON syntax name GetDisplayValueError
/* get the current resolution                                      */
resolutionEntryInBin = SysIni("USER", "PM_DISPLAYDRIVERS", "DEFAULTSYSTEMRESOLUTION")
/* check, if a resolution change is pending                        */
resolutionChangePending = SysIni("USER", "PM_DISPLAYDRIVERS", "RESOLUTION_CHANGED")
    if resolutionChangePending = "1" || "00"x then
      resolutionChangePending = 1
    else
      resolutionChangePending = 0

/* convert the value into a hex string                             */
resolutionEntryInHex = c2x(resolutionEntryInBin)
PARSE VAR resolutionEntryInHex  1 xValue  9 yValue  17 ColorDepth  25 unknown1  33 unknown2

/* convert the values into decimal values                          */
xValue     = x2d(LSB2MSB( xValue ))
yValue     = x2d(LSB2MSB( yValue ))
ColorDepth = x2d(LSB2MSB( ColorDepth ))

/* not returned or used in this version                            */
unknown1   = x2d(LSB2MSB( unknown1 ))
unknown2   = x2d(LSB2MSB( unknown2 ))

/* this label is only used by the local error handler              */
GetDisplayValueError:

RETURN xValue yValue colorDepth resolutionChangePending

LSB2MSB: PROCEDURE
/* taken from REXX tips & Tricks                                   */
/* Converts  WORD or DWORD from LSB MSB format & vice versa        */
/* call:     LSB2MSB inputHexString                                */
/* where:    inputHexstring - input value as hexstring             */
/*                            (e.g. "3412", "78563412")            */
/* output:   value in MSB format as hexstring                      */
/*           (e.g. "1234", "12345678")                             */
   HexZiffer = arg(1)                                     /* v3.00 */
   Len = Length(HexZiffer)                                /* v3.00 */
   If (Len // 2) then                                     /* v3.00 */
      HexZiffer = Right(HexZiffer, Len + 1, '0')          /* v3.00 */
RETURN strip(translate("12345678", HexZiffer, "78563412"))/* v3.00 */


scanDrives:
/*              numDrives                    Number of drives      */
/*              drvInfo.#.drvLetter          Drive letter, ex. C:  */
/*              drvInfo.#.drvLetter.label    Drive label           */
/*              drvInfo.#.drvLetter.size     Total size in Mbytes  */
/*              drvInfo.#.drvLetter.free     Free space in Mbytes  */
/*              drvInfo.#.drvLetter.used     Used space in Mbytes  */
/*              drvInfo.#.drvLetter.filesys  File system type      */
/*              drvInfo.#.drvLetter.type     Either LOCAL, or REMOTE*/
IF nfsLabels = Y THEN CALL nfsDrvLabels

/* Get list of all drives                                          */
localDrives = SysDriveMap('A:' , 'Local')
remoteDrives = SysDriveMap('C:' , 'Remote')
allDrives = localDrives ||' '|| remoteDrives
/* Place details in drvInfo compound variable                      */
count = 0
DO   i = 1 TO Words(allDrives)
     count = count + 1
     drvInfo.count.drvLetter = Word(allDrives , i)
     drvFreeSizeLabel = SysDriveInfo(drvInfo.count.drvLetter)
     freeSpace =  Word(drvFreeSizeLabel, 2)
     IF Datatype(freeSpace) <> 'NUM' THEN  freeSpace = 0
     totalSpace = Word(drvFreeSizeLabel, 3)
     IF Datatype(totalSpace) <> 'NUM' THEN totalSpace = 0
     indexOfLabel =  WordIndex(drvFreeSizeLabel, 4)
     IF indexOfLabel <> 0 then
     drvInfo.count.drvLetter.label = STRIP( SUBSTR(drvFreeSizeLabel, indexOfLabel), 'T')
     ELSE
         DO
            IF totalSpace = 0 THEN drvInfo.count.drvLetter.label = '**not ready**'
            ELSE drvInfo.count.drvLetter.label = ' '
         END
     drvInfo.count.drvLetter.fileSys = Dosfilesys(drvInfo.count.drvLetter)
/* get label for NFS drives - use the last 11 characters of        */
/* the NFS server mountpoint specified in the mount command        */
     IF (drvInfo.count.drvLetter.fileSys = 'NFS') & (nfsLabels = Y) THEN
      DO k = 1 to nfsData.0
         rxsay 'NFS drive = 'drvinfo.count.drvLetter
           IF drvInfo.count.drvLetter = nfsData.k.drv
           THEN drvInfo.count.drvLetter.label = nfsData.k.drv.alias
      END

    IF drvInfo.count.drvLetter.fileSys = 'UNKNOWN' THEN
       DO
            drvInfo.count.drvLetter.size = 0.0
            drvInfo.count.drvLetter.free = 0.0
            drvInfo.count.drvLetter.used = 0.0
       END /* do */
       ELSE
         DO
            drvInfo.count.drvLetter.size =  totalSpace
            drvInfo.count.drvLetter.free =  freeSpace
            drvInfo.count.drvLetter.used  =  drvInfo.count.drvLetter.size - drvInfo.count.drvLetter.free
         END
     IF (Wordpos(drvInfo.count.drvLetter, remoteDrives) > 0) THEN
       drvInfo.count.drvLetter.type  = 'REMOTE'
       ELSE
         drvInfo.count.drvLetter.type = 'LOCAL'
END
numDrives = count
RETURN

nfsDrvLabels:
/* Use qmount.exe to get data about NFS mounted drives             */
IF  SysSearchPath('PATH', 'QMOUNT.EXE') <> '' THEN
  DO
    ADDRESS 'CMD' 'QMOUNT.exe > NFSlabel.txt'
    fileError = FILESEARCH(NFSlabel.txt, 'NFS'||TAB, 'NFSdata', 'S')
    IF fileError < 0 THEN RETURN
    IF nfsData.0 > 0 THEN
      DO i = 1 TO nfsData.0
        nfsData.i.drv = SUBSTR(nfsData.i, 8, 2)
        tempString = STRIP(SUBSTR(nfsData.i, 16) ,T)
        colonPosition = POS(':', tempString)
        nfsData.i.drv.alias = SUBSTR(tempString, colonPosition + 1)
      END
  END
RETURN

closeUp:
/* Did user click upon the CLOSE ICON? If so, then exit                */
EXIT

failure:
/* NOTE: the variable RC contains the returned error message, not  */
/* a number, unless we use RXERR to set up Rexx Dialog to return   */
/* error numbers instead.                                          */
/* Because we used the default severity level, Rexx Dialog already */
/* displayed this error message to the enduser                     */
EXIT

error:
EXIT
