/* Let's make a window and associate the .HLP file 'test.hlp' (created
    with OS/2's Information Presentation Facility Compiler, IFPC) with
    that window.  Then, when the user clicks upon the OK button. We'll
    display a panel named TEST.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* ====================== 'Main Window' ======================= */
RXTYPE.1 = 'RESULT'

/* Return a 1 for OK, YES, RETRY, ENTER, etc. Return a 1 for
    CANCEL, NO, IGNORE, etc. No need to set 'END' since
    RESULTBUTTON group always causes RXDLG to return */
RXFLAGS.1 = 'BOOL'

/* No groupbox */
RXLABEL.1 = ' '

/* Give me "Ok" */
RXINFO.1 = '2'

/* RXVAL is Irrelevant for RESULTBUTTON */

/* Position */
RXX.1 = 10
RXY.1 = 10

/* Default size and position (also gives us sizing and max button) */
RXWINMAIN = ' '
RXDLG 1 '"Main Window"' 'RXWINMAIN' 'RESULT|NOCLOSE'

/* Associate the help file */
RXHELP 'CREATE' '""' 'TEST.HLP'

/* ============= Message loop on the dialog windows ============ */
more:
   /* Do user interaction. We sleep now */
   RXDLG

   /* Did user press ESC or CLOSE the window? */
   IF RXID < 0 THEN DO
       EXIT
   END

   /* Display panel named TEST. Note that, in TEST.IPF, we gave the panel
       a number of 1000, so RXHELP 1000 would also work here */
   RXHELP 'TEST'

   SIGNAL more

/* =================================================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
