/*****************************************************************************/
/*                                                                           */
/*  Programmname  : PMRouMon.C                                               */
/*  Verwendung    :                                                          */
/*  Bibliotheken  :                                                          */
/*  Autor         : Dipl.Ing. Jrgen Dittmer                                 */
/*  Speichermodell: OS/2                                                     */
/*  Compiler      : WATCOM C/C++ v. 10.0                                     */
/*  System        :                                                          */
/*  Erstellung    : 19 Feb 2002                                              */
/*  nderung      : 20 Mai 2002 - Rx/Tx speed in kBit/s                      */
/*                  26 Dez 2002 - Disconnect WAN MB1 DBLCLK and Menuitem     */
/*                  17 Feb 2003 - Zustzlicher Disconnect-Test               */
/*****************************************************************************/

#define INCL_WIN
#define INCL_GPI
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#define INCL_DOSSEMAPHORES
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_DOSFILEMGR
#define INCL_DOSMISC

#include <os2.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "nvt.h"
#include "PMRouMon.h"
#include "Dialog.h"


/*********************/
/* Globale Variablen */
/*********************/

HAB     hab;
HMQ     hmq;
HWND    hwndClient, hwndClientFrame;
PROFIL  profil;
//PPROFIL pprofil = &profil;
HNVT    hnvt;
char    status[MAXWORDSIZE];
char    uptime[MAXWORDSIZE];
char    ip[MAXWORDSIZE];
char    lastuptime[MAXWORDSIZE];
int     itxbs, irxbs;   /* 20 Mai 2002 - Umwandlung von ascii in int in telnetthread */


/*********************/
/*  Funktionen       */
/*********************/

int main (void);
MRESULT EXPENTRY ClientWndProc   (HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);
MRESULT EXPENTRY SettingsDlgProc (HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);
MRESULT EXPENTRY ProdinfoDlgProc (HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);
void TelnetThread   (void *parm);
extern int ReadPrf  (HAB, PPROFIL);
extern int WritePrf (HAB, PPROFIL);


/*******************************************************************/
/* Initialisierung des PM, Erstellung der MSG-Queue und Semaphoren */
/*******************************************************************/

int main(void)
{                                                                          
QMSG    qmsg;
ULONG   ClientStyleFlags =  FCF_DLGBORDER |
                            FCF_NOBYTEALIGN |
                            FCF_TASKLIST;

    strcpy (profil.pszIP, "192.168.1.1");
    strcpy (profil.pszPass, "1234");
    profil.swpclient.cx = 355;
    profil.swpclient.cy = 220;
    profil.swpclient.x = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN) - profil.swpclient.cx;
    profil.swpclient.y = 26;
    profil.swpclient.fl = SWP_SIZE | SWP_SHOW | SWP_MOVE;
    profil.itxmax = 1;                                                                                                  
    profil.irxmax = 1;
    profil.iLog   = 0;
    ReadPrf (hab, &profil); /* Lesen der PMIrq.INI */

    hab = WinInitialize (0);
    hmq = WinCreateMsgQueue (hab, 0);
    WinRegisterClass (hab, "Hauptfenster",  ClientWndProc, 0L, 0);

    hwndClientFrame = WinCreateStdWindow (HWND_DESKTOP,
                        WS_ANIMATE,
                        &ClientStyleFlags,
                        "Hauptfenster",
                        "ADSL Router Monitor",
                        WS_VISIBLE,
                        (HMODULE)0,
                        ID_ClientWindow,
                        &hwndClient);

    WinSetWindowPos (hwndClientFrame, HWND_TOP, profil.swpclient.x, profil.swpclient.y,
        profil.swpclient.cx, profil.swpclient.cy, profil.swpclient.fl);

    while (WinGetMsg (hab,&qmsg,0L,0,0))
       WinDispatchMsg (hab,&qmsg);

    WritePrf (hab, &profil);
    WinDestroyWindow (hwndClientFrame);
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);
    return 0;
}


/*************************/
/*   Fensterprozeduren   */
/*************************/

MRESULT EXPENTRY ClientWndProc (HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
HPS          hps;
POINTL       ptl, box;
RECTL        rectl;
HWND         hwndFrame;
SWP          Position;
TRACKINFO    TrackInfo;
static HWND  hwndPopupMenu;
int          tid;
FONTMETRICS  fm;
static ULONG ulLineSpace, ulTab;
FILE         *fp;
time_t       time_of_day;
char         buffer[20];

    switch (msg)
    {
    case WM_CREATE:

        tid = _beginthread (TelnetThread, 0, 8192, 0);;
        if (tid == -1) {
            WinMessageBox (HWND_DESKTOP, hwnd, "Can not establish Telnet connection to Router!", NULL, NULL, MB_ERROR | MB_ENTER);
            exit (FALSE);
        }
        WinStartTimer (hab, hwnd, ID_TIMER, 1000); 
        WinSetPresParam (hwnd, PP_FONTNAMESIZE, FONTLEN, profil.pszFont);
        break;

    case WM_DESTROY:
        WinStopTimer (hab, hwnd, ID_TIMER);
        nvtclose (hnvt);
        break;

    case WM_TIMER:
        /* Check if we just disconnected */
        if (profil.iLog && (strcmp(lastuptime, uptime) == 1) && (strncmp(uptime, "0:00:00", 7) == 0)) {
            time_of_day = time (NULL);
            strftime (buffer, 20, "%Y/%m/%d %X" , localtime (&time_of_day));
            fp = fopen ("Router.Log", "a");
            fprintf (fp, "%s %s\n", buffer, lastuptime);
            fclose (fp);
            //DosBeep (200,200);
        } /* endif */
        strcpy (lastuptime, uptime);
        WinInvalidateRect (hwndClient, NULL, TRUE);     /* Fenster neu zeichnen, WM_PAINT */
        break;        

    case WM_PAINT:
        hps = WinBeginPaint (hwnd, NULLHANDLE, &rectl);
        WinFillRect (hps, &rectl, CLR_BLACK);
        GpiSetColor (hps, CLR_GREEN);

        ptl.x = 2;
        ptl.y = 3;
        GpiCharStringAt (hps, &ptl, 10L, "Tx [kb/s]:");
        ptl.x = ulTab;
        itoa(itxbs, buffer, 10);                       
        GpiCharStringAt (hps, &ptl, strlen(buffer), buffer);

        /* TX Meter */
        ptl.x = 2;
        ptl.y += ulLineSpace;
        GpiMove (hps, &ptl);
        box.y = ptl.y + ulLineSpace - 10;
        box.x = profil.swpclient.cx - 2 * WinQuerySysValue (HWND_DESKTOP, SV_CYSIZEBORDER) - 2;
        GpiBox (hps, DRO_OUTLINE, &box, 0, 0);

        if (itxbs > 0) {
            if(itxbs > profil.itxmax) profil.itxmax = itxbs;
            box.x = (profil.swpclient.cx - 2 * WinQuerySysValue (HWND_DESKTOP, SV_CYSIZEBORDER) - 2) * itxbs / profil.itxmax;
            if(box.x > 2) GpiBox (hps, DRO_FILL, &box, 0, 0);
        } /* endif */

        ptl.x = 2;
        ptl.y += ulLineSpace;
        GpiCharStringAt (hps, &ptl, 10L, "Rx [kb/s]:");
        ptl.x = ulTab;
        itoa(irxbs, buffer, 10);
        GpiCharStringAt (hps, &ptl, strlen(buffer), buffer);

        /* RX Meter */
        ptl.x = 2;
        ptl.y += ulLineSpace;
        GpiMove (hps, &ptl);
        box.y = ptl.y + ulLineSpace - 10;
        box.x = profil.swpclient.cx - 2 * WinQuerySysValue (HWND_DESKTOP, SV_CYSIZEBORDER) - 2;
        GpiBox (hps, DRO_OUTLINE, &box, 0, 0);

        if (irxbs > 0) {
            if(irxbs > profil.irxmax) profil.irxmax = irxbs;
            box.x = (profil.swpclient.cx - 2 * WinQuerySysValue (HWND_DESKTOP, SV_CYSIZEBORDER) - 2) * irxbs / profil.irxmax;
            if(box.x > 2) GpiBox (hps, DRO_FILL, &box, 0, 0);
        } /* endif */

        ptl.x = 2;
        ptl.y += ulLineSpace;
        GpiCharStringAt (hps, &ptl, 7L, "Uptime:");
        ptl.x = ulTab;
        GpiCharStringAt (hps, &ptl, strlen(uptime), uptime);

        ptl.x = 2;
        ptl.y += ulLineSpace;
        GpiCharStringAt (hps, &ptl, 8L, "IP Addr:");
        ptl.x = ulTab;
        GpiCharStringAt (hps, &ptl, strlen(ip), ip);
//        GpiCharStringAt (hps, &ptl, strlen("255.255.255.255"), "255.255.255.255");

        ptl.x = 2;
        ptl.y += ulLineSpace;
        GpiCharStringAt (hps, &ptl, 7L, "Status:");
        ptl.x = ulTab;
        GpiCharStringAt (hps, &ptl, strlen(status), status);

        WinEndPaint (hps);
        break;              

    case WM_COMMAND:
        switch (SHORT1FROMMP (mp1)) {

        case IDM_DISCONNECT:
            nvtputs (hnvt, "1", 1);
            break;

        case IDM_SETTINGS:
            WinDlgBox (HWND_DESKTOP, hwnd, SettingsDlgProc, (HMODULE) 0, DLG_SETTINGS, NULL);
            break;

        case IDM_ABOUT:
            WinDlgBox (HWND_DESKTOP, hwnd, ProdinfoDlgProc, (HMODULE) 0, DLG_PRODINFO, NULL);
            break;

        case IDM_QUIT:
            WinPostMsg (hwnd, WM_CLOSE, 0, 0);
            break;

        } /* endswitch */
        break;

    case WM_BUTTON1DBLCLK:
        nvtputs (hnvt, "1", 1);
        break;

    case WM_CONTEXTMENU:
        hwndPopupMenu = WinLoadMenu (hwnd, 0, ID_POPUPMENU);
        WinQueryPointerPos (HWND_DESKTOP, &ptl);
        WinMapWindowPoints (HWND_DESKTOP, hwnd, &ptl,1);
        WinPopupMenu (hwndClientFrame, hwnd, hwndPopupMenu, ptl.x, ptl.y, 0,
            PU_MOUSEBUTTON1 |
            PU_KEYBOARD |
            PU_HCONSTRAIN |
            PU_VCONSTRAIN);
        break;

    case WM_CLOSE:
        WinPostMsg (hwnd, WM_QUIT, (MPARAM)0, (MPARAM)0);
        break;

    case WM_BUTTON1DOWN: 
        /*************************************/
        /* Determine the new window position */
        /*************************************/
        memset (&TrackInfo, 0, sizeof(TrackInfo));
        TrackInfo.cxBorder   = 1;
        TrackInfo.cyBorder   = 1;
        TrackInfo.cxGrid     = 1;
        TrackInfo.cyGrid     = 1;
        TrackInfo.cxKeyboard = 8;
        TrackInfo.cyKeyboard = 8;
 
        hwndFrame = WinQueryWindow (hwnd, QW_PARENT);
        WinQueryWindowPos (hwndFrame, &Position);
        TrackInfo.rclTrack.xLeft   = Position.x;
        TrackInfo.rclTrack.xRight  = Position.x + Position.cx;
        TrackInfo.rclTrack.yBottom = Position.y;
        TrackInfo.rclTrack.yTop    = Position.y + Position.cy;
 
        WinQueryWindowPos (HWND_DESKTOP, &Position);
        TrackInfo.rclBoundary.xLeft   = Position.x;
        TrackInfo.rclBoundary.xRight  = Position.x + Position.cx;
        TrackInfo.rclBoundary.yBottom = Position.y;
        TrackInfo.rclBoundary.yTop    = Position.y + Position.cy;
 
        TrackInfo.ptlMinTrackSize.x = 0;
        TrackInfo.ptlMinTrackSize.y = 0;
        TrackInfo.ptlMaxTrackSize.x = Position.cx;
        TrackInfo.ptlMaxTrackSize.y = Position.cy;
 
        TrackInfo.fs = TF_MOVE | TF_STANDARD | TF_ALLINBOUNDARY;
 
        if (WinTrackRect (HWND_DESKTOP, NULL, &TrackInfo)){
            WinSetWindowPos (hwndFrame, NULL,
                (SHORT) TrackInfo.rclTrack.xLeft,
                (SHORT) TrackInfo.rclTrack.yBottom,
                0, 0, SWP_MOVE);
        }
        WinQueryWindowPos (hwndClientFrame, &profil.swpclient);
        WinSetFocus(HWND_DESKTOP, hwnd);
        break;

     case WM_PRESPARAMCHANGED:
        WinQueryPresParam (hwnd, PP_FONTNAMESIZE, 0, 0, FONTLEN, profil.pszFont, 0);
        hps = WinGetPS(hwnd);
        GpiQueryFontMetrics (hps, sizeof(FONTMETRICS), &fm);
        WinReleasePS(hps);
        ulLineSpace = fm.lEmHeight * 1.2;
        ulTab = fm.lAveCharWidth * 13;
        profil.swpclient.cy = ulLineSpace * 7 + 2 * WinQuerySysValue (HWND_DESKTOP, SV_CYSIZEBORDER);
        profil.swpclient.cx = ulTab + fm.lEmInc * 9;
        WinSetWindowPos (hwndClientFrame, HWND_TOP, profil.swpclient.x, profil.swpclient.y,
            profil.swpclient.cx, profil.swpclient.cy, profil.swpclient.fl);
        WinInvalidateRect (hwndClient, NULL, TRUE);     /* Fenster neu zeichnen, WM_PAINT */
        break;

    default:
        return WinDefWindowProc (hwnd, msg, mp1, mp2);
        break;
    }
    return (MRESULT)FALSE;
}


/****************************************/ 
/* Prozedur fr die Settings-Dialog-Box */ 
/****************************************/ 
                                          
MRESULT EXPENTRY SettingsDlgProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)          
{                  
    switch (msg)   
    {
        case WM_INITDLG:
            WinSetPresParam (hwnd, PP_FONTNAMESIZE, FONTLEN, profil.pszFont);
            WinSetWindowText (WinWindowFromID (hwnd, EF_IP),   profil.pszIP);
            WinSetWindowText (WinWindowFromID (hwnd, EF_PASS), profil.pszPass);
            WinSendDlgItemMsg (hwnd, CHK_LOG, BM_SETCHECK, MPFROMSHORT (profil.iLog), MPVOID);
            break;


        case WM_COMMAND:                         
           if (SHORT1FROMMP (mp1) == DID_OK){
               WinQueryWindowText (WinWindowFromID (hwnd, EF_IP),   sizeof(profil.pszIP), profil.pszIP);
               WinQueryWindowText (WinWindowFromID (hwnd, EF_PASS), sizeof(profil.pszPass), profil.pszPass);
               profil.iLog = (USHORT) WinSendDlgItemMsg (hwnd, CHK_LOG, BM_QUERYCHECK, NULL, NULL);
               WinDismissDlg (hwnd, DID_OK);
           }

           if (SHORT1FROMMP (mp1) == DID_CANCEL){
               WinDismissDlg (hwnd, DID_OK);
           }
           break;      
                       
        case WM_CLOSE: 
           WinDismissDlg (hwnd, DID_OK);         
           break;
                 
        default: 
           return (WinDefDlgProc (hwnd, msg, mp1, mp2));
           break;          
    }                      
    return ((MRESULT) FALSE); 
}                          


/************************************/
/* Prozedur fr die Produktinfo-Box */
/************************************/

MRESULT EXPENTRY ProdinfoDlgProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)          
{                
    switch (msg) 
    {            
        case WM_INITDLG:
           WinSetPresParam (hwnd, PP_FONTNAMESIZE, FONTLEN, profil.pszFont);
           break;

        case WM_COMMAND:                     
           if (SHORT1FROMMP (mp1) == DID_OK) WinDismissDlg (hwnd, DID_OK); 
           break;                            
                                             
        case WM_CLOSE:                       
           WinDismissDlg (hwnd, DID_OK);     
           break;
                 
        default: 
           return (WinDefDlgProc (hwnd, msg, mp1, mp2));
           break; 
    }             
    return ((MRESULT) FALSE);                                                           
} 


/* Thread gets values via Telnet */
void TelnetThread(void *parm)
{
char buf[MAXLINESIZE];
int  row, col, count;
int  ilogintimeout = 250;
char word[MAXWORDSIZE];
char line_wan[MAXLINESIZE];
//char line_lan[MAXLINESIZE];
char line_ip[MAXLINESIZE];
char txbs[MAXWORDSIZE];
char rxbs[MAXWORDSIZE];

    parm = parm;
    memset(line_wan, ' ', MAXLINESIZE); line_wan[MAXLINESIZE-1] = 0;
    //memset(line_lan, ' ', MAXLINESIZE); line_lan[MAXLINESIZE-1] = 0;
    memset(line_ip,  ' ', MAXLINESIZE); line_ip[MAXLINESIZE-1]  = 0;

    /* Telnet login to Router */
    sprintf(status, "Connect Router...");
    WinInvalidateRect (hwndClient, NULL, TRUE);
    hnvt = nvtopen (profil.pszIP, NULL);
    if (!hnvt){
        _endthread;
    }
    /* Login with password and go to Menu 24.1 - System Maintenance - Status */
    sprintf(status, "Send Pass...");
    WinInvalidateRect (hwndClient, NULL, TRUE);
    nvtputs (hnvt, profil.pszPass, strlen(profil.pszPass));
    nvtputs (hnvt, "24", 2);
    nvtputs (hnvt, "1", 1);

    /* Wait for page 24.1 to appear */
    do {
        nvtgets(hnvt, buf, sizeof(buf)-1);
        if(!ilogintimeout--) break;
    } while (NULL == strstr(buf, "24.1"));
    if (ilogintimeout < 0) {
        _endthread;
    }

    for (;;) {
        count = nvtgets (hnvt, buf, sizeof(buf)-1);
        //if (!count) break;
        /* Read a line containing the ESC sequence */
        count = sscanf (buf, "\033[%d;%dH", &row, &col);

        if (count == 2) {   /* We got a new value */
            memcpy (word, strchr(buf,'H')+1, MAXWORDSIZE);  /* Copy the String after the 'H' */
            switch (row) {  /* See where this line fits */

            case 7: /* WAN Info */
               memcpy (&line_wan[col-1], word, strlen(word));
               sscanf (line_wan, "%*s%s%*s%*s%*s%s%s%s", status, txbs, rxbs, uptime);
               irxbs = 8 * atoi(rxbs);  /* 20 Mai 2002 - Umrechnung in kbit/sec */
               itxbs = 8 * atoi(txbs);
               break;

            //case 8: /* LAN Info */
            //   memcpy (&line_lan[col-1], word, strlen(word));
            //   break;

            case 11:/* IP-Addr Info */
               memcpy (&line_ip[col-1], word, strlen(word));
               sscanf (line_ip, "%*s%*s%s", ip);
               break;

            default:
              break;
            } /* endswitch */

        } /* endif */

    } /* endfor */
}

