/**
***  This is a part of the PCL2VBA project.   This set of functions handle
***  The PCL datastreams beginning with:  <Esc>*
**/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dcfvba.h"

/* -------------------------------------------------------------------------- */

void pcl_asterisk(void)
   {
   char pcl_command;

   next_char();
   pcl_command = (char)toupper(*current);
   switch(pcl_command)
      {
      case 'P':
         {
         do
            {
            next_char();
            pcl_asterisk_P();
            } /* do */
         while(strchr(PCL_END_SET,*current) == NULL);
         break;
         } /* case 'P' */
      default:
         {
         char error_message[255];

         sprintf(error_message,"Unsupported PCL command: <Esc>*%c",*current);
         error(error_message,8);
         } /* default */
      } /* switch */
   } /* pcl_asterisk */

/* -------------------------------------------------------------------------- */

void pcl_asterisk_P(void)
   {
   int    signed_arg = NOSIGN; /* Flag indicating whether the argument was signed */
   int    target_row;      /* Used to calculate what the new output row is */
   char   pcl_char;
   double number;

   /* Handle the sign if one exists */

   switch(*current)
      {
      case '+':
         {
         signed_arg = POSITIVE;
         next_char();
         break;
         }
      case '-':
         {
         signed_arg = NEGATIVE;
         next_char();
         break;
         }
      } /* switch */

   number = get_pcl_arg();

   pcl_char = (char)toupper(*current);
   switch (pcl_char)
      {
      case 'X': /* Horizontal positioning by dot */
         {
         switch(signed_arg)
            {
            case POSITIVE:
               {
               strpad(column_by_dot(number)+strlen(line));
               break;
               }
            case NOSIGN:
               {
               strpad(column_by_dot(number));
               break;
               }
            case NEGATIVE:
               {
               strpad(column_by_dot(number)-strlen(line));
               break;
               }
            }
         break;
         }
      case 'Y': /* Absolute vertical position by dot */
         {
         target_row = row_by_dot(number);
         switch(signed_arg)
            {
            case POSITIVE:
               {
               position_vertical(logical_vpos+target_row);
               break;
               }
            case NOSIGN:
               {
               if (target_row < logical_vpos)
                  {
                  error("Negative vertical positioning may not work as expected.",0);
                  logical_vpos = target_row;
                  }
               else
                  position_vertical(target_row);
               break;
               }
            case NEGATIVE:
               {
               error("Negative vertical positioning may not work as expected.",0);
               logical_vpos -= target_row;
               break;
               }
            } /* switch */
         break;
         } /* case 'Y' */
      } /* Switch */
   }  /* pcl_asterisk_P */
