/* 
 * this program is a quick and dirty hack
 * for converting matrices and vectors in several
 * data formats to ASCII. The output is written in two columns
 * format.
 *
 * It is written supplementary for GammaSun OS/2
 *
 * send bugs and wishes to R.Alt@rz.tu-bs.de
 * or Reinhard Alt
 *    Cyriaksring 3
 *    38118 Braunschweig
 *    Germany
 */



#include <stdio.h>
#include <stdlib.h>

#include "global.h"
#include "matrixio.h"
#include "vectorio.h"

int main( int argc, char *argv[] )
{
    long double **matrix, dummy;
    long double *vector;
    long    dim, l, max, z, s, 
            skip=0, flip=FALSE;
    int     mode, c;

    if ( argc < 5 )
    {
        fprintf( stderr, "convert by ReAlSoft Reinhard Alt (R.Alt@rz.tu-bs.de)\n"
                         "        converting program for data in some several formats\n"
                         "        to ASCII data (2 columns)\n\n"
                         "Syntax: convert dimension <conversion type> inputfile outputfile\n"
                         "        {[-flip], [-skip x]} \n"
                         "possible conversion types are:\n"
                         "  -hepro            trigonal matrices in ASCII for HEPRO\n"
                         "  -bintri8          binary trigonal matrix - 8 Bytes\n"
                         "  -binsquare4       binary square matrix - 4 Bytes\n"
                         "  -mathmatrix       Mathematica(Tm) matrix\n"
                         "  -binvector4       binary vector - 4 Bytes\n"
                         "  -binvector8       binary vector - 8 Bytes\n"
                         "  -mathvector       Mathematica(Tm) vector\n"
                         "  -longint          long integer vector (4 Bytes)\n"
                         "  -target           target data format to 2 column ASCII\n"
                         "  -EG+G             EG&G *.chn files\n"
                         " [-flip]            flip rows and columns\n"
                         " [-skip x]          skip x Bytes Header\n\n"
                         " example: convert 128 -mathvect input.math output.asc\n" );
        return 1;
    }
    else
       fprintf( stdout, "converting program to ASCII matrices and vectors by ReAlSoft\n"
                        "Reinhard Alt (R.Alt@rz.tu-bs.de)\n" );

    sscanf( argv[1], "%li", &dim );

    if ( strstr( argv[2], "-hepro" ) )
        mode = HEPRO;
    else
    if ( strstr( argv[2], "-bintri8" ) )
        mode = BINTRI8;
    else
    if ( strstr( argv[2], "-binsquare4" ) )
        mode = BINSQUARE4;
    else
    if ( strstr( argv[2], "-mathmatrix" ) )
        mode = MATHMATRIX;
    else
    if ( strstr( argv[2], "-binvector4" ) )
        mode = BINVECT4;
    else
    if ( strstr( argv[2], "-binvector8" ) )
        mode = BINVECT8;
    else
    if ( strstr( argv[2], "-mathvector" ) )
        mode = MATHVECT;
    else
    if ( strstr( argv[2], "-target" ) )
        mode = TARGET;
    else
    if ( strstr( argv[2], "-EG+G" ) )
    {
        mode = LONGVECT;
        skip = 32;
    }
    else
    if ( strstr( argv[2], "-longint" ) )
        mode = LONGVECT;
    else
    {
        fprintf( stderr, "this conversion type is not allowed!\n" );
        exit( 1 );
    }

    for ( l=5; l<argc; l++ )
        if ( strstr( argv[l], "-flip" ) )
            flip = TRUE;
        else
        if ( strstr( argv[l], "-skip" ) )
        {
            if ( l+1 < argc )
            {
                sscanf( argv[l+1], "%li", &skip );
                l++;
            }
            else
            {
                fprintf( stderr, "if you use skip enter an additional argument\n" );
                exit( 1 );
            }
        }
        else
        {
            fprintf( stderr, "what do you mean with %s?\n", argv[l] );
            exit( 1 );
        }

    switch ( mode ) {
    case HEPRO:
    case BINTRI8:
    case BINSQUARE4:
    case MATHMATRIX:
        matrix = readmatrix( argv[3], dim, mode, skip );
        writematrix( matrix, dim, argv[4], flip );
        break;

    case BINVECT8:
    case BINVECT4:
    case MATHVECT:
    case TARGET:
    case LONGVECT:
        vector = readvector( argv[3], dim, mode, skip );
        writevector( vector, dim, argv[4], flip );
        break;
    default:
        fprintf( stderr, "internal error!\nsend bug report to R.Alt@rz.tu-bs.de" );
    }

    return 0;
}

