/* Backs up all DB2/2 databases to C:\DBBACK */
CALL SYSSAVEOBJECT "<WP_DESKTOP>","SYNCH" /* Save the Desktop */
CALL DIRECTORY "C:\DESKBAK2"; "DESKBAK2.EXE" /* Do the DeskBak to save Desktop and INI files; if you don't use DeskBak remove this line */

/*
Ignore the databases in IGNORE (don't back them up).
Ensure that each database name has a tilde (~) before and after it.

*/
IGNORE="~DO_NOT_BACK_UP_1~DO_NOT_BACK_UP_2~TEMP~"

DIR="C:\DBBACK" /* Dir to back up to */
OLD="C:\DBBACKOLD" /* Dir to move old backups to */
SAY "Moving previous backups into "OLD
CALL MOVEDIR DIR,OLD,"R"
CALL RXFUNCADD "SQLDBS","SQLAR","SQLDBS"
CALL RXFUNCADD "SQLEXEC","SQLAR","SQLEXEC"
CALL SQLDBS "START DATABASE MANAGER"
CALL SQLDBS "OPEN DATABASE DIRECTORY USING :STEM"
DO WHILE SQLCA.SQLCODE=0
	CALL SQLDBS "GET DATABASE DIRECTORY ENTRY :STEM.1 USING :DBINFO"
	IF (SQLCA.SQLCODE=0)&(DBINFO.5="")&(POS("~"STRIP(DBINFO.2)"~",IGNORE)=0) THEN "DB2 BACKUP DATABASE "DBINFO.2" TO "DIR
END
CALL SQLDBS "CLOSE DATABASE DIRECTORY :STEM.1"
EXIT

MOVEDIR: PROCEDURE
PARSE ARG FROM,TO,FLAGS
/* FLAGS is a combination of letters (case sensitive). Valid options:
R	Don't RD the top-level dir
r	Don't RD any dir
D	Don't DEL the top-level dir
d	Don't DEL any dir
*/
PASSONFLAGS=""
IF POS("r",FLAGS)>0 THEN PASSONFLAGS=PASSONFLAGS"r"
IF POS("d",FLAGS)>0 THEN PASSONFLAGS=PASSONFLAGS"d"
IF \DIREXISTS(TO) THEN "@MD "TO" >NUL 2>NUL"
"@COPY "FROM TO" >NUL 2>NUL"
CALL SYSFILETREE FROM"\*","STEM","DO"
DO I=1 TO STEM.0
	CALL MOVEDIR STEM.I,TO||SUBSTR(STEM.I,LENGTH(FROM)+1),PASSONFLAGS
END
IF POS("D",TRANSLATE(FLAGS))=0 THEN "@DEL "FROM" /N >NUL 2>NUL"
IF POS("R",TRANSLATE(FLAGS))=0 THEN "@RD "FROM" >NUL 2>NUL"
RETURN

DIREXISTS: PROCEDURE
PARSE ARG DIR 
RET=0
SIGNAL ON NOTREADY NAME RETN
CALL STREAM DIR"\*","D"
CURDIR=DIRECTORY()
CURDIR2=DIRECTORY(FILESPEC("D",DIR))
RET=DIRECTORY(DIR)\=""
CALL DIRECTORY CURDIR2
CALL DIRECTORY CURDIR
RETN:
RETURN RET
