/* CREATETABLE.CMD (c) copyright Christopher Angelico 2000
Uses the SYSIBM catalog tables to generate a CREATE TABLE statement which would recreate the table.
Useful for modifying the table definition and rebuilding.
*/
"@MODE 255 32" /* Get a lot of width - remove this line if it doesn't work. */
GETDBNAME:
SAY "Enter database name, or * to select from list:"
PULL DB /* Get from keyboard; uppercase */
IF DB="" THEN EXIT /* Empty input = quit */
IF DB="*" THEN DO /* List all available databases */
	SAY "Databases available:"
	SAY "Name      Comment"
	SAY "========  ============================="
	CALL SQLDBS "OPEN DATABASE DIRECTORY USING :STEM"
	DO WHILE SQLCA.SQLCODE=0
		CALL SQLDBS "GET DATABASE DIRECTORY ENTRY :STEM.1 USING :DBINFO"
		IF SQLCA.SQLCODE=0 THEN SAY DBINFO.2"  "DBINFO.7
	END
	CALL SQLDBS "CLOSE DATABASE DIRECTORY :STEM.1"
	SAY
	SIGNAL GETDBNAME
END
CALL SQLEXEC "CONNECT TO "DB /* Connect to selected database */
IF SQLCA.SQLCODE\=0 THEN EXIT /* If failed, quit */
STEM.0=0; DOSTEM=0 /* For processing an entire stem */
ENTERTBNAME:
SAY "Enter table name (% and _ valid):"
PULLTABLE:
PULL TABLE /* Uppercase table name */
IF TABLE="" THEN EXIT /* Null input = exit */
IF TABLE="*" THEN DO; DOSTEM=1; WHICHTABLE=0; SIGNAL GO; END /* See secondary prompt below */
SCHEMA=""
IF POS(".",TABLE)=0 THEN CREATOR="=USER" /* If no . in table name, get table(s) created by current user */
ELSE DO
	PARSE VALUE TABLE WITH SCHEMA"."TABLE /* eg SY_IBM.%COLU% should find SYSIBM.SYSCOLUMNS */
	CREATOR=" LIKE '"SCHEMA"'"
END

/* Obtain list of all tables which fit specified table name and creator */
STMT="SELECT CREATOR,NAME FROM SYSIBM.SYSTABLES WHERE NAME LIKE '"TABLE"' AND CREATOR"CREATOR
CALL SQLEXEC "PREPARE S1 FROM :STMT"
CALL SQLEXEC "DECLARE C1 CURSOR FOR S1"
CALL SQLEXEC "OPEN C1"
CALL SQLEXEC "FETCH C1 INTO :C,:N"
I=0
DO WHILE SQLCA.SQLCODE=0
	I=I+1
	STEM.I=N
	STEM.I.1=STRIP(C)
	CALL SQLEXEC "FETCH C1 INTO :C,:N"
END
CALL SQLEXEC "CLOSE C1"
STEM.0=I
SELECT
	WHEN STEM.0=0 THEN DO; SAY "Not found."; SIGNAL ENTERTBNAME; END /* If none found, prompt again. */
	WHEN STEM.0=1 THEN TABLE=STEM.1 /* If only one found, continue */
OTHERWISE
	DO I=1 TO STEM.0 /* List all tables which fit */
		SAY STEM.I.1"."STEM.I
	END
	SAY "Enter table name, or * to process the entire list:"
	SIGNAL PULLTABLE
END
GO:
IF DOSTEM THEN DO /* If user entered * we have to check the entire stem */
	WHICHTABLE=WHICHTABLE+1
	IF WHICHTABLE>STEM.0 THEN SIGNAL FIN /* If finished stem, finish! */
	TABLE=STEM.WHICHTABLE
	SCHEMA=STEM.WHICHTABLE.1
END
ELSE SCHEMA=STEM.1.1
IF SCHEMA\="" THEN SC=SCHEMA"."
ELSE SC=""
CREATE="CREATE TABLE "SC||TABLE" (" /* Init variable */

/* Find the primary key */
STMT="SELECT COLNAMES,COLCOUNT FROM SYSIBM.SYSINDEXES WHERE TBNAME='"TABLE"' AND UNIQUERULE='P'"
CALL SQLEXEC "PREPARE S1 FROM :STMT"
CALL SQLEXEC "DECLARE C1 CURSOR FOR S1"
CALL SQLEXEC "OPEN C1"
CALL SQLEXEC "FETCH C1 INTO :COLS,:NCOLS"
PRIMARYKEYCOL=""
IF SQLCA.SQLCODE=0 THEN DO
	IF NCOLS=1 THEN PRIMARYKEYCOL=SUBSTR(COLS,2) /* If only one column, use shortcut */
	ELSE DO
		IF COLS\="" THEN DO
			CREATE=CREATE"PRIMARY KEY ("
			COLS=SUBSTR(COLS,2)
		END
		DO WHILE COLS\=""
			PARSE VALUE COLS WITH CUR"+"COLS
			CREATE=CREATE||CUR","
		END
		CREATE=DBRRIGHT(CREATE,1)"),"
	END
END
CALL SQLEXEC "CLOSE C1"

STMT="SELECT NAME,TYPENAME,NULLS,LENGTH,SCALE,DEFAULT FROM SYSIBM.SYSCOLUMNS WHERE TBNAME='"TABLE"'"
CALL SQLEXEC "PREPARE S1 FROM :STMT"
CALL SQLEXEC "DECLARE C1 CURSOR FOR S1"
CALL SQLEXEC "OPEN C1"
CALL SQLEXEC "FETCH C1 INTO :NAME,:COLTYPE,:NULLS,:LENGTH,:SCALE,:DEFAULT :DEFIND"
DO WHILE SQLCA.SQLCODE=0
	CREATE=CREATE||STRIP(NAME) SHORTNAME(STRIP(COLTYPE))
	SELECT
		WHEN (COLTYPE="CHARACTER")|(COLTYPE="VARCHAR") THEN IF LENGTH\=1 THEN CREATE=CREATE"("LENGTH")"
		WHEN COLTYPE="DECIMAL" THEN CREATE=CREATE"("LENGTH","SCALE")"
		OTHERWISE NOP
	END
	IF NULLS="N" THEN CREATE=CREATE" NOT NULL"
	IF DEFIND=0 THEN CREATE=CREATE" WITH DEFAULT "DEFAULT
	IF NAME=PRIMARYKEYCOL THEN CREATE=CREATE" PRIMARY KEY"
	CREATE=CREATE","
	CALL SQLEXEC "FETCH C1 INTO :NAME,:COLTYPE,:NULLS,:LENGTH,:SCALE,:DEFAULT :DEFIND"
END
CALL SQLEXEC "CLOSE C1"
CREATE=DBRRIGHT(CREATE,1)")"
SAY CREATE /* You might want to write the line out to a file, too. */
SAY
IF DOSTEM THEN SIGNAL GO /* If doing an entire stem, get the next one */
FIN:
SAY
SAY "Press Enter to quit."
PULL /* Wait for Enter press */
EXIT

SHORTNAME: PROCEDURE /* Convert a typename into a shorter version - shortcuts again */
PARSE ARG NAME
SELECT
	WHEN NAME="CHARACTER" THEN RETURN "CHAR" /* 'CHARACTER'->'CHAR' */
	OTHERWISE RETURN NAME /* Otherwise no change */
END
RETURN "***" /* Shouldn't happen */
