/*
	DataInput 4.0
	(c) 2001 by Don Eitner

	Front-end to create database for use with Randomizer.cmd.

	This code is neither supported nor under warranty.  Feel free to
	examine and modify this script for your own purposes.  See the
	included readme.txt for additional information.
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse arg DataFile

call SysCls
call AnsiSetup

if DataFile = '' then
do
	call CharOut, 'Enter the name of the data file you wish to use: '
	parse pull DataFile
	if DataFile = '' then
		DataFile = 'RandomData.txt'
end

delim = '09'x
delim2 = ','

Fields = linein(DataFile,,1)
Count = puns(Fields, delim)

do Num = 1 to Count
	Item.Num = linein(DataFile,,1)
end

call lineout(DataFile)

do forever
	call FieldMenu
	if Save = 1 then
		signal SaveIt
end

exit


SaveIt:

	RC = SysFileDelete(DataFile)
	call lineout DataFile, Fields
	do Num = 1 to Count
		call lineout DataFile, Item.Num
	end
	call lineout(DataFile)

return


FieldMenu:

	Count = puns(Fields, delim)
	call SysCls
	say center('Main Fields Menu', 80)
	do Num = 1 to Count
		Data.Num = pun(Fields, delim, Num)
		Display.Num = pun(Data.Num, delim2, 1)
		call ArrangeDisplay
	end
	call SysCurPos 18, 0
	say copies('-', 80)
	call SysCurPos 18, 28
	say LWhi||'Please Select From Below'||Non
	call SysCurPos 19, 8
	say '('||LBro||'A'||Non||')dd a Field  ('||LBro||'D'||Non||')elete a Field  ('||LBro||'E'||Non||')dit a Field  ('||LBro||'M'||Non||')ark a field'
	call SysCurPos 20, 8
	say '('||LBro||'H'||Non||')elp  ('||LBro||'S'||Non||')ave & Quit  ('||LBro||'Q'||Non||')uit w/o Save  Or enter a # from above'
	call SysCurPos 21, 0
	say copies('-', 80)
	call ClearInput
	parse upper pull Selection

	select
		when (datatype(Selection) = 'NUM') & (Selection <= Count) then
			signal ItemMenu

		when Selection = 'A' then
			do
				call ClearInput
				call CharOut, 'Enter new field name: '
				Count = Count + 1
				parse pull Data.Count
				Item.Count = 'edit me!'
				call RewriteFields
				signal FieldMenu
			end

		when Selection = 'D' then
			do
				call ClearInput
				call CharOut, 'Which field # do you wish to delete? '
				parse pull Selection2
				if (Selection2 <= Count) & (Selection2 > 0) then
					do
						call ClearInput
						call CharOut, 'Are you sure you want to delete this field and all its items? '
						parse pull Junk
						if translate(Junk) = 'Y' then
							do
								Data.Selection2 = ''
								Item.Selection2 = ''
								call RewriteFields
								do Num = 2 to Count
									PrevNum = Num - 1
									if Item.PrevNum = '' then
										do
											Item.PrevNum = Item.Num
											Item.Num = ''
										end
								end
								signal FieldMenu
							end
						else
							signal FieldMenu
					end
				else
					signal FieldMenu
			end

		when Selection = 'E' then
			do
				call ClearInput
				call CharOut, 'Which field # do you wish to edit? '
				parse pull Selection2
				if (Selection2 <= Count) & (Selection2 > 0) then
					do
						call ClearInput
						call CharOut, 'Current value of field' Selection2 'is' Display.Selection2||'.  Enter new value: '
						parse pull Data.Selection2
						if Data.Selection2 = '' then
							signal FieldMenu
						else
						do
							call RewriteFields
							signal FieldMenu
						end
					end
				else
					signal FieldMenu
			end

		when Selection = 'M' then
			do
				call ClearInput
				call CharOut, 'Which field # do you wish to mark/unmark for multiple selections? '
				parse pull Selection2
				if (Selection2 <= Count) & (Selection2 > 0) then
					do
						if pos('',Data.Selection2) = 1 then
							do
								Data.Selection2 = pun(Data.Selection2, delim2, 1)
								Data.Selection2 = substr(Data.Selection2,2)||',1,1'
							end
						else
							do
								Data.Selection2 = pun(Data.Selection2, delim2, 1)
								Data.Selection2 = ''||Data.Selection2||',0,'||puns(Item.Selection2, delim)
							end
						Fields = ''
						do Num = 1 to Count
							if Data.Num = '' then
								iterate
							if Fields = '' then
								Fields = Data.Num
							else
								Fields = Fields||'09'x||Data.Num
						end
						signal FieldMenu
					end
				else
					signal FieldMenu
			end

		when Selection = 'H' then
			do
				call GiveHelp
			end

		when Selection = 'S' then
			do
				Save = '1'
				return save
			end

		when Selection = 'Q' then
			exit

		otherwise
			signal FieldMenu

		Selection = ''

	end

return


ItemMenu:

	Count = puns(Item.Selection, delim)
	call SysCls
	say center(pun(pun(Fields, delim, Selection), delim2, 1) 'Sub-Menu', 80)
	do Num = 1 to Count
		Data.Num = pun(Item.Selection, delim, Num)
		Display.Num = pun(Data.Num, delim2, 1)
		call ArrangeDisplay
	end
	call SysCurPos 18, 0
	say copies('-', 80)
	call SysCurPos 18, 28
	say LWhi||'Please Select From Below'||Non
	call SysCurPos 19, 8
	say '('||LBro||'A'||Non||')dd an Item  ('||LBro||'D'||Non||')elete an item  ('||LBro||'E'||Non||')dit an Item  ('||LBro||'P'||Non||')revious Menu'
	call SysCurPos 20, 0
	say copies('-', 80)
	call ClearInput
	parse upper pull Selected

	select
		when Selected = 'A' then
			do
				call ClearInput
				call CharOut, 'Enter new item: '
				Count = Count + 1
				parse pull Data.Count
				call RewriteItems
				signal ItemMenu
			end

		when Selected = 'D' then
			do
				call ClearInput
				call CharOut, 'Which item # do you wish to delete? '
				parse pull Selected2
				if (Selected2 <= Count) & (Selected2 > 0) then
					do
						call ClearInput
						call CharOut, 'Are you sure you want to delete this item? '
						parse pull Junk
						if translate(Junk) = 'Y' then
							do
								Data.Selected2 = ''
								call RewriteItems
								signal ItemMenu
							end
						else
							signal ItemMenu
					end
				else
					signal ItemMenu
			end

		when Selected = 'E' then
			do
				call ClearInput
				call CharOut, 'Which item # do you wish to edit? '
				parse pull Selected2
				if (Selected2 <= Count) & (Selected2 > 0) then
					do
     					call ClearInput
						call CharOut, 'Current value of item' Selected2 'is' Display.Selected2||'.  Enter new value: '
						parse pull Data.Selected2
						if Data.Selected2 = '' then
							signal ItemMenu
						else
							do
								call RewriteItems
								signal ItemMenu
							end
					end
				else
					signal ItemMenu
			end

		when Selected = 'P' then
			signal FieldMenu

		otherwise
			signal ItemMenu
	end

	Selected = ''

return


ArrangeDisplay:

	Num2 = Num
	HighCount = trunc(Count / 45)
	do Count2 = 1 to HighCount
		if (Num > 45 * Count2) & (Num < (45 * (Count2 + 1) + 1)) then
			Num2 = Num - (45 * Count2)
	end

	select
		when (Num2 > 0) & (Num2 < 16) then
			do
				Row = Num2 + 1
				Col = 2
			end
		when (Num2 > 15) & (Num2 < 31) then
			do
				Row = Num2 - 14
				Col = 29
			end
		when (Num2 > 30) & (Num2 < 46) then
			do
				Row = Num2 - 29
				Col = 56
			end
		otherwise
			do
				say "Error!  Num2 out of range:" Num2
				exit
			end
	end

	call SysCurPos Row, Col
	call CharOut, LTur||Num||')'||Non Display.Num

	do Count2 = 0 to HighCount
		if (Num = 45 * Count2) & (Num <> Count) then
			do
				call SysCurPos 17, 0
				call CharOut, LPur||"Showing" Num - 44||"-"||Num "of" Count||". ENTER for more."||Non
				pull junk
                    call SysCls
			end
		if (Num = Count) & (Num <> 45 * Count2) then
			do
				call SysCurPos 17, 0
				call CharOut, LPur||"Showing" Max(Num - 44, 45 * Count2 + 1)||"-"||Num "of" Count||"."||Non
			end
		if (Num = Count) & (Num = 45 * Count2) then
			do
				call SysCurPos 17, 0
				call CharOut, LPur||"Showing" Num - 44||"-"||Num "of" Count||"."||Non
			end
	end

return


ClearInput:

	call SysCurPos 22, 0
	say copies(' ', 80)
	call SysCurPos 22, 0

return


RewriteFields:

	Fields = ''
	do Num = 1 to Count
		if Data.Num = '' then
			iterate
		if Fields = '' then
			Fields = Data.Num
		else
			Fields = Fields||'09'x||Data.Num
	end

return


RewriteItems:

	Item.Selection = ''
	do Num = 1 to Count
		if Data.Num = '' then
			iterate
		if Item.Selection = '' then
			Item.Selection = Data.Num
		else
			Item.Selection = Item.Selection||'09'x||Data.Num
	end

return


GiveHelp:

	call SysCls
	say 'Add a Field allows you to create arrays from which other programs can'
	say 'select one or more items.'
	say
	say 'Delete a Field will delete an entire array of items permanently.'
	say LBro||'Use with great caution!'||Non
	say
	say 'Edit a Field allows you to edit the name of a chosen array.'
	say
	say 'Mark a Field allows you to set a chosen array to be selected from multiple'
	say 'times by a calling program which supports this (ie. randomizer.cmd).'
	say
	say 'Save will save the currently open data file with the currently active'
	say 'array names and items within each array.'
	say
	say 'Quit will exit DataInput without saving changes you have made.'
	key = SysGetKey('NOECHO')

return


AnsiSetup:

	Esc=d2c(27)d2c(91)

/* Attributes */
	Hig=Esc'1m'
	Non=Esc'0m'

/* Foreground Colors */
	Bla=Esc'30m'
	Red=Esc'31m'
	Gre=Esc'32m'
	Bro=Esc'33m'
	Blu=Esc'34m'
	Pur=Esc'35m'
	Tur=Esc'36m'
	Whi=Esc'37m'
	LBla=Hig||Bla
	LRed=Hig||Red
	LGre=Hig||Gre
	LBro=Hig||Bro
	LBlu=Hig||Blu
	LPur=Hig||Pur
	LTur=Hig||Tur
	LWhi=Hig||Whi

/* Background Colors */
	BBla=Esc'40m'
	BRed=Esc'41m'
	BGre=Esc'42m'
	BBro=Esc'43m'
	BBlu=Esc'44m'
	BCya=Esc'45m'
	BTur=Esc'46m'
	BWhi=Esc'47m'

return


puns: procedure

	PARSE ARG string, delim
	CALL split string, delim

RETURN substring.0


pun: procedure

	PARSE ARG string, delim, word
	CALL split string, delim

RETURN substring.word


delpun: procedure

	PARSE ARG string, delim, word, length
	CALL split string, delim
	DO x = word to (word - 1 + length)
		substring.x = ''
	END
	DO y = 1 to substring.0
		IF substring.y = '' THEN
			iterate
		IF string = '' THEN
			string = substring.y
		ELSE
			string = string||delim||substring.y
	END

RETURN string


split:

	PARSE ARG string, delim
	num = 0
	DO WHILE string <> ''
		num = num + 1
		stop = pos(delim, string)
		IF stop = 0 THEN
			stop = length(string)+1
		substring.num = substr(string, 1, stop-1)
		string = substr(string, stop+1)
	END
	substring.0 = num

	IF delim = ',' | delim = ';' | delim = ':' THEN
		DO x = 1 to substring.0
			substring.x = strip(substring.x,b,'"')
		END

RETURN

