@echo off
echo.
rem Create and restore binary images from diskettes using DFSee  (c) JvW 1999
rem 05-11-2002 JvW Updated for executable naming DFSOS2, DFSWIN and DFSDOS
rem 10-03-2003 JvW Updated to use inverse window colors
rem 09-08-2016 JvW Use 'dfsrunas.exe' to elevate Windows to admin, ignoring explicit window sizes
rem

if "%OS%"==""        goto notnt
if "%OS%"=="DOS"     goto notnt
if "%OS%"=="MSDOS"   goto notnt
if "%OS%"=="DRDOS"   goto notnt
if "%OS%"=="IBMDOS"  goto notnt
if "%OS%"=="OPENDOS" goto notnt

ver | findstr /i /C:"XP [" > nul
if %errorlevel% EQU 0 goto winxpnt
ver | findstr /i /C:"Version 5" > nul
if %errorlevel% EQU 0 goto winxpnt
ver | findstr /i /C:"NT [" > nul
if %errorlevel% EQU 0 goto winxpnt
ver | findstr /i /C:"Version 4" > nul
if %errorlevel% EQU 0 goto winxpnt

set dfsexe=dfsrunas dfswin.exe
goto dfsee

:winxpnt
set dfsexe=dfswin.exe
goto dfsee

:notnt
set dfsexe=dfsdos.exe
:dfsee
set cmdext=BAT

if "%1"==""     goto noparam
if "%1"=="?"    goto noparam
if "%1"=="-?"   goto noparam

if "%2"=="-r"   goto restore
if "%2"=="r"    goto restore
if "%2"=="R"    goto restore
if "%2"=="z"    goto compress
if "%2"=="Z"    goto compress
if "%2"=="-z"   goto compress
if "%2"=="-zip" goto compress
if "%2"=="-Zip" goto compress
if "%2"=="-ZIP" goto compress
set compress=
goto create

:compress
set compress=-zip

:create
echo %0: Create a binary image of diskette in A: using %dfsexe%
%dfsexe% -w -C -Q vol a#sim %compress% %1
echo.
echo Finished creating imagefile %1 from diskette A:
goto end

:restore
echo %0: Restore a binary image to diskette in A: using %dfsexe%
echo.
echo Check if imagefile %1 exists and is valid ...
%dfsexe% -q im %1#q
if errorlevel 1 goto nofile

echo.
echo Opening A: to restore this image to ...
%dfsexe% -w -C -Q vol a#wrim %1
echo.
echo Finished restoring imagefile %1 to diskette A:
goto end

:nofile
Echo Imagefile %1 cannot be opened or is invalid
goto end

:noparam

echo %0: Create or restore a binary image for diskette in A: using %dfsexe%
echo.
echo Usage: %0  destination-image-filename  [-r] [-z]
echo.
echo                 r or -r = restore previously created image
echo                 z or -z = create a compressed binary image
echo.
echo.       Note that the file-specification cannot contain spaces!
goto end

:end
echo.

