/*
 * COPY.c
 *
 * Copy-Routine fr groe Dateien
 *
 * Autor: SG
 * Stand: 25.1.93
 *
 */

#define INCL_BASE
#define INCL_DOS
#define INCL_NOPM
#include <os2.h>
#include <direct.h>
#include <string.h>
#include <ctype.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>

int COMakeWritable(const char *Filename)
{
    return chmod((char *)Filename,S_IWRITE)==0;
}

int COPathCreate(const char *Path)
{
    char PathBuf[2048];
    char *Begin,
	 *End;

    if (strlen(Path)>2047)
	return 0;
    strcpy(PathBuf,Path);

    if (Path[1] == ':')
	if (_chdrive(toupper(*PathBuf)-'A'+1)!=0)
	    return 0;
	else
	    Begin = PathBuf+2;
    else
	Begin = PathBuf;
    chdir("\\");

    while (Begin)
    {
	if (*Begin == '\\')
	    Begin++;
	if ((End = strchr(Begin,'\\'))!=NULL)
	{
	    *End = 0;
	    End++;
	}
	else /* Jetzt steht Begin auf dem Dateinamen. Der darf nicht als Verzeichnis angelegt werden */
	    return 1;

	if (chdir(Begin)!=0)
	{
	    if (mkdir(Begin)!=0)
		return 0;
	    if (chdir(Begin)!=0)
		return 0;
	}
	Begin = End;
    }
}

int COCopy(const char *Source, const char *Dest)
{
    int ret;

    if (COPathCreate(Dest)==0)
	return 0;

    COMakeWritable(Dest);
    ret = DosCopy((char *)Source,(char *)Dest,DCPY_EXISTING,0);
    return ret;
}
