/*
 * dialog.c - Dialogs for Xfont Program
 */

#include <stdio.h>
#include <stdlib.h>

#define INCL_PM
#include <os2.h>

#include "xfont.h"
#include "xfontres.h"

static  POINTL  ptDialog ;

static  UCHAR   loadPatt[CCHMAXPATH] = "*.pcf;*.bdf" ;

static  UCHAR   loadBuff[CCHMAXPATH] ;
static  UCHAR   loadDriv[CCHMAXPATH] ;
static  UCHAR   loadPath[CCHMAXPATH] ;
static  UCHAR   loadBase[CCHMAXPATH] ;
static  UCHAR   loadExtn[CCHMAXPATH] ;

/*
 * dialogLoadFile - Select Loading Font File
 */

MRESULT EXPENTRY LoadDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    SWP     pos ;
    
    if (msg == WM_INITDLG) {
        WinQueryWindowPos(hwnd, &pos) ;
	pos.x = ptDialog.x - (pos.cx / 4)     ;
	pos.y = ptDialog.y - (pos.cy * 4 / 5) ;
	WinSetWindowPos(hwnd, NULLHANDLE,
	    pos.x, pos.y, pos.cx, pos.cy, SWP_MOVE) ;
    }
    return WinDefFileDlgProc(hwnd, msg, mp1, mp2) ;
}

void    dialogLoadFile(HWND hwnd)
{
    HWND    hwndDlg ;
    FILEDLG fileDlg ;
    LISTPTR file    ;
        
    /*
     * Place Dialog at Current Mouse Position
     */

    WinQueryPointerPos(HWND_DESKTOP, &ptDialog) ;

    /*
     * Prepare File Dialog Data
     */
     
    memset(&fileDlg, 0, sizeof(fileDlg)) ;
    
    fileDlg.cbSize = sizeof(fileDlg) ;
    fileDlg.pszTitle = "X-Font File" ;
    fileDlg.fl = FDS_OPEN_DIALOG | FDS_PRELOAD_VOLINFO ;
    fileDlg.pfnDlgProc = LoadDlgProc ;

    strcpy(fileDlg.szFullFile, loadPatt) ;

    if (strlen(loadDriv) > 0) {
        fileDlg.pszIDrive = loadDriv ;
    }
    if (strlen(loadPath) > 0) {
        sprintf(fileDlg.szFullFile, "%s%s", loadPath, loadPatt) ;
    }
    
    /*
     * Font File Load Dialog
     */
     
    if ((hwndDlg = WinFileDlg(HWND_DESKTOP, hwnd, &fileDlg)) == NULLHANDLE) {
        return ;
    }
    if (fileDlg.lReturn != DID_OK) {
        return ;
    }

    _splitpath(fileDlg.szFullFile, loadDriv, loadPath, loadBase, loadExtn) ;
    
    if ((file = putFontFile(XfdFontList, fileDlg.szFullFile)) == NULL) {
        WinMessageBox(HWND_DESKTOP, hwnd,
	    fileDlg.szFullFile, "xfont : no such file", 
	    0, MB_OK | MB_ICONEXCLAMATION) ;
	return ;
    }
    WinPostMsg(hwnd, WM_LOAD_FONT, MPFROMP(file), NULL) ;
}

/*
 * dialogSlelectFont - Select Font
 */

static  LISTPTR newFont ;

static  void    listupFont(HWND hwndList)
{
    LISTPTR ptr ;
    SHORT   idx ;

    ptr = getFontList(XfdFontList) ;
    for (idx = 0 ; ptr != NULL ; idx++, ptr = getFontNext(ptr)) {
        WinSendMsg(hwndList, LM_INSERTITEM, 
	    MPFROM2SHORT(LIT_END, 0), MPFROMP(ptr->full)) ;
        if (ptr == curFile) {
            WinSendMsg(hwndList, LM_SELECTITEM, 
	        MPFROMSHORT(idx), MPFROMSHORT(TRUE)) ;
        }
    }
}

static  void    selectFont(HWND hwndList)
{
    LISTPTR ptr ;
    SHORT   sel, idx ;

    sel = WinQueryLboxSelectedItem(hwndList) ;
    
    ptr = getFontList(XfdFontList) ;
    for (idx = 0 ; ptr != NULL ; idx++, ptr = getFontNext(ptr)) {
        if (sel == idx) {
	    newFont = ptr ;
	    return ;
	}
    }
}

MRESULT EXPENTRY FontDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    SWP     pos ;
    
    HWND    hwndList = WinWindowFromID(hwnd, IDD_FONTLIST) ;

    switch (msg) {

    case WM_INITDLG :    
        /*
	 * Adjust to Mouse Location
	 */
        WinQueryWindowPos(hwnd, &pos) ;
	pos.x = ptDialog.x - (pos.cx / 4)     ;
	pos.y = ptDialog.y - (pos.cy * 4 / 5) ;
	WinSetWindowPos(hwnd, NULLHANDLE,
	    pos.x, pos.y, pos.cx, pos.cy, SWP_MOVE) ;

        listupFont(hwndList) ;

        break ;

    case WM_COMMAND :
        switch(SHORT1FROMMP(mp1)) {
	case DID_OK :
	    selectFont(hwndList) ;
	    WinDismissDlg(hwnd, TRUE)  ;
	    break ;
	case DID_CANCEL :
            WinDismissDlg(hwnd, FALSE) ;
	    break ;
	}
	return (MRESULT) 0 ;
    
    case WM_CONTROL :
        if (SHORT1FROMMP(mp1) != IDD_FONTLIST) {
	    return (MRESULT) 0 ;
	}
	if (SHORT2FROMMP(mp1) == LN_ENTER) {
	    selectFont(hwndList) ;
	    WinDismissDlg(hwnd, TRUE) ;
	}
	return (MRESULT) 0 ;
    }
    return WinDefDlgProc(hwnd, msg, mp1, mp2) ;
}

void    dialogSelectFont(HWND hwnd)
{
    ULONG   result ;

    /*
     * Place Dialog at Current Mouse Position
     */

    WinQueryPointerPos(HWND_DESKTOP, &ptDialog) ;

    /*
     * Show 'selection' Dialog
     */

    newFont = NULL ;
    
    result = WinDlgBox(HWND_DESKTOP, hwnd,
                FontDlgProc, NULLHANDLE, IDD_FONT, NULL) ;

    if (newFont != NULL) {
        WinPostMsg(hwnd, WM_LOAD_FONT, MPFROMP(newFont), NULL) ;
    }
}
