/* rxEnMime by Aleksey Peshkov, */
/*             Alex Porollo     */

say 'rxEnMime (C) CAN'

if RxFuncQuery('DCLoadFuncs') then
  do
    call RxFuncAdd 'DCLoadFuncs','rxDCplus','DCLoadFuncs'
    call DCLoadFuncs
  end

parse arg MimeType' 'ArgStr
MimeType=Translate(Space(MimeType))
MType1='UUE'; MType2='B64'
if Words(ArgStr)>2 then
  do
    Quote=0
    do i=1 to Length(ArgStr)
      if Substr(ArgStr,i,1)='"' then Quote=\Quote
      else
        if Substr(ArgStr,i,1)=' ' & Quote then
          ArgStr=Left(ArgStr,i-1)''d2c(1)''Right(ArgStr,Length(ArgStr)-i)
    end
    ArgStr=Space(ArgStr)
  end
parse var ArgStr IN' 'OUT
IN=Strip(Translate(IN,'  ','"'d2c(1))); OUT=Strip(Translate(OUT,'  ','"'d2c(1)))

select
  when (Arg()=0) | (MimeType\=MType1 & MimeType\=MType2) | IN='' then
    do
      say 'rxEnMime <'MType1'|'MType2'> <input file> [<output file>]'
      exit
    end
  when Stream(IN,'C','query exist')='' then
    do
      if Pos(' ',IN)>0 then IN='"'IN'"'
      say 'Could not open source file ('IN').'
      exit
    end
  otherwise
end

if OUT='' then
  do
    parse value Filespec('Name',IN) with NAME'.'EXT
    OUT=Filespec('Drive',IN)''Filespec('Path',IN)''NAME
    select
      when MimeType=MType1 then OUT=OUT'.'MType1
      when MimeType=MType2 then OUT=OUT'.'MType2
      otherwise
    end
  end

if Stream(OUT,'C','query exist')\='' then
  do
    if Pos(' ',OUT)>0 then OUT='"'OUT'"'
    say 'File 'OUT' already exist!'
    exit
  end

call Stream IN,'C','OPEN READ'
OUT_LINE=Charin(IN,1,Stream(IN,'C','SEEK <0'))
select
  when MimeType=MType1 then OUT_LINE=RXUUencode(OUT_LINE)
  when MimeType=MType2 then OUT_LINE=RXB64encode(OUT_LINE)
  otherwise
end
call Stream IN,'C','CLOSE'
if MimeType=MType1 then
  do
    FName=Filespec('Name',IN)
    if Pos(' ',FName)>0 then FName='"'FName'"'
    call Lineout OUT,'begin 644 'FName
  end
call CharOut OUT,OUT_LINE
if MimeType=MType1 then call Lineout OUT,'end'
call Stream OUT,'C','CLOSE'

if Pos(' ',IN)>0 then IN='"'IN'"'
if Pos(' ',OUT)>0 then OUT='"'OUT'"'
say 'Done encoding 'IN' to 'OUT
