/**************************************************************/
/* REXX installation/uninstallation script for DC User Pack   */
/* Copyright (C) 1999 by Alex Porollo                         */
/* modified  (C) 2000 by VicTor Smirnoff                      */
/**************************************************************/

/**************************************************************/
/* Library registration                                       */
/**************************************************************/

if RxFuncQuery('SysLoadFuncs') then
  do
    call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
    call SysLoadFuncs 
  end


/**************************************************************/
/* Constants                                                  */
/**************************************************************/

Ver='v0.02 (beta VI)'
DefaultDir='\DCpack'
PluginDir='plugin'
LibPath='\OS2\APPS\DLL'

SourceDist='COMMON'
SourceExe.0='OS2'
SourceExe.1='EMX'

RootFilesCount=7
RootFile.1='DCsetup.cmd'
RootFile.2='FILE_ID.DIZ'
RootFile.3='FILE_ID.RUS'
RootFile.4='DCUP.ABS'
RootFile.5='DCUP.RUS'
RootFile.6='LICENSE.ENG'
RootFile.7='LICENSE.RUS'

DllFilesCount=2
DllFile.1='DCplus.dll'
DllFile.2='rxDCplus.dll'

ComDllFilesCount=1
ComDllFile.1='DCdll.dll'

ExeFilesCount=2
ExeFile.1='DCclico.exe'
ExeFile.2='decode.exe'

ComExeFilesCount=2
ComExeFile.1='DC.exe'
ComExeFile.2='DCfilter.exe'

DistFilesCount=12
DistFile.1='DCclicoE.hlp'
DistFile.2='DCclicoR.hlp'
DistFile.3='DCclico.ico'
DistFile.4='DCpack.ico'
DistFile.5='DCsetup.ico'
DistFile.6='DCpackE.INF'
DistFile.7='DCpackR.INF'
DistFile.8='DCpack.bmp'
DistFile.9='DC.ini'
DistFile.10='rxDeMime.cmd'
DistFile.11='rxEnMime.cmd'
DistFile.12='tstDCplu.cmd'

PlugFilesCount=6
PlugFile.1='DCauto.dll'
PlugFile.2='DCmanual.dll'
PlugFile.3='DCmime.dll'
PlugFile.4='DCsystem.dll'
PlugFile.5='DCvolpk.dll'
PlugFile.6='decode.dll'

AddPlugFilesCount=1
AddplugFile.1='user.cod'

IniFile='DCCLICO.INI'

Esc=D2C(27)'[1;'
Grey_color=Esc'30m'
Red_color=Esc'31m'
Green_color=Esc'32m'
Yellow_color=Esc'33m'
Blue_color=Esc'34m'
Magenta_color=Esc'35m'
Cyan_color=Esc'36m'
White_color=Esc'37m'
ErrorMsg.0='Error: '
ErrorMsg.1='訡: '

VisualDelay=1

EmxFilesCount=6
EmxFile.1='emx'
EmxFile.2='emxio'
EmxFile.3='emxlibc'
EmxFile.4='emxlibcm'
EmxFile.5='emxlibcs'
EmxFile.6='emxwrap'
EmxVersion.1=60
EmxVersion.2=60
EmxVersion.3=60
EmxVersion.4=62
EmxVersion.5=62
EmxVersion.6=60

/**************************************************************/
/* Some additional variables                                  */
/**************************************************************/

'@echo off'
if Right(DefaultDir,1)='\' then DefaultDir=Left(DefaultDir,Length(DefaultDir)-1)
if Left(DefaultDir,1)\='\' then DefaultDir='\'DefaultDir
if Right(PluginDir,1)='\' then PluginDir=Left(PluginDir,Length(PluginDir)-1)
if Left(PluginDir,1)='\' then PluginDir=Right(PluginDir,Length(PluginDir)-1)
if Right(LibPath,1)='\' then LibPath=Left(LibPath,Length(LibPath)-1)
if Left(LibPath,1)\='\' then LibPath='\'LibPath
BootDrv=FileSpec('drive',Value('SYSTEM_INI',,'OS2ENVIRONMENT'))
DefaultDir=BootDrv''DefaultDir
LibPath=BootDrv''LibPath

newq=RxQueue('Create')
od=RxQueue('Set',newq)
do while Queued()>0
  pull .
end
'chcp |rxqueue 'newq
pull Codepage
do while Queued()>0
  pull .
end
Codepage=Space(Codepage)
parse var Codepage tmp': 'Codepage


/**************************************************************/
/* StartUp                                                    */
/**************************************************************/

call SysCls
say
say Center(Grey_color'-='Yellow_color' DC User Pack for OS/2 'White_color''Ver''Yellow_color' setup 'Grey_color'=-',79+7*5)
say

if Codepage=866 then
  do
    MsgRLang=0
    say White_color'롥   ਠ⮢:'
    if Translate(Arg(1))\='-UNINSTALL' then
      do
        say Cyan_color'  (Y)'Green_color' த ⠫ ᪮ ᨨ '
        say Cyan_color'  (n)'Green_color' install the international (english) version'
      end
    else
      do
        say Cyan_color'  (Y)'Green_color' த  ᪮ ᨨ ⠫'
        say Cyan_color'  (n)'Green_color' use international (english) version of the uninstaller'
      end
    call CharOut ,White_color' 'Cyan_color'(Y/n)'White_color
    if AskYN(1) then MsgRLang=1
  end
else
  do
    MsgRLang=1
    say White_color'Select the language:'
    if Translate(Arg(1))\='-UNINSTALL' then
      do
        say Cyan_color'  (Y)'Green_color' continue to install the international (english) version'
        say Cyan_color'  (n)'Green_color' ⠭   '
      end
    else
      do
        say Cyan_color'  (Y)'Green_color' continue in the international (english) version of the uninstaller'
        say Cyan_color'  (n)'Green_color' ᯮ짮   ⠫'
      end
    call CharOut ,White_color'Press 'Cyan_color'(Y/n)'White_color
    if AskYN(1) then MsgRLang=0
  end
do i=1 to 4
  call ClearPrevLine
end

/**************************************************************/
/* Detect EMX/standalone mode                                 */
/**************************************************************/

EmxExist=0
if Translate(Arg(1))\='-UNINSTALL' then
  do
    EmxExist=1
    do i=1 to EmxFilesCount
      if EmxRevision(EmxFile.i)<EmxVersion.i then
        do
          EmxExist=0;  leave i
        end
    end
    if EmxExist then
      do
        EmxExist=0
        if MsgRLang then msg=' 襩 ⥬ 㦥 室  EMX.'
        else msg='Your system uses the suitable version of the EMX.'
        say Green_color''msg
        if MsgRLang then msg='롥   ਠ⮢:'
        else msg='Select the version:'
        say White_color''msg
        if MsgRLang then msg='⠭ EMX-'
        else msg='install the EMX version'
        say Cyan_color'  (Y)'Green_color''msg
        if MsgRLang then msg='⠭  '
        else msg='install the standalone version'
        say Cyan_color'  (n)'Green_color''msg
    
        if MsgRLang then msg=''
        else msg='Press'
        call CharOut ,''White_color''msg' 'Cyan_color'(Y/n)'White_color
        if AskYN(1) then EmxExist=1
        do i=1 to 5
          call ClearPrevLine
        end
      end
  end

call SysCurState 'OFF'
if MsgRLang then msg=', ன  ⨢ ਫ, ᯮ騥 DC User Pack!'
else msg='Please stop any running applications using the DC User Pack!'
say Red_color''msg''White_color
if MsgRLang then msg='⥬   '
else msg='Then press any key'
call CharOut ,Grey_color''msg'...'White_color
call SysGetKey('NOECHO')
say;
do i=1 to 2
  call ClearPrevLine
end
call SysCurState 'ON'


/**************************************************************/
/* Detect installation/uninstallation mode                    */
/**************************************************************/

AllDllCount=DllFilesCount*2+ComDllFilesCount
DllCount=0
do i=1 to DllFilesCount
  if Stream(SourceExe.0'\'DllFile.i,'c','query exists')\='' then DllCount=DllCount+1
  if Stream(SourceExe.1'\'DllFile.i,'c','query exists')\='' then DllCount=DllCount+1
end
do i=1 to ComDllFilesCount
  if Stream(SourceDist'\'ComDllFile.i,'c','query exists')\='' then DllCount=DllCount+1
end
if DllCount=AllDllCount & Stream(IniFile,'c','query exists')='' & Arg(1)='' then

/**************************************************************/
/* Select installation mode                                   */
/**************************************************************/

  do
    if MsgRLang then msg='⠫'
    else msg='Installation'
    say White_color''msg':'

    if MsgRLang then msg='稭 ⠫'
    else msg='Continue with installation'
    call CharOut ,Green_color'  'msg' 'Cyan_color'(Y/n)'Green_color'? 'White_color
    if AskYN(1) then
      do
        /******************************************************/
        /* Select installation directory                      */
        /******************************************************/
        if MsgRLang then msg='  ⠭'
        else msg='Input target path'
        call CharOut ,Green_color'  'msg' 'Cyan_color'('DefaultDir')'Green_color': 'White_color
        InstallDir=LineIn()
        if Space(InstallDir)='' then InstallDir=DefaultDir
        InstallDir=Translate(InstallDir,'\','/')
        if Right(InstallDir,1)='\' then InstallDir=Left(InstallDir,Length(InstallDir)-1)
        if Substr(InstallDir,2,1)\=':' then
          do
            if Left(InstallDir,1)\='\' then InstallDir='\'InstallDir
            InstallDir=BootDrv''InstallDir
          end
        fPluginDir=InstallDir'\'PluginDir
        call ClearPrevLine
        if MsgRLang then msg='࠭ ४'
        else msg='Target path'
        say Green_color'  'msg': 'White_color''InstallDir
        call SysFileTree InstallDir,dir,'D'
        if dir.0=0 then
          do
            if MsgRLang then msg='࠭ ४  !  '
            else msg='Target path not found! Create it'
            call CharOut ,Red_color'  'msg' 'Cyan_color'(Y/n)'Red_color'? 'White_color
            if AskYN(1) then
              do
                call ClearPrevLine
                parse var InstallDir s'\'d.0'\'d.1'\'d.2'\'d.3'\'d.4'\'d.5'\'d.6'\'d.7'\'d.8'\'d.9'\'d.10
                i=0
                do while d.i\=''
                  s=s'\'d.i
                  call SysFileTree s,dir,'D'
                  if dir.0=0 then
                    if SysMkDir(s)\=0 then
                      do
                        if MsgRLang then msg=' ᮧ ࠭ ४'
                        else msg='Can`t create target directory'
                        say Red_color'  'ErrorMsg.MsgRLang''Yellow_color''msg'!'
                        call AbortProg(1)
                      end
                  i=i+1
                end
              end
            else call AbortProg(1)
          end
        else
          do
            if MsgRLang then msg='४ !   䠩  ⮩ ४ਨ'
            else msg='Target path found! Remove all files from this directory'
            call CharOut ,Green_color'  'msg' 'Cyan_color'(Y/n)'Green_color'? 'White_color
            if AskYN(1) then
              do
                if MsgRLang then msg='塞  䠩  ࠭ ४ਨ'
                else msg='Removing all files from target directory'
                call CharOut ,Grey_color'    'msg'... '
                call SysFileTree InstallDir'\*','file','FOS'
                do i=1 to file.0
                  if SysFileDelete(file.i)\=0 then
                    do
                      if MsgRLang then msg=' 㤠 䠩  ࠭ ४ਨ'
                      else msg='Removing files from target directory failed'
                      say; say Red_color'    'ErrorMsg.MsgRLang''Yellow_color''msg'!'
                      call AbortProg(1)
                    end
                end
                say White_color'Ok.'
              end
          end
        call SysFileTree fPluginDir,dir,'D'
        if dir.0=0 then
          if SysMkDir(fPluginDir)\=0 then
            do
              if MsgRLang then msg=' ᮧ ४  㣨'
              else msg='Can`t create plugin directory'
              say Red_color'  'ErrorMsg.MsgRLang''Yellow_color''msg'!'
              call AbortProg(1)
            end

        /******************************************************/        
        /* Search for old relative DLLs                       */
        /******************************************************/
        if MsgRLang then msg='  㤠 DLL-  । ᨩ'
        else msg='Search for any old relative DLLs for removing'
        call CharOut ,Green_color'  'msg' 'Cyan_color'(Y/n)'Green_color'? 'White_color
        if AskYN(1) then
          do
            call SysCurState 'OFF'
            if MsgRLang then msg='஡㥬   ।'
            else msg='Trying to remove old relative DLLs'
            call CharOut ,Grey_color'    'msg'... '
            parse value SysCurPos() with Oldrow Oldcol
            say; call RemoveDLL
            call SysCurPos Oldrow,Oldcol
            say White_color'Ok.'
          end

        /******************************************************/
        /* Installing components                              */
        /******************************************************/
        call SysCurState 'OFF'
        if MsgRLang then msg='⠫㥬  DC User Pack'
        else msg='Installing DC User Pack components'
        call CharOut ,Grey_color'    'msg'... '
        parse value SysCurPos() with Oldrow Oldcol
        say
        if MsgRLang then
          do
            msg1='㥬'; msg2=''
          end
        else
          do
            msg1='Copying'; msg2='to'
          end
        do i=1 to DllFilesCount
          say Left(Grey_color'      'msg1' 'Yellow_color''DllFile.i''Grey_color' 'msg2' 'Yellow_color''LibPath''Grey_color'...',79+7*4)
          'copy 'SourceExe.EmxExist'\'DllFile.i' 'LibPath' >nul'
          call SysSleep VisualDelay
          call ClearPrevLine
        end
        do i=1 to ComDllFilesCount
          say Left(Grey_color'      'msg1' 'Yellow_color''ComDllFile.i''Grey_color' 'msg2' 'Yellow_color''LibPath''Grey_color'...',79+7*4)
          'copy 'SourceDist'\'ComDllFile.i' 'LibPath' >nul'
          call SysSleep VisualDelay
          call ClearPrevLine
        end
        do i=1 to ExeFilesCount
          say Left(Grey_color'      'msg1' 'Yellow_color''ExeFile.i''Grey_color' 'msg2' 'Yellow_color''InstallDir''Grey_color'...',79+7*4)
          'copy 'SourceExe.EmxExist'\'ExeFile.i' 'InstallDir' >nul'
          call SysSleep VisualDelay
          call ClearPrevLine
        end
        do i=1 to ComExeFilesCount
          say Left(Grey_color'      'msg1' 'Yellow_color''ComExeFile.i''Grey_color' 'msg2' 'Yellow_color''InstallDir''Grey_color'...',79+7*4)
          'copy 'SourceDist'\'ComExeFile.i' 'InstallDir' >nul'
          call SysSleep VisualDelay
          call ClearPrevLine
        end
        do i=1 to RootFilesCount
          say Left(Grey_color'      'msg1' 'Yellow_color''RootFile.i''Grey_color' 'msg2' 'Yellow_color''InstallDir''Grey_color'...',79+7*4)
          'copy 'RootFile.i' 'InstallDir' >nul'
          call SysSleep VisualDelay
          call ClearPrevLine
        end
        do i=1 to DistFilesCount
          if MsgRLang & (i=1 | i=6) then iterate
          if \MsgRLang & (i=2 | i=7) then iterate
          say Left(Grey_color'      'msg1' 'Yellow_color''DistFile.i''Grey_color' 'msg2' 'Yellow_color''InstallDir''Grey_color'...',79+7*4)
          'copy 'SourceDist'\'DistFile.i' 'InstallDir' >nul'
          call SysSleep VisualDelay
          call ClearPrevLine
        end
        do i=1 to AddPlugFilesCount
          say Left(Grey_color'      'msg1' 'Yellow_color''AddPlugFile.i''Grey_color' 'msg2' 'Yellow_color''fPluginDir''Grey_color'...',79+7*4)
          'copy 'PluginDir'\'AddPlugFile.i' 'fPluginDir' >nul'
          call SysSleep VisualDelay
          call ClearPrevLine
        end
        do i=1 to PlugFilesCount
          say Left(Grey_color'      'msg1' 'Yellow_color''PlugFile.i''Grey_color' 'msg2' 'Yellow_color''fPluginDir''Grey_color'...',79+7*4)
          'copy 'PluginDir'\'SourceExe.EmxExist'\'PlugFile.i' 'fPluginDir' >nul'
          call SysSleep VisualDelay
          call ClearPrevLine
        end
        call SysCurPos Oldrow,Oldcol
        say White_color'Ok.'

        /******************************************************/
        /* Create DC User Pack folder                         */
        /******************************************************/
        param='ICONFILE='InstallDir'\'DistFile.4';OBJECTID=<DCUP_FLD>;ALWAYSSORT=Yes;ICONVIEWPOS=25,25,45,30;BACKGROUND='InstallDir'\'DistFile.8',T'
        if SysCreateObject('WPFolder','DC User Pack','<WP_DESKTOP>',param,'REPLACE') then
          do
            if MsgRLang then msg=' DC User Pack ᯥ譮 ᮧ  ࠡ祬 ⮫'
            else msg='DC User Pack folder successfully created on the desktop'
            say Grey_color'    'msg'!'
            call SysSleep VisualDelay
          end
        else
          do
            if MsgRLang then msg=' ᮧ  DC User Pack'
            else msg='DC User Pack folder creating failed'
            say Red_color'    'ErrorMsg.MsgRLang''Yellow_color''msg'!'
            call AbortProg(1)
          end

        /******************************************************/
        /* Create DCclico object                              */
        /******************************************************/
        ExeParam=''
        if MsgRLang then
          do
            cpProgName='஢騪  '
            if Codepage\=866 then ExeParam='-l:rus'
          end
        else
          do
            cpProgName='Clipboard Coder'
            if Codepage=866 then ExeParam='-l:eng'
          end
        if ExeParam\='' then ExeParam='PARAMETERS='ExeParam';'
        param='ICONFILE='InstallDir'\'DistFile.3';OBJECTID=<DCUPCLICO_EXE>;EXENAME='InstallDir'\'ExeFile.1';'ExeParam'STARTUPDIR='InstallDir
        if SysCreateObject('WPProgram',cpProgName,'<DCUP_FLD>',param,'REPLACE') then
          do
            if MsgRLang then msg='ꥪ DCclico ᯥ譮 ᮧ'
            else msg='DCclico object successfully created'
            say Grey_color'    'msg'!'
            call SysSleep VisualDelay
          end
        else
          do
            if MsgRLang then msg=' ᮧ ꥪ DCclico'
            else msg='DCclico object creating failed'
            say Red_color'    'ErrorMsg.MsgRLang''Yellow_color''msg'!'
            call AbortProg(1)
          end

        /******************************************************/
        /* Create DC User Pack Uninstall object               */
        /******************************************************/
        if MsgRLang then cpProgName='⠫ DC User Pack'
        else cpProgName='Uninstall DC User Pack'
        param='ICONFILE='InstallDir'\'DistFile.5';EXENAME=*;PROGTYPE=WINDOWABLEVIO;MINIMIZED=NO;NOAUTOCLOSE=NO;PARAMETERS=/c start "Uninstall DC User Pack" /c /f /max /win 'InstallDir'\'RootFile.1' -Uninstall;STARTUPDIR='InstallDir
        if SysCreateObject('WPProgram',cpProgName,'<DCUP_FLD>',param,'REPLACE') then
          do
            if MsgRLang then msg='ꥪ ⠫樨 ᯥ譮 ᮧ'
            else msg='Uninstall object successfully created'
            say Grey_color'    'msg'!'
            call SysSleep VisualDelay
          end
        else
          do
            if MsgRLang then msg=' ᮧ ꥪ ⠫樨'
            else msg='Uninstall object creating failed'
            say Red_color'    'ErrorMsg.MsgRLang''Yellow_color''msg'!'
            call AbortProg(1)
          end

        /******************************************************/
        /* Install DC User Pack Information                   */
        /******************************************************/
        if MsgRLang then
          do
            msg='ᠭ DC User Pack'; InfFile=DistFile.7
          end
        else
          do
            msg='DC User Pack Reference'; InfFile=DistFile.6
          end
        param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='InstallDir';PARAMETERS='InstallDir'\'InfFile
        if SysCreateObject('WPProgram',msg,'<DCUP_FLD>',param,'REPLACE') then
          do
            if MsgRLang then msg='ꥪ ᠭ DC User Pack ᯥ譮 ᮧ'
            else msg='DC User Pack Information object successfully created'
            say Grey_color'    'msg'!'
            call SysSleep VisualDelay
          end
        else
          do
            if MsgRLang then msg=' ᮧ ꥪ ᠭ DC User Pack'
            else msg='DC User Pack Information object creating failed'
            say Red_color'    'ErrorMsg.MsgRLang''Yellow_color''msg'!'
            call AbortProg(1)
          end
        if MsgRLang then msg=' ⠫樨 ᯥ譮 襭'
        else msg='Installation process successfully completed'
        say Green_color'  'msg'!'
      end
    else call AbortProg(1)
  end

else

/**************************************************************/
/* Select uninstallation mode                                 */
/**************************************************************/

  if Translate(Arg(1))='-UNINSTALL' then
    do
      if MsgRLang then msg='⠫'
      else msg='Uninstallation'
      say White_color''msg':'
      if MsgRLang then msg='稭 ⠫'
      else msg='Continue with uninstallation'
      call CharOut ,Green_color'  'msg' 'Cyan_color'(y/N)'Green_color'? 'White_color
      if AskYN(0) then
        do
          /****************************************************/
          /* Removing DC User Pack objects                    */
          /****************************************************/
          call SysCurState 'OFF'
          if MsgRLang then msg='塞 ꥪ DC User Pack  ࠡ祣 ⮫'
          else msg='Removing DC User Pack objects from the desktop'
          call CharOut ,Grey_color'    'msg'... '
          if SysDestroyObject('<DCUP_FLD>') then
            do
              call SysSleep VisualDelay
              say White_color'Ok.'
            end
          else 
            do
              if MsgRLang then msg=' 㤠 ꥪ DC User Pack'
              else msg='DC User Pack objects removing failed'
              say; say Red_color'    'ErrorMsg.MsgRLang''Yellow_color''msg'!'
              call AbortProg(2)
            end

          /****************************************************/
          /* Removing DC User Pack from the system INI files  */
          /****************************************************/
          if MsgRLang then msg='塞  DC User Pack  ⥬ INI 䠩'
          else msg='Removing DC User Pack records from the system INI files'
          call CharOut ,Grey_color'    'msg'... '
          if SysIni('BOTH','Clipboard Coder','DELETE:')='ERROR:' then
            do
              if MsgRLang then msg=' 㤠   ⥬ INI 䠩'
              else msg='Removing records from the system INI files failed'
              say; say Red_color'    'ErrorMsg.MsgRLang''Yellow_color''msg'!'
              call AbortProg(2)
            end
          else
            do
              call SysSleep VisualDelay
              say White_color'Ok.'
            end

          /****************************************************/
          /* Removing DC User Pack relative DLLs              */
          /****************************************************/
          if MsgRLang then msg='塞 易  DC User Pack DLL-'
          else msg='Removing DC User Pack relative DLLs'
          call CharOut ,Grey_color'    'msg'... '
          parse value SysCurPos() with Oldrow Oldcol
          say; call RemoveDLL
          call SysCurPos Oldrow,Oldcol
          say White_color'Ok.'

          /****************************************************/
          /* Removing DC User Pack files                      */
          /****************************************************/
          if MsgRLang then msg='塞 䠩 DC User Pack'
          else msg='Removing DC User Pack files'
          call CharOut ,Grey_color'    'msg'... '
          call SysFileTree '*','file','FOS'
          do i=1 to file.0
            if SysFileDelete(file.i)\=0 then
              do
                if MsgRLang then msg=' 㤠 䠩 DC User Pack'
                else msg='DC User Pack files removing failed'
                say; say Red_color'    'ErrorMsg.MsgRLang''Yellow_color''msg'!'
                call AbortProg(2)
              end
          end
          call SysSleep VisualDelay
          say White_color'Ok.'

          /****************************************************/
          /* Removing DC User Pack directories                */
          /****************************************************/
          if MsgRLang then msg='塞 ४ਨ DC User Pack'
          else msg='Removing DC User Pack directories'
          call CharOut ,Grey_color'    'msg'... '
          if SysRmDir(PluginDir)\=0 then
            do
              if MsgRLang then msg=' 㤠 ४ 㣨'
              else msg='Can`t remove plugin directory'
              say; say Red_color'    'ErrorMsg.MsgRLang''Yellow_color''msg'!'
              call AbortProg(2)
            end
          currentDCdir=Directory()
          call Directory '..'
          if SysRmDir(currentDCdir)\=0 then
            do
              if MsgRLang then msg=' 㤠 ४ DC User Pack'
              else msg='Can`t remove DC User Pack directory'
              say; say Red_color'    'ErrorMsg.MsgRLang''Yellow_color''msg'!'
              call AbortProg(2)
            end
          call SysSleep VisualDelay
          say White_color'Ok.'
          if MsgRLang then msg=' ⠫樨 ᯥ譮 襭'
          else msg='Uninstallation process successfully completed'
          say Green_color'  'msg'!'
        end
    end
  else
    do
      if MsgRLang then msg='ਡ⨢  '
      else msg='The distributive is not full'
      say; say Red_color''msg'!!!'White_color
      call AbortProg(1)
    end

if MsgRLang then msg='믮'
else msg='Done'
say; say Green_color''msg'.'White_color
call PressAnyKey
exit



/**************************************************************/
/* Procedures                                                 */
/**************************************************************/

RemoveDLL:
call SysFileSearch 'LIBPATH',BootDrv'\CONFIG.SYS','file'
s=Translate(Translate(file.1,' ',';'))
parse var s 'LIBPATH='s
if MsgRLang then msg='塞'
else msg='Removing'
do i=1 to Words(s)
  SysLibPath=Word(s,i)
  if Right(SysLibPath,1)\='\' then SysLibPath=SysLibPath'\'
  do j=1 to DllFilesCount
    if Stream(SysLibPath''DllFile.j,'c','query exists')\='' & SysLibPath\='.\' then
      do
        say Grey_color'      'msg' 'Yellow_color''SysLibPath''DllFile.j''Grey_color'...'
        call SysFileDelete SysLibPath''DllFile.j
        call SysSleep VisualDelay
        call ClearPrevLine
      end
  end
  do j=1 to ComDllFilesCount
    if Stream(SysLibPath''ComDllFile.j,'c','query exists')\='' & SysLibPath\='.\' then
      do
        say Grey_color'      'msg' 'Yellow_color''SysLibPath''ComDllFile.j''Grey_color'...'
        call SysFileDelete SysLibPath''ComDllFile.j
        call SysSleep VisualDelay
        call ClearPrevLine
      end
  end
end
return

ClearPrevLine:
parse value SysCurPos() with row col
call SysCurPos row-1,0
say Copies(' ',79)
call SysCurPos row-1,0
return

AskYN:
do forever
  Key=SysGetKey('NOECHO')
  Key=Translate(Key)
  if Key='Y' | Key='N' | Key=d2c(13) then
    do
      if Key='Y' | (Key=d2c(13) & Arg(1)) then
        do
          reply=1; Key='y'
        end
      if Key='N' | (Key=d2c(13) & \Arg(1)) then
        do
          reply=0; Key='n'
        end
      call CharOut ,Key
      leave
    end
end
say
return reply

PressAnyKey:
say Esc'0;37m'
call SysCurState 'OFF'
if MsgRLang then msg='  '
else msg='Press any key'
call CharOut ,msg'...'
call SysGetKey('NOECHO')
call SysCurState 'ON'
return

AbortProg:
say
if MsgRLang then
  do
    if Arg(1) then msg=''
    else msg=''
    say Red_color' 'msg'⠫樨 ࢠ.'
  end
else
  do
    if Arg(1) then Prefix='I'
    else Prefix='Uni'
    say Red_color''Prefix'nstallation process aborted.'
  end
call PressAnyKey
exit

EmxRevision: procedure
  arg pathname
  call RxFuncAdd emx_revision, pathname, emx_revision
  signal on syntax name EmxError
  tmp = emx_revision()
  signal off syntax
  call RxFuncDrop emx_revision
  return tmp

EmxError:
  return 0
