/***************************************************************************/
/* Clipboard Coder (v0.07 and above)                                       */
/*-------------------------------------------------------------------------*/
/* DCmime.DLL                                                              */
/*   ४஢ MIME-஢ ⥪⮢                               */
/*-------------------------------------------------------------------------*/
/* DCmime.c                                                     09/09/1999 */
/***************************************************************************/

/***************************************************************************/
/* (c) VicTor Smirnoff, 1997-99                       sva@water.karelia.ru */
/***************************************************************************/
#define INCL_PM

#include <os2.h>
#include <stdlib.h>            // 㦥  max()
#include <string.h>            // 㦥  strncpy()
#include <stdio.h>             // 㦥  sprintf()
#include "DCplugin.h"
#include "DCmime.h"


/***************************************************************************/
/* DCpluginID( PHPLUGIN h, PIDPLUGIN p )                                   */
/*=========================================================================*/
/* 䨪                                                    */
/***************************************************************************/
APIRET APIENTRY DCpluginID( PHPLUGIN h, PIDPLUGIN p )
{
   ULONG idMsg;

   if ( h->pluginVer < DC_PLUGINVER )  return (APIRET)DC_ERROR;

   p->pluginWin = TRUE;        //  ᮡ⢥ 

   idMsg = RUS_TABPLUGIN;  if ( h->pluginCP != 866L )  idMsg++;
   WinLoadString( h->pluginHab, h->pluginHmod, idMsg, DC_MAXTAB,
      (PSZ)p->pluginTab );
   idMsg = RUS_MSGPLUGIN;  if ( h->pluginCP != 866L )  idMsg++;
   WinLoadString( h->pluginHab, h->pluginHmod, idMsg, DC_MAXMSG,
      (PSZ)p->pluginMsg );
   WinLoadString( h->pluginHab, h->pluginHmod, ID_DEVPLUGIN, DC_MAXMSG,
      (PSZ)p->pluginDev );

   return (APIRET)DC_OK;
}
/*=========================================================================*/
/* end of DCpluginID( )                                                    */
/***************************************************************************/



/***************************************************************************/
/* DCpluginIni( PHPLUGIN h )                                               */
/*=========================================================================*/
/* 樠                                                    */
/***************************************************************************/
APIRET APIENTRY DCpluginIni( PHPLUGIN h )
{
   PMYDATA p;
   APIRET  rc;
   ULONG   idDlg;
   HINI    hini;

   if (h->pluginHwnd == NULLHANDLE)  return (APIRET)DC_ERROR;

//   p = (PMYDATA)malloc( sizeof(MYDATA) );
   rc = DosAllocMem( (PPVOID)&p,
                     (ULONG)(sizeof(MYDATA)),
        PAG_WRITE | PAG_READ | PAG_COMMIT );
   if (rc != 0)  return (APIRET)DC_ERROR;

   memset( p, 0, sizeof(MYDATA) );
   p->size = sizeof(MYDATA);               //  ॡ 

   WinLoadString( h->pluginHab, h->pluginHmod, ID_INIFILE, MY_INISIZE,
      (PSZ)p->iniFile );
   WinLoadString( h->pluginHab, h->pluginHmod, ID_INIAPP, MY_INISIZE,
      (PSZ)p->iniApp );
   WinLoadString( h->pluginHab, h->pluginHmod, ID_INIKEYFROM, MY_INISIZE,
      (PSZ)p->iniKeyFrom );
   WinLoadString( h->pluginHab, h->pluginHmod, ID_INIKEYTO, MY_INISIZE,
      (PSZ)p->iniKeyTo );

   hini = PrfOpenProfile( h->pluginHab, (PSZ)p->iniFile );
   if ( hini )
   {
      ULONG xSize;

      xSize = sizeof( ULONG );
      PrfQueryProfileData( hini,
         (PSZ)p->iniApp, (PSZ)p->iniKeyFrom,
         &(p->fromMIME), &xSize );
      if (p->fromMIME == 0L)  p->fromMIME = MIME_FROMTEXT;
      xSize = sizeof( ULONG );
      PrfQueryProfileData( hini,
         (PSZ)p->iniApp, (PSZ)p->iniKeyTo,
         &(p->toMIME), &xSize );
      if (p->toMIME == 0L && p->fromMIME == MIME_FROMTEXT)
         p->toMIME = MIME_TOUUENCODE;
      else if (p->toMIME == 0L)  p->toMIME = MIME_TOTEXT;
      PrfCloseProfile( hini );
   }

   p->DCplus = WinLoadLibrary( h->pluginHab, "DCPLUS" );
   if ( p->DCplus != NULLHANDLE )
   {
      p->enQuoted  =  (PFNDC)WinLoadProcedure( h->pluginHab, p->DCplus, "enQuoted" );
      p->deQuoted  =  (PFNDC)WinLoadProcedure( h->pluginHab, p->DCplus, "deQuoted" );
      p->B64encode = (PFNDCX)WinLoadProcedure( h->pluginHab, p->DCplus, "B64encode" );
      p->B64decode =  (PFNDC)WinLoadProcedure( h->pluginHab, p->DCplus, "B64decode" );
      p->UUencode  = (PFNDCX)WinLoadProcedure( h->pluginHab, p->DCplus, "UUencode" );
      p->UUdecode  =  (PFNDC)WinLoadProcedure( h->pluginHab, p->DCplus, "UUdecode" );
   }
   if (( p->enQuoted  == NULL ) &&
       ( p->deQuoted  == NULL ) &&
       ( p->B64encode == NULL ) &&
       ( p->B64decode == NULL ) &&
       ( p->UUencode  == NULL ) &&
       ( p->UUdecode  == NULL ) )
   {
      if ( p->DCplus != NULLHANDLE )
         WinDeleteLibrary( h->pluginHab, p->DCplus );
      h->pluginUser = NULL;

//      free( p );
      DosFreeMem( p );
      return (APIRET)DC_ERROR;
   }

   idDlg = RUS_WINDOW;  if ( h->pluginCP != 866L )  idDlg = ENG_WINDOW;
   p->hwnd = WinLoadDlg( h->pluginHwnd,    //  ࠧ
                h->pluginHwnd,             //  ᮡ⢥
                WndDlgPlugin,              // 楤 ࠡ⪨ 
                h->pluginHmod,             // 0 -  EXE   #0 -  DLL
                idDlg,                     // 䨪   
                p );                       //   樠樨
   if ( p->hwnd == NULLHANDLE )
   {
      h->pluginUser = NULL;

//      free( p );
      DosFreeMem( p );
      return (APIRET)DC_ERROR;
   }
   h->pluginUser = (PVOID)p;

   DCpluginSize( h );

   return (APIRET)DC_OK;
}
/*=========================================================================*/
/* end of DCpluginIni( )                                                   */
/***************************************************************************/



/***************************************************************************/
/* DCpluginRun( PHPLUGIN h, CHAR *in, ULONG lin, CHAR **out, PULONG lout ) */
/*=========================================================================*/
/* 믮 㭪樨                                               */
/***************************************************************************/
APIRET APIENTRY DCpluginRun( PHPLUGIN h, CHAR * in, ULONG lin, CHAR ** out, PULONG lout )
{
   PMYDATA p;
   APIRET  rc;
   ULONG   xFromTo;
   int     xMult;

   p = (PMYDATA)h->pluginUser;

   if (p->toMIME == MIME_TOQUOTED)     xMult = 4;
   else if (p->toMIME == MIME_TOTEXT)  xMult = 1;
   else  xMult = 2;

// !     室  易⥫쭮
//   ॡ ᯮ짮 DosAllocMem().
//   ᢮     -  ᤥ clico.
   rc = DosAllocMem( (PPVOID)out,
                     (ULONG)(lin * xMult),
        PAG_WRITE | PAG_READ | PAG_COMMIT );
   if (rc)
   {
      *out = NULL;  *lout = 0L;
      return (APIRET)DC_ERROR; 
   }

   xFromTo = p->fromMIME + p->toMIME;
   switch (xFromTo)
   {
   case TEXT_TOUUENCODE:
      rc = p->UUencode( in, *out, lin );
      break;

   case TEXT_TOBASE64:
      rc = p->B64encode( in, *out, lin );
      break;

   case TEXT_TOQUOTED:
      rc = p->enQuoted( in, *out );
      break;

   case TEXT_FROMUUENCODE:
      rc = p->UUdecode( in, *out );
      break;

   case TEXT_FROMBASE64:
      rc = p->B64decode( in, *out );
      break;

   case TEXT_FROMQUOTED:
      rc = p->deQuoted( in, *out );
      break;

   default:
      break;
   } /* endswitch */

   *lout = strlen( *out );
   return (APIRET)DC_OK;
}
/*=========================================================================*/
/* end of DCpluginRun( )                                                   */
/***************************************************************************/



/***************************************************************************/
/* DCpluginEnd( PHPLUGIN h )                                               */
/*=========================================================================*/
/* 樠                                                  */
/***************************************************************************/
APIRET APIENTRY DCpluginEnd( PHPLUGIN h )
{
   PMYDATA p;
   HINI    hini;

   p = (PMYDATA)h->pluginUser;

   if ( p != NULL )
   {
      WinDismissDlg( p->hwnd, 0L );
      WinDestroyWindow( p->hwnd );

      if ( p->enQuoted  != NULL )
         WinDeleteProcedure( h->pluginHab, (PFNWP)p->enQuoted  );
      if ( p->deQuoted  != NULL )
         WinDeleteProcedure( h->pluginHab, (PFNWP)p->deQuoted  );
      if ( p->B64encode != NULL )
         WinDeleteProcedure( h->pluginHab, (PFNWP)p->B64encode );
      if ( p->B64decode != NULL )
         WinDeleteProcedure( h->pluginHab, (PFNWP)p->B64decode );
      if ( p->UUencode  != NULL )
         WinDeleteProcedure( h->pluginHab, (PFNWP)p->UUencode  );
      if ( p->UUdecode  != NULL )
         WinDeleteProcedure( h->pluginHab, (PFNWP)p->UUdecode  );
      if ( p->DCplus != NULLHANDLE )
         WinDeleteLibrary( h->pluginHab, p->DCplus );

      hini = PrfOpenProfile( h->pluginHab, (PSZ)p->iniFile );
      if ( hini )
      {
         PrfWriteProfileData( hini,
            (PSZ)p->iniApp, NULL, NULL, 0L );
         PrfWriteProfileData( hini,
            (PSZ)p->iniApp, (PSZ)p->iniKeyFrom,
            &(p->fromMIME), sizeof( ULONG ) );
         PrfWriteProfileData( hini,
            (PSZ)p->iniApp, (PSZ)p->iniKeyTo,
            &(p->toMIME), sizeof( ULONG ) );
         PrfCloseProfile( hini );
      }

//      free( (PVOID)h->pluginUser );
      DosFreeMem( (PVOID)h->pluginUser );
   } /* endif */

   return (APIRET)DC_OK;
}
/*=========================================================================*/
/* end of DCpluginEnd( )                                                   */
/***************************************************************************/




/***************************************************************************/
/* DCpluginSize( PHPLUGIN h )                                              */
/*=========================================================================*/
/*  ࠧ஢                                               */
/***************************************************************************/
APIRET APIENTRY DCpluginSize( PHPLUGIN h )
{
   PMYDATA p;
   p = (PMYDATA)h->pluginUser;

   if ( p != NULL )
   {
      WinSetWindowPos( p->hwnd, HWND_TOP, 0, 0, 0, 0, SWP_MOVE | SWP_SHOW );
   } /* endif */

   return (APIRET)DC_OK;
}
/*=========================================================================*/
/* end of DCpluginSize( )                                                  */
/***************************************************************************/




/***************************************************************************/
/* WndDlgPlugin( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )            */
/*=========================================================================*/
/* ࠡ⪠                                                        */
/***************************************************************************/
MRESULT EXPENTRY WndDlgPlugin( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   switch ( msg )
   {
   case WM_INITDLG:
      {
         PMYDATA p;

         p = (PMYDATA)LONGFROMMP( mp2 );

         WinSetWindowULong( hwnd, QWL_USER, (ULONG)p );

         if ( (p->toMIME == MIME_TOUUENCODE) && (p->UUencode == NULL) )
            p->toMIME = MIME_TOBASE64;
         if ( (p->toMIME == MIME_TOBASE64) && (p->B64encode == NULL) )
            p->toMIME = MIME_TOQUOTED;
         if ( (p->toMIME == MIME_TOQUOTED) && (p->enQuoted == NULL) )
            p->toMIME = MIME_TOTEXT;

         if ( (p->fromMIME == MIME_FROMTEXT) &&
              (p->UUencode == NULL) &&
              (p->B64encode == NULL) &&
              (p->enQuoted == NULL) )
         {
            WinEnableControl( hwnd, p->fromMIME, FALSE );
            p->fromMIME = MIME_FROMUUENCODE;
         } /* endif */
         if ( (p->fromMIME == MIME_FROMUUENCODE) && (p->UUdecode == NULL) )
         {
            WinEnableControl( hwnd, p->fromMIME, FALSE );
            p->fromMIME = MIME_FROMBASE64;
         } /* endif */
         if ( (p->fromMIME == MIME_FROMBASE64) && (p->B64decode == NULL) )
         {
            WinEnableControl( hwnd, p->fromMIME, FALSE );
            p->fromMIME = MIME_FROMQUOTED;
         } /* endif */
         if ( (p->fromMIME == MIME_FROMQUOTED) && (p->deQuoted == NULL) )
         {
            WinEnableControl( hwnd, p->fromMIME, FALSE );
            p->fromMIME = MIME_FROMTEXT;
         } /* endif */

         WinSendMsg( WinWindowFromID( hwnd, p->toMIME ),
            BM_SETCHECK,
            MPFROMSHORT( 1 ),
            NULL );
         WinPostMsg( WinWindowFromID( hwnd, p->fromMIME ),
            BM_CLICK,
            MPFROMSHORT( FALSE ),
            NULL );
      }
      break;

   case WM_CONTROL:
      {
         PMYDATA p;
         ULONG   i;

         p = (PMYDATA)WinQueryWindowULong( hwnd, QWL_USER );

         switch ( SHORT1FROMMP( mp1 ) )
         {
         case MIME_FROMTEXT:
            for ( i=MIME_TOTEXT; i<=MIME_TOQUOTED; i+=10)
            {
               WinEnableControl( hwnd, i, TRUE );
            } /* endfor */
            p->fromMIME = (ULONG)SHORT1FROMMP( mp1 );
            WinSendMsg( WinWindowFromID( hwnd, p->toMIME ),
               BM_SETCHECK,
               MPFROMSHORT( 0 ),
               NULL );
            WinEnableControl( hwnd, MIME_TOTEXT, FALSE );

            if (p->toMIME == MIME_TOTEXT)  p->toMIME = MIME_TOUUENCODE;
            if ( (p->toMIME == MIME_TOUUENCODE) && (p->UUencode == NULL) )
            {
               WinEnableControl( hwnd, p->toMIME, FALSE );
               p->toMIME = MIME_TOBASE64;
            } /* endif */
            if ( (p->toMIME == MIME_TOBASE64) && (p->B64encode == NULL) )
            {
               WinEnableControl( hwnd, p->toMIME, FALSE );
               p->toMIME = MIME_TOQUOTED;
            } /* endif */
            if ( (p->toMIME == MIME_TOQUOTED) && (p->enQuoted == NULL) )
            {
               WinEnableControl( hwnd, p->toMIME, FALSE );
               p->toMIME = MIME_TOTEXT;
            } /* endif */

            if (p->toMIME != MIME_TOTEXT)
            {
               WinSendMsg( WinWindowFromID( hwnd, p->toMIME ),
                  BM_SETCHECK,
                  MPFROMSHORT( 1 ),
                  NULL );
            } /* endif */
            break;

         case MIME_FROMUUENCODE:
         case MIME_FROMBASE64:
         case MIME_FROMQUOTED:
            for ( i=MIME_TOTEXT; i<=MIME_TOQUOTED; i+=10)
            {
               WinEnableControl( hwnd, i, TRUE );
            } /* endfor */
            p->fromMIME = (ULONG)SHORT1FROMMP( mp1 );
            WinSendMsg( WinWindowFromID( hwnd, p->toMIME ),
               BM_SETCHECK,
               MPFROMSHORT( 0 ),
               NULL );
            for ( i=MIME_TOUUENCODE; i<=MIME_TOQUOTED; i+=10)
            {
               WinEnableControl( hwnd, i, FALSE );
            } /* endfor */
            p->toMIME = MIME_TOTEXT;
            WinSendMsg( WinWindowFromID( hwnd, p->toMIME ),
               BM_SETCHECK,
               MPFROMSHORT( 1 ),
               NULL );
            break;

         case MIME_TOTEXT:
         case MIME_TOUUENCODE:
         case MIME_TOBASE64:
         case MIME_TOQUOTED:
            p->toMIME = (ULONG)SHORT1FROMMP( mp1 );
            break;

         default:
            break;
         } /* endswitch */
      }
      break;

   case WM_COMMAND:
      switch( SHORT1FROMMP( mp1 ) )
      {
//   ᭨ ( )
      case DID_CANCEL:
         break;

      default:
         return WinDefDlgProc( hwnd, msg, mp1, mp2 );
      }
      break;

   default:
      return WinDefDlgProc( hwnd, msg, mp1, mp2 );
   } /* endswitch */
   return (MRESULT) FALSE;
}
/*=========================================================================*/
/* end of WndDlgPlugin( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )     */
/***************************************************************************/




