/***************************************************************************/
/* Clipboard Coder (v0.07 and above)                                       */
/*-------------------------------------------------------------------------*/
/* DCsystem.DLL                                                            */
/*   ४஢    ࠭    ᯮ짮     */
/*   ⥬ 㭪権                                                     */
/*-------------------------------------------------------------------------*/
/* DCsystem.c                                                   09/09/1999 */
/***************************************************************************/

/***************************************************************************/
/* (c) VicTor Smirnoff, 1997-99                       sva@water.karelia.ru */
/***************************************************************************/
#define INCL_PM

#include <os2.h>
#include <stdlib.h>            // 㦥  max()
#include <string.h>            // 㦥  strncpy()
#include <stdio.h>             // 㦥  sprintf()
#include "DCplugin.h"
#include "DCsystem.h"


/***************************************************************************/
/* DCpluginID( PHPLUGIN h, PIDPLUGIN p )                                   */
/*=========================================================================*/
/* 䨪                                                    */
/***************************************************************************/
APIRET APIENTRY DCpluginID( PHPLUGIN h, PIDPLUGIN p )
{
   ULONG idMsg;

   if ( h->pluginVer < DC_PLUGINVER )  return (APIRET)DC_ERROR;

   p->pluginWin = TRUE;        //  ᮡ⢥ 

   idMsg = RUS_TABPLUGIN;  if ( h->pluginCP != 866L )  idMsg++;
   WinLoadString( h->pluginHab, h->pluginHmod, idMsg, DC_MAXTAB,
      (PSZ)p->pluginTab );
   idMsg = RUS_MSGPLUGIN;  if ( h->pluginCP != 866L )  idMsg++;
   WinLoadString( h->pluginHab, h->pluginHmod, idMsg, DC_MAXMSG,
      (PSZ)p->pluginMsg );
   WinLoadString( h->pluginHab, h->pluginHmod, ID_DEVPLUGIN, DC_MAXMSG,
      (PSZ)p->pluginDev );

   return (APIRET)DC_OK;
}
/*=========================================================================*/
/* end of DCpluginID( )                                                    */
/***************************************************************************/



/***************************************************************************/
/* DCpluginIni( PHPLUGIN h )                                               */
/*=========================================================================*/
/* 樠                                                    */
/***************************************************************************/
APIRET APIENTRY DCpluginIni( PHPLUGIN h )
{
   PMYDATA p;
   APIRET  rc;
   ULONG   idDlg;
   HINI    hini;

   if (h->pluginHwnd == NULLHANDLE)  return (APIRET)DC_ERROR;

//   p = (PMYDATA)malloc( sizeof(MYDATA) );
   rc = DosAllocMem( (PPVOID)&p,
                     (ULONG)(sizeof(MYDATA)),
        PAG_WRITE | PAG_READ | PAG_COMMIT );
   if (rc != 0)  return (APIRET)DC_ERROR;

   memset( p, 0, sizeof(MYDATA) );
   p->size = sizeof(MYDATA);               //  ॡ 

   WinLoadString( h->pluginHab, h->pluginHmod, ID_INIFILE, MY_INISIZE,
      (PSZ)p->iniFile );
   WinLoadString( h->pluginHab, h->pluginHmod, ID_INIAPP, MY_INISIZE,
      (PSZ)p->iniApp );
   WinLoadString( h->pluginHab, h->pluginHmod, ID_INIKEYFROM, MY_INISIZE,
      (PSZ)p->iniKeyFrom );
   WinLoadString( h->pluginHab, h->pluginHmod, ID_INIKEYTO, MY_INISIZE,
      (PSZ)p->iniKeyTo );

   hini = PrfOpenProfile( h->pluginHab, (PSZ)p->iniFile );
   if ( hini )
   {
      ULONG xSize;

      xSize = sizeof( ULONG );
      PrfQueryProfileData( hini,
         (PSZ)p->iniApp, (PSZ)p->iniKeyFrom,
         &(p->fromCP), &xSize );
      xSize = sizeof( ULONG );
      PrfQueryProfileData( hini,
         (PSZ)p->iniApp, (PSZ)p->iniKeyTo,
         &(p->toCP), &xSize );
      PrfCloseProfile( hini );
   }

   p->countCP = WinQueryCpList( h->pluginHab, 0L, NULL );
   if (p->countCP == 0L)
   {
      h->pluginUser = NULL;
//      free( p );
      DosFreeMem( p );
      return (APIRET)DC_ERROR;
   } /* endif */

   rc = DosAllocMem( (PPVOID)&(p->tableCP),
           (ULONG)(sizeof(ULONG)*p->countCP),
           PAG_WRITE | PAG_READ | PAG_COMMIT );
   if (rc)
   {
      h->pluginUser = NULL;
//      free( p );
      DosFreeMem( p );
      return (APIRET)DC_ERROR;
   } /* endif */

   WinQueryCpList( h->pluginHab, (ULONG)p->countCP, p->tableCP );

   idDlg = RUS_WINDOW;  if ( h->pluginCP != 866L )  idDlg = ENG_WINDOW;
   p->hwnd = WinLoadDlg( h->pluginHwnd,    //  ࠧ
                h->pluginHwnd,             //  ᮡ⢥
                WndDlgPlugin,              // 楤 ࠡ⪨ 
                h->pluginHmod,             // 0 -  EXE   #0 -  DLL
                idDlg,                     // 䨪   
                p );                       //   樠樨
   if ( p->hwnd == NULLHANDLE )
   {
      h->pluginUser = NULL;

      DosFreeMem( p->tableCP );
//      free( p );
      DosFreeMem( p );
      return (APIRET)DC_ERROR;
   }
   h->pluginUser = (PVOID)p;

   DCpluginSize( h );

   return (APIRET)DC_OK;
}
/*=========================================================================*/
/* end of DCpluginIni( )                                                   */
/***************************************************************************/



/***************************************************************************/
/* DCpluginRun( PHPLUGIN h, CHAR *in, ULONG lin, CHAR **out, PULONG lout ) */
/*=========================================================================*/
/* 믮 㭪樨                                               */
/***************************************************************************/
APIRET APIENTRY DCpluginRun( PHPLUGIN h, CHAR * in, ULONG lin, CHAR ** out, PULONG lout )
{
   PMYDATA p;
   APIRET rc;
   BOOL   success;

   p = (PMYDATA)h->pluginUser;

// !     室  易⥫쭮
//   ॡ ᯮ짮 DosAllocMem().
//   ᢮     -  ᤥ clico.
   rc = DosAllocMem( (PPVOID)out,
                     (ULONG)(lin * 2),
        PAG_WRITE | PAG_READ | PAG_COMMIT );
   if (rc)
   {
      *out = NULL;  *lout = 0L;
      return (APIRET)DC_ERROR; 
   }

   success = WinCpTranslateString( h->pluginHab,
                p->fromCP, in,
                p->toCP, lin * 2, *out );
   if (!success)
   {
      DosFreeMem( *out );
      *out = NULL;  *lout = 0L;
      return (APIRET)DC_ERROR; 
   }

   *lout = strlen( *out );
   return (APIRET)DC_OK;
}
/*=========================================================================*/
/* end of DCpluginRun( )                                                   */
/***************************************************************************/



/***************************************************************************/
/* DCpluginEnd( PHPLUGIN h )                                               */
/*=========================================================================*/
/* 樠                                                  */
/***************************************************************************/
APIRET APIENTRY DCpluginEnd( PHPLUGIN h )
{
   PMYDATA p;
   HINI    hini;

   p = (PMYDATA)h->pluginUser;

   if ( p != NULL )
   {
      WinDismissDlg( p->hwnd, 0L );
      WinDestroyWindow( p->hwnd );

      hini = PrfOpenProfile( h->pluginHab, (PSZ)p->iniFile );
      if ( hini )
      {
         PrfWriteProfileData( hini,
            (PSZ)p->iniApp, NULL, NULL, 0L );
         PrfWriteProfileData( hini,
            (PSZ)p->iniApp, (PSZ)p->iniKeyFrom,
            &(p->fromCP), sizeof( ULONG ) );
         PrfWriteProfileData( hini,
            (PSZ)p->iniApp, (PSZ)p->iniKeyTo,
            &(p->toCP), sizeof( ULONG ) );
         PrfCloseProfile( hini );
      }

      DosFreeMem( p->tableCP );
//      free( (PVOID)h->pluginUser );
      DosFreeMem( (PVOID)h->pluginUser );
   } /* endif */

   return (APIRET)DC_OK;
}
/*=========================================================================*/
/* end of DCpluginEnd( )                                                   */
/***************************************************************************/




/***************************************************************************/
/* DCpluginSize( PHPLUGIN h )                                              */
/*=========================================================================*/
/*  ࠧ஢                                               */
/***************************************************************************/
APIRET APIENTRY DCpluginSize( PHPLUGIN h )
{
   PMYDATA p;
   p = (PMYDATA)h->pluginUser;

   if ( p != NULL )
   {
      SWP   swp, swpDlg, swpX;
      LONG  dX, dY;
      ULONG i;

//      WinShowWindow( p->hwnd, FALSE );
      WinQueryWindowPos( h->pluginHwnd, &swp );
      WinQueryWindowPos( p->hwnd, &swpDlg );

      dX = swp.cx - swpDlg.cx;
      dY = swp.cy - swpDlg.cy;

      for (i=SYSTEM_FROM; i<=SYSTEM_TOLIST; i++)
      {
         WinQueryWindowPos( WinWindowFromID( p->hwnd, i ), &swpDlg );

         switch (i)
         {
         case SYSTEM_FROM:
         case SYSTEM_TO:
            WinSetWindowPos( WinWindowFromID( p->hwnd, i ),
               HWND_TOP, 0L, 0L, swpDlg.cx + dX, swpDlg.cy + dY,
               SWP_SIZE );
            break;

         case SYSTEM_FROMLIST:
         case SYSTEM_TOLIST:
            WinQueryWindowPos( WinWindowFromID( p->hwnd, SYSTEM_FROM ), &swpX );
            WinSetWindowPos( WinWindowFromID( p->hwnd, i ),
               HWND_TOP, 0L, 0L, swpDlg.cx + dX - 4L, swpX.cy - 32L,
               SWP_SIZE );
            break;

         default:
            break;
         } /* endswitch */
      } /* endfor */

      WinSetWindowPos( p->hwnd, HWND_TOP, 0, 0, swp.cx, swp.cy,
         SWP_SIZE | SWP_MOVE | SWP_SHOW );
   } /* endif */

   return (APIRET)DC_OK;
}
/*=========================================================================*/
/* end of DCpluginSize( )                                                  */
/***************************************************************************/




/***************************************************************************/
/* WndDlgPlugin( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )            */
/*=========================================================================*/
/* ࠡ⪠                                                        */
/***************************************************************************/
MRESULT EXPENTRY WndDlgPlugin( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   switch ( msg )
   {
   case WM_INITDLG:
      {
         PMYDATA p;
         ULONG i, iFrom, iTo;
         CHAR  xMsg[16];

         p = (PMYDATA)LONGFROMMP( mp2 );

         WinSetWindowULong( hwnd, QWL_USER, (ULONG)p );

         WinSendDlgItemMsg( hwnd, SYSTEM_FROMLIST,
            LM_DELETEALL, (MPARAM)0, (MPARAM)0 );
         WinSendDlgItemMsg( hwnd, SYSTEM_TOLIST,
            LM_DELETEALL, (MPARAM)0, (MPARAM)0 );

         if (p->countCP == 0L)
         {
            WinEnableControl( hwnd, SYSTEM_FROMLIST, FALSE );
            WinEnableControl( hwnd, SYSTEM_TOLIST, FALSE );
            break;
         } /* endif */

//  ᯨ᪨
         iFrom = 0L;  iTo = 0L;
         for ( i=0; i<p->countCP; i++ )
         {
            if (p->fromCP == p->tableCP[i])  iFrom = i;
            if (p->toCP   == p->tableCP[i])  iTo   = i;
            sprintf( xMsg, "%d", p->tableCP[i] );
            WinSendDlgItemMsg(hwnd, SYSTEM_FROMLIST,
               LM_INSERTITEM, (MPARAM)LIT_END, MPFROMP(xMsg) );
            WinSendDlgItemMsg(hwnd, SYSTEM_TOLIST,
               LM_INSERTITEM, (MPARAM)LIT_END, MPFROMP(xMsg) );
         } /* endfor */

         p->fromCP = p->tableCP[iFrom];
         p->toCP   = p->tableCP[iTo];

         WinPostMsg( WinWindowFromID(hwnd, SYSTEM_TOLIST),
            LM_SELECTITEM, MPFROMSHORT(iTo), MPFROMSHORT(TRUE) );
         WinPostMsg( WinWindowFromID(hwnd, SYSTEM_FROMLIST),
            LM_SELECTITEM, MPFROMSHORT(iFrom), MPFROMSHORT(TRUE) );
      }
      break;

   case WM_CONTROL:
      {
         PMYDATA p;

         p = (PMYDATA)WinQueryWindowULong( hwnd, QWL_USER );

         switch ( SHORT1FROMMP( mp1 ) )
         {
         case SYSTEM_FROMLIST:
            if (SHORT2FROMMP(mp1) == LN_SELECT)
            {
               int iCP;

               iCP = (int)WinSendDlgItemMsg( hwnd, SYSTEM_FROMLIST,
                             LM_QUERYSELECTION, (MPARAM)LIT_FIRST, (MPARAM)0 );
               p->fromCP = p->tableCP[iCP];
            }
            break;

         case SYSTEM_TOLIST:
            if (SHORT2FROMMP(mp1) == LN_SELECT)
            {
               int iCP;

               iCP = (int)WinSendDlgItemMsg( hwnd, SYSTEM_TOLIST,
                             LM_QUERYSELECTION, (MPARAM)LIT_FIRST, (MPARAM)0 );
               p->toCP = p->tableCP[iCP];
            }
            break;

         default:
            break;
         } /* endswitch */
      }
      break;

   case WM_COMMAND:
      switch( SHORT1FROMMP( mp1 ) )
      {
//   ᭨ ( )
      case DID_CANCEL:
         break;

      default:
         return WinDefDlgProc( hwnd, msg, mp1, mp2 );
      }
      break;

   default:
      return WinDefDlgProc( hwnd, msg, mp1, mp2 );
   } /* endswitch */
   return (MRESULT) FALSE;
}
/*=========================================================================*/
/* end of WndDlgPlugin( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )     */
/***************************************************************************/




