/* Start FreeWnn server */
parse arg number
if number == '' then number = 1

parse source . . me .
myname = filespec('name', me )
parse upper var myname server '-' .

ur = value('UNIXROOT',,'OS2ENVIRONMENT')
logs = value('LOGFILES',,'OS2ENVIRONMENT')

logfile = logs'\'server'.log'
if stream( logfile, 'C', 'QUERY EXISTS') <> '' then do
    logsize = STREAM( logfile, 'C', 'QUERY SIZE')
    if logsize > ( 5 * 1048576 ) then do   /* 5 MB maximum log size */
        'copy' logfile logs'\'server'.bak'
        '@erase' logfile
    end
end

select
    when server == 'CSERVER' then bindir = 'cWnn4'
    when server == 'TSERVER' then bindir = 'cWnn4'
    when server == 'KSERVER' then bindir = 'kWnn4'
    otherwise                     bindir = 'Wnn4'
end

call directory ur
address cmd '@detach' ur'\usr\bin\'bindir'\'server '-s' logs'\'server'.log -N' number

return 0


