/*******************************************************
   ARNEDLL.CPP - Source code to a DLL for implementing
   foreign keyboard support in "OS/2 Performance beta I" 
          
   Compiled using IBM C/Set++ 2.1 (Probably works with other 
                                  OS/2 C++ compilers)

   This code may be modified to suit a specific keyboard as 
   long as all comments are included in unmodified form.


   Do you have MICROLEARN SWITCHER - a freeware utility from us?
   Available from ftp - filename of current version: MLSW101.ZIP

   (c) Jari Williamsson, MicroLearn Nordic, 1994
   - programmer for MicroLearn Game Pack, Volume 1 & 2 for OS/2


   If you have questions, please contact: jari@microlearn.se

*******************************************************/

#define INCL_PM
#define INCL_DOSMODULEMGR
#define INCL_DOSMEMMGR
#include <os2.h>
#include <string.h>
#include <stdio.h>

#define DLL_NAME "ARNEDLL" // File name of this DLL

#define ARR_SIZE 33 // Size of the array below

BOOL UseArneAnka; // Use/don't use flag

struct {
   BOOL bAltGraf;     // Use Alt key or not
   UCHAR ucScanCode;  // Scan code for key (only used with Alt key)
   char chFrom;       /* Transform from this US char - used
                         when bAltFraf is FALSE */
   char chTo;         // Transform to this foreign char
} usCharArray[ARR_SIZE] = {
   /* To following table is for Swedish keyboard - modify to suit 
      your keyboard: */
   TRUE,  0x03, '2', '@',
   TRUE,  0x04, '3', '',
   TRUE,  0x05, '4', '$',
   TRUE,  0x08, '7', '{',
   TRUE,  0x09, '8', '[',
   TRUE,  0x0a, '9', ']',
   TRUE,  0x0b, '0', '}',
   TRUE,  0x0c, '-', '\\',
   TRUE, 27, ']', '~',
   FALSE, 0, '@', '"',
   FALSE, 0, '~', '',
   FALSE, 0, '`', '',
   FALSE, 0, '$', '',
   FALSE, 0, '^', '&',
   FALSE, 0, '&', '/',
   FALSE, 0, '*', '(',
   FALSE, 0, '(', ')',
   FALSE, 0, ')', '=',
   FALSE, 0, '-', '+',
   FALSE, 0, '_', '?',
   FALSE, 0, '\\', 39,   // 39 = '
   FALSE, 0, '|', '*',
   FALSE, 0, '[', '',
   FALSE, 0, '{', '',
   FALSE, 0, ';', '',
   FALSE, 0, ':', '',
   FALSE, 0, 39,  '',   // 39 = '
   FALSE, 0, '"', '',
   FALSE, 0, '<', ';',
   FALSE, 0, '>', ':',
   FALSE, 0, '/', '-',
   FALSE, 0, '?', '_',
   FALSE, 0, '}', '^'
};

void CharProc(PQMSG pqmMsg)
// Entry for WM_CHAR filter messages:
{
   USHORT fsKeyFlags = (USHORT) SHORT1FROMMP(pqmMsg->mp1); // Keyboard flags
   USHORT usVirtualKey = (USHORT) SHORT2FROMMP(pqmMsg->mp2); 
                                          // Virtual key - if exist

   BYTE bArray[256]; // Keyboard state array
   /* Check current keyboard state - also possible to check
      by using the KC_xxxxxx flags: */
   WinSetKeyboardStateTable(HWND_DESKTOP, bArray, FALSE);  
   BOOL bAltGraf = (bArray[VK_ALT] & 0x80);
   BOOL bShift = (bArray[VK_SHIFT] & 0x80);
   BOOL bControl = (bArray[VK_CTRL] & 0x80);

   UCHAR chScanCode = CHAR4FROMMP(pqmMsg->mp1); // Get scancode
 
   if ((chScanCode == 0x3e)  && (bControl) && (!(fsKeyFlags & KC_KEYUP))) {
        // Ctrl-F4 to toggle between using/not using Arne Anka:
        DosBeep(1000, 100);
        UseArneAnka = !UseArneAnka;
        return;
   } /* endif */
   if (!UseArneAnka) return;

   // Return if the keyboard message is from a OS/2 or DOS window:
   char szClassName[100];
   WinQueryClassName(pqmMsg->hwnd, 100, (PCH) szClassName);
   szClassName[100] = '\0';
   if (strcmp(szClassName, "Shield") == 0) {
      return; 
   } /* endif */

   if (fsKeyFlags & KC_VIRTUALKEY) return; // Don't handle virtual keys

   if (chScanCode == 86) {
      // Special key for Swedish keyboard - not present on US keyboards:
      UCHAR uch;
      if (bAltGraf) {
         uch = '|';
      } else if (bShift) {
         uch = '>';
      } else {
         uch = '<';
      }
      fsKeyFlags |= KC_CHAR;
      fsKeyFlags &= ~(KC_ALT | KC_SHIFT);
      pqmMsg->mp1 = MPFROM2SHORT(fsKeyFlags,
                              SHORT2FROMMP(pqmMsg->mp1));
      pqmMsg->mp2 = MPFROM2SHORT(uch,
                              SHORT2FROMMP(pqmMsg->mp2));
      return;
   } /* endif */

   if (chScanCode > 0x40) return; // Don't handle numeric keypad etc.

   USHORT fsCharacter = (USHORT) SHORT1FROMMP(pqmMsg->mp2);
   for (int i = 0; i < ARR_SIZE; i++) {
      if (usCharArray[i].bAltGraf) {
         // Check for scancode + Alt key:
         if (!bAltGraf) continue;
         if (usCharArray[i].ucScanCode == chScanCode) {
            fsKeyFlags |= KC_CHAR;
            fsKeyFlags &= ~KC_ALT;
            pqmMsg->mp1 = MPFROM2SHORT(
                              fsKeyFlags,
                              SHORT2FROMMP(pqmMsg->mp1));
            pqmMsg->mp2 = MPFROM2SHORT(usCharArray[i].chTo,
                              SHORT2FROMMP(pqmMsg->mp2));
            return;
         } // if

      } else {
         // Check for US char and transform to foreign char:
         if (bAltGraf) continue;
         if (fsCharacter == usCharArray[i].chFrom) {
            pqmMsg->mp2 = MPFROM2SHORT(usCharArray[i].chTo,
                              SHORT2FROMMP(pqmMsg->mp2));
            return;
         } // if
      }
   } // for
}

BOOL EXPENTRY MLSwitchHook(HAB habAnchor, PQMSG pqmMsg, ULONG fs)
// Hook entry:
{
   switch (pqmMsg->msg) {
      case WM_CHAR:
         CharProc(pqmMsg);
         break;
   } // switch

   return FALSE;
}


BOOL EXPENTRY ArneAInit(HAB hab)
// Init av DLL:
{
   HMODULE hmModule;
   if (DosQueryModuleHandle(DLL_NAME, &hmModule)) {
      return FALSE; // Failed to get handle
   } // if

   // Set system hook:
   WinSetHook(hab,
              NULLHANDLE,
              HK_INPUT,
              (PFN)MLSwitchHook,
              hmModule);

   UseArneAnka = TRUE; // Use Arne Anka by default
   return TRUE;
}
