/* Load other DLLs high (unsupported) */

CALL RxFuncAdd 'Above512','Above512','Above512'
CALL RxFuncAdd 'SysFileDelete','RexxUtil','SysFileDelete'
CALL RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'

/* Delete the distributed, useless file RX512MIB.OBJ of Above512 v0.01d */

SAY
IF Stream('RX512MIB.OBJ','C','QUERY EXISTS')<>'' THEN CALL SysFileDelete 'RX512MIB.OBJ'

/* Compile a list of third-party DLLs, with one space between full DLL file specs  */
/* Please insert new DLL file names in lower-case, to make updates clearly visible */

dlls='HUNSPEL0.DLL ICUDT.DLL ICUIN.DLL ICUUC.DLL LIBVPX4.DLL'

/* Convert the DLL file names sentence to a stem or compound variable */

dlls=Strip(dlls)
dll.0=Words(dlls)
DO i=1 TO dll.0
   dll.i=Strip(Word(dlls,i))
END i

/* Load DLLs high, if the product is not the legacy Mozilla? */

IF dll.0>0 THEN DO
   dircounter=0
   source=''

   /* Support for LIBPATH DLLs requires a REXXUTIL.DLL with SysBootDrive() support (to avoid older methods to try to find CONFIG.SYS) */
   /* The file CONFIG.SYS is used for the LIBPATH (not BEGINLIBPATH), so the LIBPATH in use may be different */

   IF RxFuncQuery('SysBootDrive')=0 THEN DO
     source=SysBootDrive()||'\CONFIG.SYS'
      DO WHILE Lines(source)>0
         line=Strip(LineIn(source))
         IF Left(Translate(line),8)='LIBPATH=' THEN DO
            PARSE VAR line 1 . 9 line
            begin=Strip(Value('BEGINLIBPATH',,'ENVIRONMENT'))
            IF Right(begin,1)<>';' THEN begin=begin||';'
            IF begin<>';' THEN line=begin||line
            DO WHILE line<>''
               dircounter=dircounter+1
               PARSE VAR line dir.dircounter ';' line
               dir.dircounter=Strip(dir.dircounter)
               IF Right(dir.dircounter,1)<>'\' THEN dir.dircounter=dir.dircounter||'\'
            END
         END
      END
      CALL LineOut source
   END
   dir.0=dircounter
   IF source='' THEN DO
      SAY 'Error: no LIBPATH support due to old REXXUTIL.DLL without SysBootDrive() function.'
      SAY
      CALL CharOut '','Press <ENTER>... '
      PULL .
      EXIT
   END

   /* Check the list of DLLs */

   errors=0
   DO i=1 TO dll.0

      /* DLL file in current directory? */
         
      IF Stream(dll.i,'C','QUERY EXISTS')='' THEN DO
            
         /* Otherwise DLL file in LIBPATH directory? */

         retry=''
         IF source<>'' THEN DO            
            DO j=1 TO dir.0
               retry=Stream(dir.j||FileSpec('N',dll.i),'C','QUERY EXISTS')
               IF retry<>'' THEN DO
                  dll.i=dir.j||FileSpec('N',dll.i)
                  j=dir.0
               END
            END j
         END   
         IF retry='' THEN DO
            errors=errors+1
            error.errors=dll.i
         END
      END
   END i

   /* By request, any missing DLL is a fatal error instead of a warning */

   IF errors>0 THEN DO
      SAY 'Error, DLL file(s) not found:'
      SAY
      DO i=1 TO errors
         SAY Translate(error.i)
      END i
      SAY
      CALL CharOut '','Press <ENTER>... '
      PULL .
      EXIT
   END
END

/* Above512.DLL's possible errors */

error.1='no module name specified.'
error.2='no valid options specified.'
error.3='cannot open module.'
error.4='cannot read module.'
error.5='not a LX format 32-bit module.'
error.6='cannot modify module.'
error.7='cannot restore date/time attributes.'

/* Process all DLLs */

DO i=1 TO dll.0
   SAY 'Processing file' FileSpec('N',dll.i)||'...'
   SAY
      
   /* Is the DLL read-only? */
      
   restore=0
   IF SysFileTree(dll.i,'readonly.','F','***+*')=2 THEN DO
      SAY 'Error: not enough available free memory to query a list of files.'
      SAY
      CALL CharOut '','Press <ENTER>... '
      PULL .
      EXIT
   END      

   IF readonly.0=1 THEN DO

      /* If so, then (try to) toggle the setting */

      restore=1
      IF SysFileTree(dll.i,'readonly.','F',,'***-*')=2 THEN DO
         SAY 'Error: not enough available free memory to query a list of files.'
         SAY
         CALL CharOut '','Press <ENTER>... '
         PULL .
         EXIT
      END

      /* Verify new setting */

      IF SysFileTree(dll.i,'readonly.','F','***-*')=2 THEN DO
         SAY 'Error: not enough available free memory to query a list of files.'
         SAY
         CALL CharOut '','Press <ENTER>... '
         PULL .
         EXIT
      END
      IF readonly.0=1 THEN DO
         SAY dll.i 'unmarked as a read-only file.'
         SAY
      END
   END

   /* Call the utility */

   retcode=Above512(dll.i,'-u','-!')
   IF retcode>0 THEN DO
      SAY 'Error:' error.retcode
      SAY
      CALL CharOut '','Press <ENTER>... '
      PULL .
      EXIT
   END
   retcode=Above512(dll.i,'-c')
   IF retcode>0 THEN DO
      SAY 'Error:' error.retcode
      SAY
      CALL CharOut '','Press <ENTER>... '
      PULL .
      EXIT
   END
      
   /* (Try to) restore the read-only setting, if possibly changed */
      
   IF restore=1 THEN DO
      IF SysFileTree(dll.i,'readonly.','F',,'***+*')=2 THEN DO
         SAY 'Error: not enough available free memory to query a list of files.'
         SAY
         CALL CharOut '','Press <ENTER>... '
         PULL .
         EXIT
      END

      /* Verify the restored read-only setting */

      IF SysFileTree(dll.i,'readonly.','F','***+*')=2 THEN DO
         SAY 'Error: not enough available free memory to query a list of files.'
         SAY
         CALL CharOut '','Press <ENTER>... '
         PULL .
         EXIT
      END
      IF readonly.0=1 THEN DO
         SAY
         SAY dll.i 'marked as a read-only file again.'
      END
   END
END i
SAY 'Done.'
SAY
CALL CharOut '','Press <ENTER>... '
PULL .

EXIT
