/*
 *      INSTALL.CMD - Animated Mouse Pointer for OS/2 - C.Langanke 1996 - Installation
 *
 *      execute INSTALL /? to get online help in your language.
 */
/* The first comment is used as online help text */

 SIGNAL ON HALT NAME HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 env       = 'OS2ENVIRONMENT';
 TRUE      = (1 = 1);
 FALSE     = (0 = 1);
 CrLf      = '0d0a'x;
 Redirection = '1>NUL 2>&1';
 '@ECHO OFF'

 /* some OS/2 Error codes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.SHARING_VIOLATION  = 32;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 GlobalVars = 'Title CmdName env TRUE FALSE CrLf Redirection ERROR.';

 /* load RexxUtil */
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;

 /* some defaults */
 Flag.Batch        = FALSE;
 Flag.InstPath     = FALSE;
 Flag.AnimFilePath = FALSE;
 Flag.ResetWps     = FALSE;
 Flag.ResetAllowed = TRUE;   /* only internal use */
 Flag.DoReplace    = TRUE;   /* only internal use */

 Ini.FileName      = 'OS2.INI'
 Ini.Error         = 'ERROR:';
 Ini.All           = 'ALL:';
 Ini.Delete        = 'DELETE:';
 Ini.AppName       = 'WPAMPTR';
 Ini.KeyProgPath   = 'ProgramPath';
 Ini.KeyAnimPath   = 'AnimationFilePath';

 ClassName         = 'WPAnimatedMousePointer';
 ProgramCompId     = '001002AMP';
 InstallResult     = ERROR.NO_ERROR;
 CallDir           = GetCallDir();
 AppDir            = GetDrivePath(CallDir);

 BootDrive         = GetInstDrive();
 PointersDir       = '?:\OS2\POINTERS';
 DefInstPath       = '?:\WPS\WPAMPTR';

 ReplaceExec       = CallDir'\WPSREPLC.PRG';
 ResetExec         = CallDir'\WPSRESET.PRG';
 PointersFile      = CallDir'\POINTERS.ZIP';
 InstallListFile   = CallDir'\INSTALL.LST';
 SyslevelFile      = AppDir'\SL.AMP';
 CopyListFile      = '';

 GlobalVars = GlobalVars 'ExitMessage MessageFile MessageFileVersion ResetExec BootDrive Flag. NlsMsg.';

 /* get NLS settings */
 MessageFileVersion = '1.01';
 MessageFile        = CallDir'\INSTALL.MSG';
 IF (\FileExist(MessageFile)) THEN
 DO
    Language    = GetLanguage(CallDir);
    MessageFile = GetMessageFile(CallDir, Language);
 END;
 ELSE
 DO
    MessageFileInfo =  LoadMsgString(0, MessageFile)
    PARSE VAR MessageFileInfo . Language .
 END;

 SIGNAL ON HALT NAME HALT_NLS

 /* show Title */
 Title = '[2J'GetNlsString('Title', GetNlsString('InstallProg'));

 /* show help */
 ARG Parms
 IF (POS('/?', Parms) > 0) THEN
 DO
    SAY Title;
    SAY GetNlsString('InstHelp1', DefInstPath, PointersDir);
    SAY GetNlsString('InstHelp2');
    SAY GetNlsString('InstHelp3');
    EXIT(ERROR.NO_ERROR)
 END;

 /* read commandline parameters */
 DO i = 1 TO WORDS(Parms)
    ThisParm = TRANSLATE(WORD(Parms, i));
    PARSE VAR ThisParm ThisTag':'ThisValue;

    SELECT
       WHEN (POS(ThisParm, '/BATCH') = 1) THEN
          Flag.Batch = TRUE;

       WHEN (POS(ThisTag, '/INSTALLPATH') = 1) THEN
       DO
          DefInstPath       = CheckBootDrive(ThisValue);
          Flag.InstPath     = TRUE;
       END;

       WHEN (POS(ThisTag, '/ANIMFILEPATH') = 1) THEN
       DO
          PointersDir       = CheckBootDrive(ThisValue);
          Flag.AnimFilePath = TRUE;
       END;

       WHEN (POS(ThisParm, '/RESETWPS') = 1) THEN
          Flag.ResetWps = TRUE;

       /* internal parameter */
       WHEN (POS(ThisParm, '/MESSAGEFILE') = 1) THEN
          EXIT(ERROR.NO_ERROR);

       OTHERWISE
       DO
          SAY GetNlsString('InvalidParm', ThisParm);
          'PAUSE'
          EXIT(ERROR.INVALID_PARAMETER);
       END;
    END;

 END;

 /* install */
 DefInstPath = CheckBootDrive(DefInstPath);
 PointersDir = CheckBootDrive(PointersDir);
 DO UNTIL (TRUE)

    SAY Title;

    /* should we install ? */
    IF (\ProceedWith(GetNlsString('QueryInst'))) THEN
       SIGNAL HALT;

    /* is install.cmd from an installed base ? */
    InstallPath = InstalledPath(CallDir, ClassName, TRUE);
    IF (TRANSLATE(InstallPath) \= TRANSLATE(AppDir)) THEN
    DO
       /* is everything there ? */
       MissingFiles = '';
       IF (\FileExist(ReplaceExec)) THEN
          MissingFiles = MissingFiles FILESPEC('N', ReplaceExec);

       IF (\FileExist(ResetExec)) THEN
          MissingFiles = MissingFiles FILESPEC('N', ResetExec);

       IF (\FileExist(PointersFile)) THEN
          MissingFiles = MissingFiles FILESPEC('N', PointersFile);

       IF (\FileExist(InstallListFile)) THEN
          MissingFiles = MissingFiles FILESPEC('N', InstallListFile);

       IF (MissingFiles \= '') THEN
       DO
          SAY GetNlsString('MissingFiles', MissingFiles, CallDir);
          InstallResult = ERROR.FILE_NOT_FOUND;
          LEAVE;
       END;

       /* is zip available ? */
       ZipExec = SysSearchPath( 'PATH', 'unzip.exe');
       IF (ZipExec = '') THEN
       DO
          SAY GetNlsString('MissingProgs', 'unzip.exe');
          SAY GetNlsString('CannotUnpack1');
          SAY GetNlsString('CannotUnpack2');
          SAY;
          InstallResult = ERROR.FILE_NOT_FOUND;
          LEAVE;
       END;
       ELSE
       DO
          /* should we install  animations ? */
          SAY Title;
          IF (ProceedWith(GetNlsString('QueryUnzip'))) THEN
          DO

             IF (Flag.AnimFilePath) THEN
                PointersPath = PointersDir;
             ELSE
             DO
                PointersPath = SysIni(, Ini.AppName, Ini.KeyAnimPath);
                IF (PointersPath = Ini.Error) THEN
                   PointersPath = PointersDir;
             END;

             PointersPath = PullVariable( PointersPath, GetNlsString('PromptPtrPath'));
             Resources = '';

             /* store animation file path in case that it was modified */
             rc = SysIni(, Ini.AppName, Ini.KeyAnimPath, PointersPath);

             /* check wether drive supports long filenames */
             PointersDrive = FILESPEC('D', PointersPath);
             IF (PointersDrive \= '') THEN
             DO
                LongNamesOk = CheckLongNamesSupported(PointersDrive);
                IF (\LongNamesOk) THEN
                DO
                   SAY Title;
                   SAY GetNlsString('NoPointerSets1');
                   SAY GetNlsString('NoPointerSets2');
                   IF (\ProceedWith(GetNlsString('QueryUnzip2'))) THEN
                      EXIT(1);
                   Resources = '*.and';
                END;
             END;

             SAY;
             rc = MakePath(PointersPath);
             '' ZipExec '-o' PointersFile '-d' '"'PointersPath'"' Resources
             IF (rc > 1) THEN
             DO
                SAY;
                SAY GetNlsString('ErrorUnzip', rc)
                'PAUSE'
             END;
             IF (rc = ERROR.NO_ERROR) THEN
             DO
                IF (PointersPath \= PointersDir) THEN
                DO
                   /* deferred setup of mouse object: set ANIMATIONPATH */
                   /* use something senseful for title, because */
                   /* this is displayed during update */
                   HelpData = GetNlsString('HelpData');
                   PARSE VAR HelpData HelpTitle'|'HelpPanel
                   App = 'PM_InstallObject';
                   Key = HelpTitle';WPProgram;<WP_CONFIG>;UPDATE';
                   Val = 'ANIMATIONPATH='PointersPath';OBJECTID=<WP_MOUSE>;';
                   rc = SysIni(, App, Key, Val);

                   IF (rc = 'ERROR:') THEN
                   DO
                      SAY GetNlsString('ErrorInit');
                     'PAUSE'
                   END;

                   /* do a setup of mouse object in case that the program is installed */
                   rc = SysSetObjectData('<WP_MOUSE>', 'ANIMATIONPATH='PointersPath';');
                END;
             END;
          END;
       END;

       /* install the program */
       SAY Title;
       InstallPath = InstalledPath(CallDir, ClassName, FALSE);
       IsInstalled = (InstallPath \= '');
       InstalledSyslevelFile = InstallPath'\SYSLEVEL.AMP';

       IF (\IsInstalled) THEN
       DO
          /* determine default install path */
          IF (Flag.InstPath) THEN
             InstallPath = DefInstPath;
          ELSE
          DO
             InstallPath = SysIni(, Ini.AppName, Ini.KeyProgPath);
             IF (InstallPath = Ini.Error) THEN
                InstallPath = DefInstPath;
          END;

          /* get install path from user */
          InstalledSyslevelFile = InstallPath'\SYSLEVEL.AMP';
          IF (\FileExist(InstalledSyslevelFile)) THEN
             InstallPath =  PullVariable( InstallPath, GetNlsString('PromptInstPath'));
       END;

       /* check version */
       InstalledSyslevelFile = InstallPath'\SYSLEVEL.AMP';
       IF (FileExist(InstalledSyslevelFile)) THEN
       DO
          InstVersion = ReadSyslevelFile( InstalledSyslevelFile, ProgramCompId, VERSION);
          NewVersion  = ReadSyslevelFile( SyslevelFile,          ProgramCompId, VERSION);

          SELECT
             WHEN (InstVersion = '') THEN NOP;
             WHEN (NewVersion = '')  THEN NOP; /* ### big problem here */
             OTHERWISE
                IF (\ProceedWith(GetNlsString('QueryUpgrade', InstVersion))) THEN
                   SIGNAL HALT;
          END;
       END;

       /* copy the files */
       LanguageTag = TranslateLanguageTag(Language);
       rc = CopyFiles( InstallListFile, AppDir, InstallPath, Language, LanguageTag, IsInstalled);

       /* deffered copy used, so no wps reset ! */
       IF (rc = -1) THEN
       DO
          rc = ERROR.NO_ERROR;
          Flag.ResetAllowed = FALSE;
          IF (IsInstalled) THEN
             Flag.DoReplace = FALSE;
       END;

       IF (rc \= ERROR.NO_ERROR) THEN
       DO
          SAY;
          SAY GetNlsString('CopyError')
          LEAVE;
       END;

       /* save location */
       rc = SysIni(, Ini.AppName, Ini.KeyProgPath, InstallPath);

    END;
    ELSE
       SAY Title;

    /* replace the class, if not already replaced  */
    IF (Flag.DoReplace) THEN
    DO
       rc = ReplaceWpsClass( ReplaceExec, 'WPMouse', ClassName, InstallPath, 'WPAMPTR.DLL', TRUE);
       IF (rc \= ERROR.NO_ERROR) THEN
          LEAVE;
    END;

    /* deferred create information object and shadow */
    HelpData = GetNlsString('HelpData');
    PARSE VAR HelpData HelpTitle'|'HelpPanel

    App = 'PM_InstallObject';
    Key = HelpTitle';WPProgram;<WP_INFO>;REPLACE';
    Val = 'TITLE='HelpTitle';PROGTYPE=PM;EXENAME=VIEW.EXE;PARAMETERS='InstallPath'\WPAMPTR.INF' HelpPanel ';OPEN=DEFAULT;OBJECTID=<WPAMPTR_INFO>;';
    rc = SysIni(, App, Key, Val);

    App = 'PM_InstallObject';
    Key = HelpTitle';WPShadow;<WP_DESKTOP>;REPLACE';
    Val = 'SHADOWID=<WPAMPTR_INFO>;OBJECTID=<WPAMPTR_INFO_SHADOW>;';
    rc = SysIni(, App, Key, Val);


    /* if /RESETWPS not given, let the user decide between wps reset and system reboot */
    SAY Title;
    IF (Flag.ResetAllowed) THEN
    DO
       IF (\Flag.ResetWps) THEN
          choice = Choice( GetNlsString('PromptReset', GetNlsString('InstallProg')), '21');
       ELSE
          choice = 1;
    END
    ELSE
       choice = 2;

    /* perform a WPS reset here */
    IF (choice = 1) THEN
       '' ResetExec '/Y' Redirection

    /* we're done, so leave */
    SAY Title;
    SAY  GetNlsString('InstDone1', InstallPath);
    SELECT
       WHEN (choice = 1) THEN SAY GetNlsString('DoneReset', GetNlsString('InstallProg'));
       WHEN (choice = 2) THEN SAY GetNlsString('InstDoneReboot');
    OTHERWISE
    END;
    SAY  GetNlsString('InstDone2');
    SAY  GetNlsString('InstDone3');

 END;

 /* on error: do not close text windows immeadiately */
 IF (InstallResult \= ERROR.NO_ERROR) THEN
    'PAUSE'

 EXIT(InstallResult);

/* ------------------------------------------------------------------------- */

HALT_NLS:
 SAY;
 SAY GetNlsString('Halt');
 EXIT(ERROR.GEN_FAILURE);

HALT:
 SAY;
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 SAY;
 SAY Title
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help */
 DO WHILE (ThisLine \= ' */')
    ThisLine = LINEIN(Thisfile);
    SAY SUBSTR(ThisLine, 7);
 END;

 /* close file */
 rc = LINEOUT(Thisfile);

 RETURN('');

/* ========================================================================= */
PullVariable: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG Default, Message

 IF (Flag.Batch) THEN RETURN(Default);

 SAY;
 CALL CHAROUT, Message '['Default'] : ';
 PARSE PULL PullVar;
 IF (LENGTH(PullVar) > 0) THEN
    RETURN(PullVar);
 ELSE
    RETURN(Default);

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ------------------------------------------------------------------------- */
LoadMsgString: PROCEDURE  EXPOSE (GlobalVars)
 PARSE ARG MsgId, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9;

 Message = SysGetMessage(MsgId, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9);
 RETURN(LEFT(Message, LENGTH(Message) - 2));

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE  EXPOSE (GlobalVars)
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
GetDrivePath: PROCEDURE  EXPOSE (GlobalVars)
 PARSE ARG FileName

 FullPath = FILESPEC('D', FileName)||FILESPEC('P', FileName);
 IF (FullPath \= '') THEN
    RETURN(LEFT(FullPath, LENGTH(FullPath) - 1));
 ELSE
    RETURN('');

/* ------------------------------------------------------------------------- */
GetInstDrive: PROCEDURE EXPOSE env
 ARG DirName, EnvVarName

 /* Default: OS2 directory -> determines boot drive */
 IF (DirName = '') THEN DirName = '\OS2';

 /* Default: PATH  */
 IF (EnvVarName = '') THEN EnvVarName = 'PATH';

 /* get value */
 PathValue = VALUE(EnvVarName,,env);

 /* search entry */
 DirName = ':'DirName';';
 EntryPos = POS(DirName, PathValue) - 1;
 IF (EntryPos = -1) THEN
    RETURN('');
 InstDrive = SUBSTR(PathValue, EntryPos, 2);
 RETURN(InstDrive);

/* ------------------------------------------------------------------------- */
SZ2STR: PROCEDURE
 PARSE ARG sz

 str = sz;

 zeroPos = POS("00"x, str);
 IF (zeroPos \= 0) THEN
    str = LEFT(str, zeroPos - 1);

 RETURN(str);

/* ------------------------------------------------------------------------- */
CheckLongNamesSupported: PROCEDURE
 PARSE ARG DirName

 /* default values */
 ErrorCode = '';
 IF (RIGHT(DirName, 1) \= '\') THEN
    DirName = DirName'\';
 FileName  = DirName'filewithlongname';

 /* write file with long name */
 rc  = LINEOUT(FileName, 'Delete me ! I was just a test file.');
 rc1 = LINEOUT(FileName);
 IF (\rc) THEN
    rc = SysFileDelete(FileName);

 RETURN(\rc);

/* ------------------------------------------------------------------------- */
ReadSyslevelFile: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG File, ForceCompId, Request

 /* default values */
 result = '';
 Request = TRANSLATE(Request);

 /* valid tags */
 Tag.0      = 8;
 /* ------------------------------ */
 Tag.1      = 'SYSID';
 Tag.1.Exec = 'result = sysid';
 /* ------------------------------ */
 Tag.2      = 'EDITION';
 Tag.2.Exec = 'result = edition';
 /* ------------------------------ */
 Tag.3      = 'VERSION';
 Tag.3.Exec = 'result = version||modify';
 /* ------------------------------ */
 Tag.4      = 'MODIFY';
 Tag.4.Exec = 'result = modify';
 /* ------------------------------ */
 Tag.5      = 'CURRCSD';
 Tag.5.Exec = 'result = currCsd';
 /* ------------------------------ */
 Tag.6      = 'PREVCSD';
 Tag.6.Exec = 'result = prevCsd';
 /* ------------------------------ */
 Tag.7      = 'ID';
 Tag.7.Exec = 'result = compId';
 /* ------------------------------ */
 Tag.8      = 'NAME';
 Tag.8.Exec = 'result = sysname';

 /* read header */
 header        = C2D(CHARIN(File,,2));
 sig           =     CHARIN(File,,8);
 DateJulian    = C2D(CHARIN(File,,5));
 Version       = C2D(CHARIN(File,,2));
 reserved      =     CHARIN(File,,16);
 offset        = C2D(REVERSE(CHARIN(File,,4))) + 1;

 /* is signature valid */
 IF (sig \= 'SYSLEVEL') THEN
    RETURN('');

 /* read table */
 sysid          = C2D(REVERSE(CHARIN(File,offset, 2)));
 edition        = C2D(CHARIN(File,,1));
 version        = D2X(C2D(CHARIN(File,,1)));
 modify         = C2D(CHARIN(File,,1));
 DateValue      = CHARIN(File,,2);

 currCsd        = CHARIN(File,,8);
 prevCsd        = CHARIN(File,,8);
 sysName        = CHARIN(File,,80);
 compId         = CHARIN(File,,9); /* ignore the rest */

 /* check comp id, if given */
 IF (ForceCompId \= '') THEN
    IF (ForceCompId  \= compId) THEN
       RETURN('');

 /* transform version */
 version = LEFT(version,1)'.'SUBSTR(version,2)

 /* get result */
 IF (Request \= '') THEN
 DO i = 1 TO Tag.0
    IF (POS(Request, Tag.i) = 1) THEN
    DO
       INTERPRET(Tag.i.Exec);
    END;
 END;

 IF (Result = '') THEN
    result = sysid edition version modify currCsd prevCsd compId sysname;

 /* close file */
 rc = STREAM(File, 'C', 'CLOSE');

 RETURN(result);

/* ------------------------------------------------------------------------- */
SetSyslevelInfo: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG File, NewId, NewTitle

 /* read header */
 header        = C2D(CHARIN(File,,2));
 sig           =     CHARIN(File,,8);
 DateJulian    = C2D(CHARIN(File,,5));
 Version       = C2D(CHARIN(File,,2));
 reserved      =     CHARIN(File,,16);
 offset        = C2D(REVERSE(CHARIN(File,,4))) + 1;

 /* is signature valid */
 IF (sig \= 'SYSLEVEL') THEN
    RETURN('');

 /* determine data offsets */
 sysidOffs      = offset;
 editionOffs    = offset + 2;
 versionOffs    = offset + 3;
 modifyOffs     = offset + 4;
 DateValueOffs  = offset + 5;

 currCsdOffs    = offset +  7;
 prevCsdOffs    = offset + 15;
 sysNameOffs    = offset + 23;
 compIdOffs     = offset + 103;

 /* read in CSD level tags */
 CurrLevel = CHARIN(File, currCsdOffs, 8);
 PrevLevel = CHARIN(File, prevCsdOffs, 8);

 Id1 = SUBSTR(CurrLevel, 1, 3);
 Id2 = SUBSTR(PrevLevel, 1, 3);
 CurrId = RIGHT(Id1, 1);
 NewTitle = STRIP(SUBSTR(NewTitle, 1, 79));  /* cut to max 79 chars */
 NewTitle = NewTitle'00'x;

 IF ((Id1 \= Id2) | (POS(CurrId, '0CDFGHIJLNPSUW') = 0)) THEN
    RETURN('');
 ELSE
 DO
    /* patch in new id and cose file */
    rc = CHAROUT(File, NewId, currCsdOffs + 2);
    rc = CHAROUT(File, NewId, prevCsdOffs + 2);
    rc = CHAROUT(File, NewTitle, sysNameOffs);
    rc = LINEOUT(File);
 END;
 RETURN('');

/* ------------------------------------------------------------------------- */
MakePath: PROCEDURE
 PARSE ARG PathName

 IF (PathName = '') THEN
    RETURN('');

 PathElements = TRANSLATE(PathName, ' ', '\');
 Start = LEFT(PathName, 2);

 SELECT

    /* is it an UNC name ? */
    WHEN (Start = '\\') THEN
    DO
       /* abort, if only server and alias given */
       IF (WORDS(PathElements) < 3) THEN
          RETURN('');

       /* use servername and alias as base    */
       /* and delete it from the element list */
       BaseEnd      = WORDINDEX(PathElements, 3);
       PathBase     = LEFT(PathName, BaseEnd - 2);
       PathElements = SUBSTR(PathElements, BaseEnd);
    END;

    /* is it an absolute path without drive ? */
    WHEN (LEFT(Start, 1) = '\') THEN
    DO
       /* avort, if only backslash given */
       IF (WORDS(PathElements) = 0) THEN
          RETURN('');

       /* use backslash as base */
       PathBase = '\';
    END;

    /* is it a path with drive ? */
    WHEN (POS(':', PathName) > 0) THEN
    DO
       /* only drive given ? */
       IF (WORDS(PathElements) = 1) THEN
          RETURN('');

       /* use drive as base and delete */
       /* it from the element list */
       PathBase     = Start;
       PathElements = SUBSTR(PathElements, 3);
    END;

    OTHERWISE
       PathBase     = '';

 END; /* select */

 /* now create path */
 DO i = 1 TO WORDS(PathElements)
    ThisElement = WORD(PathElements, i);
    SELECT
       WHEN (PathBase = '')  THEN PathBase = ThisElement;
       WHEN (PathBase = '\') THEN PathBase = '\'ThisElement;
       OTHERWISE                  PathBase = PathBase'\'ThisElement;
    END;
    'MD' PathBase '1>NUL 2>&1'
    Result = rc;
 END;

 /* report errors only when last MD did not work */
 IF (Result = 0) THEN
    RETURN(PathName);
 ELSE
    RETURN('');

/* --- Replacement - Procedure --------------------------------------------- */
FILESPEC: PROCEDURE
 PARSE ARG Part, FullName

 IF (Part = '') THEN RETURN('');
 Value = '';
 Part  = TRANSLATE(LEFT(Part, 1));

 SELECT

    WHEN (POS(Part, 'DPN' ) > 0) THEN
       Value = "FILESPEC"(Part, FullName);

    WHEN (POS(Part, 'BE' ) > 0) THEN
    DO
       FileName  = "FILESPEC"('N', FullName);
       BaseName  = FileName;
       Extension = '';
       ExtPos = LASTPOS('.', FileName);
       IF (ExtPos > 0) THEN
       DO
          BaseName  = LEFT(FileName, ExtPos - 1);
          Extension = SUBSTR(FileName, ExtPos + 1);
       END;
       SELECT
          WHEN (Part = 'B') THEN Value = BaseName;
          WHEN (Part = 'E') THEN Value = Extension;
          OTHERWISE;
       END;

    END;

    OTHERWISE;

 END;

 RETURN(Value);

/* ========================================================================= */
FileLocked: PROCEDURE EXPOSE (GlobalVars)
 ARG File

 /* does file exist ? */
 fResult = (STREAM(File, 'C', 'QUERY EXISTS') \= '');
 IF (\fResult) THEN
    RETURN(fResult);

 /* clear readonly, hidden and system attribute */
 rc = SysFileTree(File, 'Filelist.', 'F', '*****', '**---');

 /* is the file writeable ? */
 fResult = (STREAM(File, 'C', 'OPEN WRITE') \= 'READY:');
 IF (\fResult) THEN
    rc = STREAM(File, 'C', 'CLOSE');

 RETURN (fResult);

/* ========================================================================= */
CheckBootDrive: PROCEDURE EXPOSE BootDrive
 PARSE ARG Name

 IF (LEFT(Name, 2) = '?:') THEN
    Name = BootDrive''DELSTR(Name, 1, 2);

 RETURN(Name);

/* ========================================================================= */
ProceedWith: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG Prompt, Keys

 IF (Flag.Batch) THEN RETURN(1);

 ch            = ' ';
 IF (Keys = '') THEN
    ValidResponse = LEFT(GetNlsString(YesNoKeys), 2);
 ELSE
    ValidResponse = Keys;

 YesKey        = LEFT(ValidResponse, 1);
 NoKey         = RIGHT(ValidResponse, 1);

 SAY;
 CALL CHAROUT ,Prompt '('YesKey'/'NoKey') '
 DO WHILE (POS(ch, ValidResponse) = 0)
    ch = SysGetKey('NOECHO');
    ch = TRANSLATE(ch);
    IF (POS(ch, ValidResponse) = 0) THEN BEEP(800, 200);
 END;
 SAY ch;
 SAY;
 RETURN(ch = YesKey);

/* ========================================================================= */
Choice: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG Prompt, Keys

 ch   = ' ';
 Keys = TRANSLATE(Keys);

 IF (Flag.Batch) THEN RETURN(LEFT(Keys, 1));
 IF (Keys = '')  THEN RETURN('');

 SAY;
 CALL CHAROUT ,Prompt '';
 KeyPos = 0;
 DO WHILE (KeyPos = 0)
    ch = SysGetKey('NOECHO');
    ch = TRANSLATE(ch);
    KeyPos = POS(ch, Keys);

    IF (KeyPos = 0) THEN BEEP(800, 200);
 END;
 SAY ch;
 SAY;
 RETURN(ch);

/* ========================================================================= */
GetNlsString: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG MessageId, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9;

 /* default values */
 Message     = '*** Message' Id 'not found. ***';

 /* default values */
 MessageFileIdText = 'WPAMPTR_MESSAGEFILE';
 IF (MessageFileVersion \= '') THEN
    MessageFileIdText = MessageFileIdText'_'MessageFileVersion;

 /* load MessageIds and YesNo Keys*/
 MessageFileInfo        = LoadMsgString(0, MessageFile)
 PARSE VAR MessageFileInfo MessageFileId MessageLanguage MessageFileKeys MessageListcount
 IF ((MessageFileIdText \= MessageFileId) | (LENGTH(MessageFileKeys) \= 2))THEN
 DO
    SAY 'Invalid message file' MessageFile;
    EXIT(ERROR.INVALID_DATA);
 END;

 /* load Messagelist*/
 MessageList = '';
 DO i = 1 TO MessageListcount
    MessageList = MessageList LoadMsgString(i, MessageFile)
 END;

 /* handle special id YesNoKeys */
 IF (MessageId = 'YESNOKEYS') THEN
    RETURN(MessageFileKeys);

 /* read message ids */
 MessagePos   = WORDPOS(TRANSLATE(MessageId), TRANSLATE(MessageList));
 IF (MessagePos > 0) THEN
 DO
    ThisMessage = LoadMsgString(MessagePos + MessageListcount, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9);
    IF (ThisMessage \= '') THEN
       Message = ThisMessage;
 END;

 RETURN(Message);

/* ========================================================================= */
CopyFiles: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG ListFile, SourceDir, TargetDir, Language, LanguageTag, IsInstalled

 ClearLine  = '[A[K';
 CopyResult  = ERROR.NO_ERROR;
 CopyMessage = ClearLine''GetNlsString('PromptCopying');

 /* check parms */
 IF (Language = '') THEN
    RETURN(ERROR.INVALID_PARAMETER);

 /* adjust some names */
 IF (RIGHT(SourceDir, 1) \= '\') THEN
    SourceDir = SourceDir'\';
 TargetDirOrg = TargetDir;
 DefCopyExec  = 'dfcopy.cmd';

 /* determine subdirectories needed */
 Drop(SubDir.)
 SubDir.  = '';
 SubDir.0 = 0;

 DO WHILE (LINES(ListFile) > 0)

    ThisLine = LINEIN(ListFile);

    /* empty line finished this list */
    IF (ThisLine = '') THEN LEAVE;

    /* save this subdir name */
    i        = SubDir.0 + 1;
    SubDir.i = ThisLine;
    SubDir.0 = i;
 END;

 /* determine files to copy */
 DROP(File.);
 File.         = '';
 File.0        = 0;

 DO WHILE (LINES(ListFile) > 0)

    ThisLine = LINEIN(ListFile);

    /* patch in the language tag */
    TagPos = POS('???', ThisLine);
    IF (TagPos > 0) THEN
       ThisLine = OVERLAY( Language, ThisLine, TagPos);

    /* determine source and target name */
    PARSE VAR ThisLine CopySource CopyTarget
    IF (CopyTarget = '') THEN
       CopyTarget = FILESPEC('P', CopySource)''FILESPEC('N', CopySource);
    ELSE
       CopyTarget = FILESPEC('P', CopySource)''CopyTarget;

    /* save copy operation data */
    i                   = File.0 + 1;
    File.i.SourceFile   = CopySource
    File.i.TargetFile   = CopyTarget
    File.0              = i;
 END;

 /* close listfile */
 rc = STREAM(ListFile, 'C', 'CLOSE');


Handle_Locked_Files:
/* =============== */

 /* initialize some more variables */
 FilesLocked   = 0;
 LockedList    = '';
 AnyLockedList = '';
 MsgFileLocked = FALSE;
 AnyFileLocked = FALSE; /* excluding DLLs and HLP files ! */

 SAY Title;
 SAY;
 SAY;

 /* check target files */
 DO i = 1 TO File.0

    /* is the file locked ? */
    File.i.FileIsLocked = FileLocked( TargetDir'\'File.i.TargetFile);

    /* count locked files */
    IF (File.i.FileIsLocked) THEN
    DO
       FilesLocked = FilesLocked + 1;
       LockedList  = LockedList''CrLf''File.i.TargetFile;
       FileType    = TRANSLATE(FILESPEC('E', File.i.TargetFile));
       SELECT
          WHEN (FileType = 'MSG') THEN MsgFileLocked = TRUE;
          WHEN (FileType = 'DLL') THEN NOP;
          WHEN (FileType = 'HLP') THEN NOP                    /* treated like DLLs */
          OTHERWISE
          DO
             AnyFileLocked = TRUE;
             AnyLockedList = STRIP(AnyLockedList File.i.TargetFile);
          END;
       END;
    END;
 END;

 /* check type of locked files */
 IF (FilesLocked > 0) THEN
 DO

    /* let user decide */
    /* assemble the prompt */
    ActionMsg = '';
    IF ((MsgFileLocked) | (AnyFileLocked)) THEN
    DO
       Actions = '';
       IF (MsgFileLocked) THEN Actions = Actions''CrLf''GetNlsString('ActionMsgFiles');
       IF (AnyFileLocked) THEN Actions = Actions''CrLf''GetNlsString('ActionAnyFiles', AnyLockedList);
       ActionMsg = GetNlsString('ActionLockedFiles')''Actions
    END;
    IF (IsInstalled) THEN
       HandleChoice = GetNlsString( 'HandleDeinst');
    ELSE
       HandleChoice = GetNlsString( 'HandleManually');
    HandlePrompt = GetNlsString('PromptLockedFiles', LockedList, HandleChoice)''CrLf''ActionMsg''CrLf

    /* display the prompt */
    SAY Title;
    choice = Choice( HandlePrompt, '12');

    /* do a deferred copy or deinstall first */
    SELECT
       /* do nothing here and go on with deferred copy */
       WHEN (Choice = 1) THEN NOP;

       /* do a deinstall first */
       WHEN (Choice = 2) THEN
       DO
          SELECT
             WHEN (IsInstalled) THEN
             DO
                /* run deinstallation first, don't use reboot option, */
                /* because it might not be needed */
                'CALL' SourceDir'INSTALL\REMOVE /B' Redirection

                /* if DLL is not freed, it was already used */
                /* then reset WPS */
                IF (FileLocked( TargetDir'\wpamptr.dll')) THEN
                   'CALL' ResetExec;

                /* jump back to locked files handling */
                SIGNAL Handle_Locked_Files;

             END;

             OTHERWISE SIGNAL HALT_NLS;
          END;
       END;

       OTHERWISE;
    END;
 END;

 /* create directories for copy */
 DO i = 1 TO SubDir.0
    rc = MakePath(TargetDir'\'SubDir.i);
 END;

 IF (FilesLocked > 0) THEN
 DO
    /* select different target dir for deferred copy */
    TargetDir = TargetDir'\tmp';

    /* create directories again in the tmp tree */
    DO i = 1 TO SubDir.0
       rc = MakePath(TargetDir'\'SubDir.i);
    END;
 END;

 /* write copy program for deferred copy */
 IF (FilesLocked > 0) THEN
 DO

    /* delete if exists */
    DefCopyExec = TargetDirOrg'\'DefCopyExec;
    rc = SysFileDelete(DefCopyExec);

    /* let listfile generate some oputput */
    HelpData = GetNlsString('HelpData');
    PARSE VAR HelpData HelpTitle'|'HelpPanel
    rc = LINEOUT(DefCopyExec, '@ECHO OFF');
    rc = LINEOUT(DefCopyExec, 'ECHO.');
    rc = LINEOUT(DefCopyExec, 'ECHO' HelpTitle '-' GetNlsString('InstallProg'));
    rc = LINEOUT(DefCopyExec, 'ECHO.');

    /* modify config.sys ! */
    ConfigFile    = BootDrive'\CONFIG.SYS';
    ConfigFileNew = BootDrive'\CONFIG.TMP';
    ConfigFileBak = BootDrive'\CONFIG.AMP';

    rc = LINEOUT(DefCopyExec, 'IF EXIST' ConfigFileNew 'ATTRIB -r -s -h' ConfigFileNew);
    rc = LINEOUT(DefCopyExec, 'IF EXIST' ConfigFileNew 'DEL' ConfigFileNew);
    rc = LINEOUT(DefCopyExec, 'IF EXIST' ConfigFileBak 'ATTRIB -r -s -h' ConfigFileBak);
    rc = LINEOUT(DefCopyExec, 'IF EXIST' ConfigFileBak 'DEL' ConfigFileBak);
    rc = LINEOUT(DefCopyExec, 'TYPE' ConfigFile '| FIND /v "/DEFERREDCOPY" >' ConfigFileNew);
    rc = LINEOUT(DefCopyExec, 'REN' ConfigFile    FILESPEC('N', ConfigFileBak));
    rc = LINEOUT(DefCopyExec, 'REN' ConfigFileNew FILESPEC('N', ConfigFile));

    rc = LINEOUT(DefCopyExec, 'ECHO.');

    /* commands for deferred copy and deletion of tmp files */
    DO i = 1 TO File.0
       rc = LINEOUT(DefCopyExec, 'COPY' TargetDir'\'File.i.TargetFile TargetDirOrg'\'File.i.TargetFile '>NUL');
       rc = LINEOUT(DefCopyExec, 'DEL ' TargetDir'\'File.i.TargetFile);
    END;
    /* commands for deletion of tmp subdirs */
    DO i = 1 TO SubDir.0
       rc = LINEOUT(DefCopyExec, 'RMDIR' TargetDir'\'SubDir.i);
    END;
    /* commands for deletion of tmp dir */
    rc = LINEOUT(DefCopyExec, 'RMDIR' TargetDir);

    /* commands for deletion of batch file */
    rc = LINEOUT(DefCopyExec, 'DETACH 'BootDrive'\OS2\CMD.EXE /C DEL' DefCopyExec '2>NUL');

    /* done */
    rc = LINEOUT(DefCopyExec);

    /* change CONFIG.SYS, so that deferred copy takes place */
    ConfigFile = BootDrive'\CONFIG.SYS';
    'ATTRIB -r -s -h' ConfigFile;
    rc = LINEOUT(ConfigFile, 'CALL='BootDrive'\OS2\CMD.EXE /C' DefCopyExec '/DEFERREDCOPY');
    rc = LINEOUT(ConfigFile);
 END;

 /* do the copy */
 DO i = 1 TO File.0
    SAY CopyMessage TRANSLATE(File.i.SourceFile) '... '
    CopySource = SourceDir'\'File.i.SourceFile;
    CopyTarget = TargetDir'\'File.i.TargetFile;

    /* enclose target in double quotes in order */
    /* to support blanks in target dir name */
    'COPY' CopySource '"'CopyTarget'"' '> NUL'

    IF (rc \= ERROR.NO_ERROR) THEN
    DO
       CopyResult = rc;
       LEAVE;
    END;

    /* copy at least the dlls to the directory */
    /* so that registration works anyway       */
    IF (FilesLocked > 0) THEN
    DO
       Filetype = TRANSLATE(FILESPEC('E', File.i.TargetFile));
       IF ((\File.i.FileIsLocked) & (Filetype = 'DLL')) THEN
       DO
          CopyTarget = TargetDirOrg'\'File.i.TargetFile;
          'COPY' CopySource '"'CopyTarget'"' '> NUL'
       END;

    END;

 END;

 IF (CopyResult = ERROR.NO_ERROR) THEN
 DO
    CALL CHAROUT, ClearLine;
    SAY GetNlsString('FilesCopied');
    SAY;
 END;

 /* convert HLP to INF file */
 rc = ConvertHlp2Inf( TargetDir'\wpamptr.inf');

 /* patch the language id into our syslevel file */
 HelpData = GetNlsString('HelpData');
 PARSE VAR HelpData HelpTitle'|'HelpPanel
 rc = SetSyslevelInfo( TargetDir'\syslevel.amp', LanguageTag, HelpTitle);

 /* special return code in case of locked files */
 /* shutdown needed here ! */
 IF (CopyResult = ERROR.NO_ERROR) THEN
 DO
    IF (Fileslocked > 0) THEN
    DO
       CopyResult = -1;
    END;
 END;

 RETURN(CopyResult);

/* ========================================================================= */
ConvertHlp2Inf: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG InfFile

 /* default values */
 InfId  = 'HSP'||"01"x;

 /* convert target */
 rc = CHAROUT(InfFile, InfId, 1);
 rc = LINEOUT(InfFile);

 RETURN(ERROR.NO_ERROR);

/* ========================================================================= */
ReplaceWpsClass: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG ReplaceExec, ClassName, ReplaceClassName, InstallPath, ClassDll, fReplace

 ReplaceResult    = ERROR.NO_ERROR;

 SELECT
    WHEN (\fReplace) THEN
    DO
       ReplaceFlag      = 'U';
       SAY GetNlsString('Unreplacing', ReplaceClassName);
       ClassDllFullname = '';
    END;
    WHEN (fReplace) THEN
    DO
       ReplaceFlag      = 'R';
       SAY GetNlsString('Replacing', ReplaceClassName);
       ClassDllFullname = '"'InstallPath'\'ClassDll'"';
    END;
 END;

 /* (un-)replacing */
 '' ReplaceExec ClassName ReplaceClassName ReplaceFlag ClassDllFullName Redirection
 ReplaceResult = rc;
 SAY;

 IF (ReplaceResult \= ERROR.NO_ERROR) THEN
 SELECT
    WHEN (\fReplace) THEN
     SAY GetNlsString('UnreplaceError', ReplaceClassName, ReplaceResult);

    WHEN (fReplace) THEN
       SAY GetNlsString('ReplaceError', ReplaceClassName, ReplaceResult);
 END;
 ELSE
    rc = SysSleep(1);

 RETURN(ReplaceResult);

/* ========================================================================= */
GetMessageFile: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG InstallDir, Language

 /* filenames */
 YourNlsFile = InstallDir'\instl'Language'.msg';
 MainNlsFile = InstallDir'\install.msg';

 /* if main nls file already exists, use this one */
 IF (FileExist(MainNlsFile)) THEN
    RETURN(MainNlsFile);

 /* if nls file does not exist, give error */
 IF (\FileExist(YourNlsFile)) THEN
 DO
    SAY CmdName': error:'
    SAY 'message file 'YourNlsFile' not found.';
    SAY 'Program aborted.';
    EXIT(ERROR.FILE_NOT_FOUND);
 END;

 /* try to copy appropriate message file */
 'COPY' YourNlsFile MainNlsFile Redirection;
 IF (rc = ERROR.NO_ERROR) THEN
    RETURN(MainNlsFile);
 ELSE
    RETURN(YourNlsFile);

/* ========================================================================= */
GetLanguage: PROCEDURE EXPOSE (GlobalVars)
 ARG InstallDir

 /* get language code */
 BootDrive    = GetInstDrive();
 SyslevelFile = BootDrive'\OS2\INSTALL\SYSLEVEL.OS2';
 CurrCsd      = ReadSyslevelFile(SyslevelFile,, 'CURRCSD');

 DefaultLanguageAbbr = 'eng';
 DefaultLanguageTag  = '0';

 /* for test purposes only */
 TestCsd = VALUE('TESTCSD',,env);
 IF (TestCsd \= '') THEN
 DO
    SAY 'Test Csd:' TestCsd;
    CurrCsd = TestCsd;
 END;

 /* determine language */
 IF (CurrCsd = '') THEN
    LanguageTag = '?';   /* ask for default value */
 ELSE
    LanguageTag  = SUBSTR(CurrCsd, 3, 1);

 OsLanguage = TranslateLanguageTag(LanguageTag);
 /* test if the message file for the language is there */
 NlsFile = InstallDir'\instl'OsLanguage'.msg';
 IF (\FileExist(NlsFile)) THEN
 DO
    SAY;
    SAY 'This program currently does not support the language of your installed OS/2';
    SAY 'or the files supporting this language are not present.';
    SAY;
    SAY 'If you want to go on with installation, the program will be installed';
    SAY 'in the english version. Be aware of the fact that this program replaces';
    SAY 'parts of the Workplace Shell (the "Pointers" page of the mouse object)';
    SAY 'which are currently supporting the language of your version of OS/2.';
    SAY 'With this program installed this will not longer be the case.';
    SAY;
    SAY 'If you want to go on to install this program in the english version, press Y.';
    SAY 'If you want to abort this program, press N.';
    IF (\ProceedWith('Do you want to install this program in the english version', 'YN')) THEN
    DO
       SAY 'Installation program aborted.';
       EXIT(0);
    END;
    ELSE
       OsLanguage = DefaultLanguageAbbr;
 END;

 RETURN(OsLanguage);

/* ========================================================================= */
InstalledPath: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG CallDir, ClassName, fCheckFileBase

 InstalledPath     = '';

 DO UNTIL (TRUE)

    IF (fCheckFileBase) THEN
    DO
       /* check file base */
       NlsDLL        = STREAM(CallDir'\..\WPAMPTRS.DLL', 'C', 'QUERY EXISTS');
       InstalledPath = GetDrivePath(NlsDLL);

       /* has file base nls files ? */
       rc = SysFileTree(CallDir'\instl*.msg', 'file.', 'FO');
       IF (rc = 0) THEN
       DO
          IF (File.0 > 0) THEN
             InstalledPath = '';
       END;

    END;

    /* check class list */
    CALL SysQueryClassList "list."

    IF (DATATYPE(list.0) \= 'NUM') THEN
    DO
       SAY CmdName': internal REXX error.';
       SAY 'Close this text session and run' CmdName 'again.';
       EXIT(ERROR.INVALID_FUNCTION);
    END;

    DO i = 1 to list.0
       PARSE VAR list.i ThisClass ThisDll
       IF (STRIP(Thisclass) = ClassName) THEN
       DO
          ClassInstalled = TRUE;
          InstalledPath = GetDrivePath(STRIP(ThisDll));
          LEAVE;
       END;
    END

 END;

 RETURN(InstalledPath);

/* ========================================================================= */
TranslateLanguageTag: PROCEDURE
 ARG SearchString

 /* special values in LanguageTag:                       */
 /* '#'    : don't know the correct value yet            */
 /* special values in LanguageZMsg:                      */
 /* '*'    : language tag is unique, no zero msg needed  */
 /* '?????': don't know the correct value yet            */
 LanguageTag   = '0     U   G       D       F      H           H           S     I     W      N      F       J     P        B      C      T       O      0      0        #      #     #';
 LanguageAbbr  = 'ENG   ENG DEU     DAN     FRA    NDL         KOR         ESP   ITA   SVE    NOR    FIN     JPN   PTG      PTB    FRC    TWN     POL    POL    HUN      HEB    ARA   CHT';
 LanguageZMsg  = 'YNARI *   *       *       *      JNAHN       ?????       *     *     *      *      *       *     *        *      *      *       *      TNAPI  xxxxx    *      *     *';
               /* us    uk  germany denmark france netherlands netherlands spain italy sweden norway finland japan protugal brazil canada taiwan  poland poland hungaria israel arab. china */
               /*                                                                                                                                 WARP4  WARP3                              */

 /* determine which list to search */
 SELECT
    WHEN (LENGTH(SearchString) = 1) THEN SearchPos = WORDPOS(SearchString, TRANSLATE(LanguageTag));
    WHEN (LENGTH(SearchString) = 3) THEN SearchPos = WORDPOS(SearchString, TRANSLATE(LanguageAbbr));
    OTHERWISE NOP;
 END;

 IF (SearchPos = 0) THEN
    /* use non existing language code,if language not known */
    RETURN('#');

 /* make second check for languages, that have not a unique language tag */
 IF (WORD(LanguageZMsg, SearchPos) \= '*') THEN
 DO
    /* read the zero message of the system and remove spaces*/
    ZeroMsg = LEFT(SPACE(SysGetMessage(0), 0), 5);

    /* check the language again */
    SearchPos = WORDPOS(ZeroMsg, LanguageZMsg);

    IF (SearchPos = 0) THEN
       /* use non existing language code,if language not known */
       RETURN('#');
 END;

 /* now determine result */
 SELECT
    WHEN (LENGTH(SearchString) = 1) THEN SearchResult = WORD(LanguageAbbr, SearchPos);
    WHEN (LENGTH(SearchString) = 3) THEN SearchResult = WORD(LanguageTag,  SearchPos);
    OTHERWISE;
 END;

 RETURN(SearchResult);

