
/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dmatrixm.c
**     SYSTEM   NAME:       matrix
**     ORIGINAL AUTHOR(S):  Nitin Ramlal
**     VERSION  NUMBER:     0.99
**     CREATION DATE:       1992/9/25
**
** DESCRIPTION: matrix group of the RMON MIB
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/


#include <dnpap.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <message.h>
#include <mibsup.h>
#include <mac.h>

#include "dmatrixd.h"
#include "dmatrixe.h"
#include "dmatrixc.h"
#include "dmatrix.h"


#define CONTROLINDEXSIZE   1
#define SRCDSTINDEXSIZE   13


static MIB_LOCAL    *MatrixControlInstance = NULL;


static BOOLEAN RmonNext(SNMP_OBJECT *obj, MIB_LOCAL **local, WORD idlen, WORD indexsize, HostInfo **elem, BOOLEAN SDorder);
static HostInfo *SrcDstGetFirstNext(MATRIX_CONTROL *matrixcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first);
static HostInfo *DstSrcGetFirstNext(MATRIX_CONTROL *matrixcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first);



BOOLEAN MatrixMInit(VOID)
{
    MessageConfig(MATRIX_ERROR, "Matrix");
    return MatrixConfigInit();
}



/* if SDorder = TRUE, then a pointer to the SOURCE structure, if
** SDorder = FALSE, then a pointer to the DEST structure *
obj = requested object
local = local datastructure : a collector
idlen = identifier length knwon to the MIB*/



BOOLEAN RmonNext(SNMP_OBJECT *obj, MIB_LOCAL **local, WORD idlen, WORD indexsize, S **base, HostInfo **elem, BOOLEAN SDorder)
{
BOOLEAN first = FALSE;

    if (*local == NULL || indexsize < 1)
        return FALSE;

    if (obj->IdLen < idlen + indexsize)
    {
        switch (indexsize)
        {
        case SRCDSTINDEXSIZE:
            while (*local != NULL && (*elem = SrcDstGetFirstNext((MATRIX_CONTROL*)(*local)->Data, obj, idlen, base, first,SDorder)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + SRCDSTINDEXSIZE;
            break;
        case CONTROLINDEXSIZE:
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + CONTROLINDEXSIZE;
            break;
        }
        return TRUE;
    }
    else
    {
        switch (indexsize)
        {            
        case SRCDSTINDEXSIZE:
            while (*local != NULL && (*elem = SrcDstGetFirstNext((MATRIX_CONTROL*)(*local)->Data, obj, idlen, first,SDorder)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + SRCDSTINDEXSIZE;
            break;
        case CONTROLINDEXSIZE:
            *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + CONTROLINDEXSIZE;
            break;
        }
        return TRUE;
    }
    return FALSE;
}







WORD DnpapMatrixControlIndex(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixControlDataSource(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;
MATRIX_CONTROL *data;
MAC_IFACE    *iface;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {           
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE,NULL, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (MATRIX_CONTROL*) local->Data;
        memcpy(obj->Syntax.BufInt, data->Source, data->SourceLen*sizeof(data->Source[0]));
        obj->SyntaxLen = data->SourceLen;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (MATRIX_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (data->SourceLen != obj->SyntaxLen ||
            memcmp(data->Source, obj->Syntax.BufInt, (data->SourceLen-1)*sizeof(data->Source[0])) != 0)
            return SNMP_BADVALUE;
        if ((iface = MacIfaceGet((WORD) obj->Syntax.BufInt[obj->SyntaxLen-1])) == NULL)
            return SNMP_BADVALUE;
        memcpy(data->Source, obj->Syntax.BufInt, obj->SyntaxLen*sizeof(data->Source[0]));
        data->SourceLen = obj->SyntaxLen;
        data->Iface = iface;
        return SNMP_NOERROR;
    }
}


WORD DnpapMatrixControlTableSize(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;
MATRIX_CONTROL *data;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (MATRIX_CONTROL*) local->Data;
        obj->Syntax.LngInt = data->TableSize;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixControlLastDelTime(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;
MATRIX_CONTROL *data;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (MATRIX_CONTROL*) local->Data;
        obj->Syntax.LngUns = data->LastDeleteTime;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixControlOwner(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;
MATRIX_CONTROL *data;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (MATRIX_CONTROL*) local->Data;
        memcpy (obj->Syntax.BufChr, data->Owner, data->OwnerLen);
        obj->SyntaxLen = data->OwnerLen;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (MATRIX_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        memcpy (data->Owner, obj->Syntax.BufChr, obj->SyntaxLen);
        data->OwnerLen = obj->SyntaxLen;
        return SNMP_NOERROR;
    }
}


WORD DnpapMatrixControlStatus(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL    *local = NULL;
MATRIX_CONTROL *data;

    local = MibRmon(obj, MatrixControlInstance, idlen, CONTROLINDEXSIZE);

    switch (obj->Request)
    {
    case SNMP_PDU_GET:
        if (local == NULL)
        {
            obj->Syntax.LngInt = SNMP_INVALID;
            return SNMP_NOSUCHNAME;
        }
        data = (MATRIX_CONTROL*) local->Data;
        obj->Syntax.LngInt = data->Status;
        return SNMP_NOERROR;
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, CONTROLINDEXSIZE, NULL, FALSE) == FALSE)
        {
            obj->Syntax.LngInt = SNMP_INVALID;
            return SNMP_NOSUCHNAME;
        }
        data = (MATRIX_CONTROL*) local->Data;
        obj->Syntax.LngInt = data->Status;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        if (local == NULL)
        {
            switch (obj->Syntax.LngInt)
            {
            case SNMP_CREATEREQUEST:
                if ((local = MibInsert(obj, &MatrixControlInstance, idlen, CONTROLINDEXSIZE)) == NULL)
                    return SNMP_GENERROR;
                if ((local->Data = DnpapMalloc(sizeof(MATRIX_CONTROL))) == NULL)
                    return SNMP_GENERROR;
                data = (MATRIX_CONTROL*) local->Data;
                memset(data, 0, sizeof(MATRIX_CONTROL));
                if (MatrixCInit(data) == TRUE)
                {
                    data->Status = SNMP_UNDERCREATION;
                    DnpapMessage(DMC_MESSAGE, MATRIX_CREATE, "matrix: collector %ld created", local->Index);
                    return SNMP_NOERROR;
                }
                DnpapFree(local->Data);
                MibRemove (obj, &MatrixControlInstance, idlen, CONTROLINDEXSIZE);
                return SNMP_GENERROR;
            default:
                return SNMP_NOSUCHNAME;
            }
        }
        data = (MATRIX_CONTROL*) local->Data;
        switch (data->Status)
        {
        case SNMP_UNDERCREATION:
            switch (obj->Syntax.LngInt)
            {
            case SNMP_VALID:
                if (MatrixCStart(data) == TRUE)
                {
                    data->Status = SNMP_VALID;
                    DnpapMessage(DMC_MESSAGE, MATRIX_START, "matrix: collector %ld active", local->Index);
                    return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            case SNMP_INVALID:
                if (MatrixCStop(data) == TRUE)
                {
                    DnpapFree(local->Data);
                    DnpapMessage(DMC_MESSAGE, MATRIX_DESTROY, "matrix: collector %ld destroyed", local->Index);
                    if (MibRemove (obj, &MatrixControlInstance, idlen, CONTROLINDEXSIZE) == TRUE)
                        return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            default:
                return SNMP_BADVALUE;
            }
        case SNMP_VALID:
            switch (obj->Syntax.LngInt)
            {
            case SNMP_VALID:
                return SNMP_NOERROR;
            case SNMP_INVALID:
                if (MatrixCStop(data) == TRUE)
                {
                    DnpapFree(local->Data);
                    DnpapMessage(DMC_MESSAGE, MATRIX_DESTROY, "matrix: collector %ld destroyed", local->Index);
                    if (MibRemove (obj, &MatrixControlInstance, idlen, CONTROLINDEXSIZE) == TRUE)
                        return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            default:
                return SNMP_BADVALUE;
            }
        }
    }
}


WORD DnpapMatrixSDSourceAddress(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo *base = NULL;
HostInfo *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &base, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DestSourceHashSearch2(local->Data, obj, &base, idlen,TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->ConnAddr, obj->SyntaxLen = HOST_SZEADDR);
        base->
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixSDDestAddress(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = SourceDestHashSearch2(local->Data, obj, idlen,TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->ConnAddr, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixSDIndex(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixSDPkts(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = SourceDestHashSearch2(local->Data, obj, idlen,TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->TotalPkts;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixSDOctets(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data,TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = SourceDestHashSearch2(local->Data, obj, idlen,TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->Octets;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixSDErrors(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data,TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = SourceDestHashSearch2(local->Data, obj, idlen,TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->Errors;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}

/******************************************************************
** SD functions, TopN data from source to destination */


/* DnpapMatrixSDTopNSource simply returns the source address */


WORD DnpapMatrixSDTopNSource(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL   *local = NULL;
HostInfo  *data = NULL;

    if ((local = MibRmon(obj,MatrixControlInstance, idlen,SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DestSourceHashSearch2(local->Data, obj, idlen,TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->ConnAddr, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


/* DnpapMatrixSDTopNDest simply returns the destination address */

WORD DnpapMatrixSDTopNDest(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL   *local = NULL;
HostInfo  *data = NULL;

    if ((local = MibRmon(obj,MatrixControlInstance, idlen,SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = SourceDestHashSearch2(local->Data, obj, idlen,TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->ConnAddr, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}

/* DnpapMatrixSDTopNIndex simply returns the index */


WORD DnpapMatrixSDTopNIndex(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL   *local = NULL;
HostInfo  *data = NULL;

    if ((local = MibRmon(obj,MatrixControlInstance, idlen,SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data,TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}

/* DnpapMatrixSDTopRankIndex returns the rank of the destination in the top
list of the source */


WORD DnpapMatrixSDTopRankIndex(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL   *local = NULL;
HostInfo   *data;

    if ((local = MibRmon(obj,MatrixControlInstance, idlen,SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = GetRankDest(local->Data, obj, idlen,TRUE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data,obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }

}

/* DnpapMatrixSDTopNPkts returns the total packets that belong
 to the pair of the source , destination */

WORD DnpapMatrixSDTopNPkts(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL   *local = NULL;
HostInfo  *data = NULL;

    if ((local = MibRmon(obj,MatrixControlInstance, idlen,SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data,TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = SourceDestTopSearch(local->Data, obj, idlen)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->TotalPkts;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixDSSourceAddress(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo   *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DestSourceHashSearch2(local->Data, obj, idlen,FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->ConnAddr, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixDSDestAddress(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo   *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = SourceDestHashSearch2(local->Data, obj, idlen,FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->ConnAddr+HOST_SZEADDR, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixDSIndex(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo   *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixDSPkts(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo   *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DestSourceHashSearch2(local->Data, obj, idlen,FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->TotalPkts;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixDSOctets(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo   *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DestSourceHashSearch2(local->Data, obj, idlen,FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->Octets;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


WORD DnpapMatrixDSErrors(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL  *local = NULL;
HostInfo   *data = NULL;

    if ((local = MibRmon(obj, MatrixControlInstance, idlen, SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, FALSE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DestSourceHashSearch2(local->Data, obj, idlen,FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->Errors;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}

/***********************************************************************
*                                                                      *
*   Added DS functions                                                 *
*                                                                      *
************************************************************************/
/** DS functions, TopN data from source to destination */


WORD DnpapMatrixDSTopNSource(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL   *local = NULL;
HostInfo    *data = NULL;

    if ((local = MibRmon(obj,MatrixControlInstance, idlen,SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DestSourceHashSearch2(local->Data, obj, idlen,FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->ConnAddr, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}

WORD DnpapMatrixDSTopNDest(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL   *local = NULL;
HostInfo    *data = NULL;

    if ((local = MibRmon(obj,MatrixControlInstance, idlen,SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = SourceDestHashSearch2(local->Data, obj, idlen,FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data->ConnAddr, obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}



WORD DnpapMatrixDSTopNIndex(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL   *local = NULL;
HostInfo  *data = NULL;

    if ((local = MibRmon(obj,MatrixControlInstance, idlen,SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data,TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}

/* DnpapMatrixDSTopRankIndex returns the rank of the source in the top
list of the destination */


WORD DnpapMatrixDSTopRankIndex(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL   *local = NULL;
HostInfo   *data;

    if ((local = MibRmon(obj,MatrixControlInstance, idlen,SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = GetRankSource(local->Data, obj, idlen,FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (obj->Syntax.BufChr, data,obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }

}


WORD DnpapMatrixDSTopNPkts(SNMP_OBJECT *obj, WORD idlen)
{
MIB_LOCAL   *local = NULL;
HostInfo    *data = NULL;

    if ((local = MibRmon(obj,MatrixControlInstance, idlen,SRCDSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext(obj, &local, idlen, SRCDSTINDEXSIZE, &data, TRUE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = DestSourceTopSearch(local->Data, obj, idlen,FALSE)) == NULL)
            return SNMP_NOSUCHNAME;
        obj->Syntax.LngUns = data->TotalPkts;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
    	return SNMP_READONLY;
    }
}


/* end of added DS functions */



/* new functions */

/* SrcDstGetFirstNext searches for the destination belonging to a source */
/* if the source is complete and the destination is not, then de destination */
/* is taken that is greater than the target destination */
/* if the source address is not complete, the source that resembles the */
/* given source most, is taken, and then the first destination is taken */


HostInfo *SrcDstGetFirstNext(MATRIX_CONTROL *matrixcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first,BOOLEAN SDorder)
{
BYTE srcdst[2*HOST_SZEADDR];
HostInfo *p;
INT i, len;

    if (matrixcontrol->TableSize == 0)
        return NULL;

    if (first == TRUE)
        if (SDorder == TRUE)
            return matrixcontrol->SourceList->Info;
        else
            return matrixcontrol->DestList->Info;


    len = obj->IdLen-idlen-1;
    if (len < 0)
        len = 0;

    /* fill srcdst */

    for (i = 0; i < len; i++)
        srcdst[i] = (BYTE)obj->Id[idlen+1+i];


    p = SourceDestHashSearch(matrixcontrol,srcdst,len,SDorder);


    if (len == 2*HOST_SZEADDR && p != NULL)
        p = p->LexNextList;


    if (p != NULL)
    {
        if (SDorder == TRUE)
        {
            for (i=0;i<2*HOST_SZEADDR;i++)
                obj->Id[idlen+1+i] = (LONG)p->ConnAddr[i];

        }
        else
        {
            for (i = 0; i < HOST_SZEADDR; i++)
            {
                obj->Id[idlen+1+i] = (LONG)p->ConnAddr[HOST_SZEADDR+i];
                obj->Id[idlen+1+HOST_SZEADDR+i] = (LONG)p->ConnAddr[i];

            }

        }

       obj->IdLen = idlen + SRCDSTINDEXSIZE;
    }
    return p;
}




