#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <mib.h>
#include "rmon.h"

void main (void)                   
{                                  
    unsigned Err, Ind = 0;             
    MIB_PROFIL profile = { "application", 11 };
    MIB_OBJECT object = {MIB_RQSNXT,{0,0},2,MIB_NULL};
    MIB_OBJECT Obj[] =                        
    {
        {MIB_RQSSET, {1,3,6,1,4,1,99,1,1,21,2}, 11, MIB_INTEGER, MIB_CREATEREQUEST},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,21,2}, 11},
        {MIB_RQSSET, {1,3,6,1,4,1,99,1,1,20,2}, 11, MIB_OCTETSTR},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,20,2}, 11},
        {MIB_RQSSET, {1,3,6,1,4,1,99,1,1,21,2}, 11, MIB_INTEGER, MIB_VALID},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,21,2}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,1,2}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,2,2}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,3,2}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,4,2}, 11},
        {MIB_RQSSET, {1,3,6,1,4,1,99,1,1,21,1}, 11, MIB_INTEGER, MIB_CREATEREQUEST},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,21,1}, 11},
        {MIB_RQSSET, {1,3,6,1,4,1,99,1,1,20,1}, 11, MIB_OCTETSTR},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,20,1}, 11},
        {MIB_RQSSET, {1,3,6,1,4,1,99,1,1,21,1}, 11, MIB_INTEGER, MIB_VALID},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,21,1}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,1,1}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,2,1}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,3,1}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,4,1}, 11},
        {MIB_RQSSET, {1,3,6,1,4,1,99,1,1,21,2}, 11, MIB_INTEGER, MIB_CREATEREQUEST},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,21,2}, 11},
        {MIB_RQSSET, {1,3,6,1,4,1,99,1,1,20,2}, 11, MIB_OCTETSTR},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,20,2}, 11},
        {MIB_RQSSET, {1,3,6,1,4,1,99,1,1,21,2}, 11, MIB_INTEGER, MIB_VALID},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,21,2}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,1,2}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,2,2}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,3,2}, 11},
        {MIB_RQSGET, {1,3,6,1,4,1,99,1,1,4,2}, 11}
    };                                 

    strcpy (Obj[2].Syntax.BufChr, "monitorSTATV");
    Obj[2].SyntaxLen = 12;

    MibInit (beholdPrf, beholdObj, sizeof(beholdPrf)/sizeof(MIB_COMMUNITY),
        sizeof(beholdObj)/sizeof(MIB_ELEMENT));          /* initialises MIB */
    printf("\nOK: initialization\n");
    for (Ind = 0; Ind < sizeof(Obj)/sizeof(MIB_OBJECT);Ind++)
    {
        if (!(Err = MibRequest (&profile, &Obj[Ind])))
        {
            printf ("\nOK: %u",Ind);
            switch (Obj[Ind].Type)
            {
                case MIB_INTEGER:
                    printf("INTEGER: (%u) %ld", Obj[Ind].Request, Obj[Ind].Syntax.LngInt);
                    break;
                case MIB_OCTETSTR:
                    printf("OCTETSTR (%u) %s", Obj[Ind].Request, &Obj[Ind].Syntax.BufChr);
                    break;
                case MIB_OBJECTID:
                    printf("OBJECTID (%u)", Obj[Ind].Request);
                    break;
                case MIB_COUNTER:
                    printf("COUNTER (%u) %lu", Obj[Ind].Request, Obj[Ind].Syntax.LngUns);
                    break;
                default:
                    printf(" type unknown ");
            }
        }
        else
            printf("\nError: %u",Ind);
    }
    while (MibRequest(&profile,&object) == MIB_NOERROR)
    {
        printf ("\nOK:");
        switch (object.Type)
        {
            case MIB_INTEGER:
                printf(" %ld",object.Syntax.LngInt);
                break;
            case MIB_OCTETSTR:
                printf(" %s",object.Syntax.BufChr);
                break;
            case MIB_OBJECTID:
                printf(" ObjectId");
                break;
            case MIB_COUNTER:
                printf(" %lu",object.Syntax.LngUns);
                break;
            default:
                printf(" type unknown ");
        }
    }
}

void
DnpapMessage(int mc, LONG ec, CONST char *msg VAR_PROTO)
{
    printf(msg);
}

VOID *
DnpapMalloc(ULONG size)
{
    return malloc((size_t)size);
}

void
DnpapFree(VOID *p)
{
    free(p);
}


