#ifndef _ARP_H_
#define _ARP_H_


#include <dnpap.h>
#include <mac.h>
#include <timer.h>


#define ARP_ENTRY_TIMEOUT       300000L
#define ARP_REQUEST_TIMEOUT     2000L
#define ARP_REQUEST_RETRIES     3


#define ARP_LENGTH_PROT 16
#define ARP_LENGTH_HARD 6


typedef struct _ARP_DESCR   ARP_DESCR;
typedef struct _ARP_REQUEST ARP_REQUEST;
typedef struct _ARP_QUE     ARP_QUE;
typedef struct _ARP_ENTRY   ARP_ENTRY;
typedef void (*ARP_REPLY)(MAC_IFACE *iface, ARP_ENTRY *entry, void *specific);




struct _ARP_DESCR
{
    MAC_IFACE   *iface;
    WORD        prot;
    BYTE        addr[ARP_LENGTH_PROT];
    WORD        addrLength;
    ARP_ENTRY   *entryList;
    ARP_REQUEST *requestList;
    ARP_DESCR   *next;
};

struct _ARP_REQUEST
{
    ARP_DESCR   *descr;
    BYTE        addr[ARP_LENGTH_PROT];
    WORD        retry;
    TIMER_DESCR *timer;
    ARP_QUE     *queList;
    ARP_REQUEST *next;
};

struct _ARP_QUE
{
    ARP_REPLY   Reply;
    void        *specific;
    ARP_QUE     *next;
};


struct _ARP_ENTRY
{
    BYTE      addrProt[ARP_LENGTH_PROT];
    BYTE      addrHard[ARP_LENGTH_HARD];
    BOOLEAN   dynamic;
    BOOLEAN   update;
    ARP_ENTRY *next;
};





BOOLEAN     ArpInit(void);
BOOLEAN     ArpRegister(ARP_DESCR *arp);
void        ArpRemove(ARP_DESCR *arp);

ARP_ENTRY   *ArpFind(MAC_IFACE *iface, WORD prot, BYTE *addr);
BOOLEAN ArpRequest(MAC_IFACE *iface, WORD prot, BYTE *addr,
                ARP_REPLY Reply, void *specific);



#endif



