#include <chain.h>
#include <udp.h>
#include "echo.h"



static BOOLEAN Rcve(UDP_DESCR *descr, CHAIN *chain, UDP_HDR *udpHdr, IP_HDR *ipHdr);



UDP_DESCR echoUdp =
{
    Rcve,
    7,
    UDP_ADDR_ANY,
    UDP_PORT_ANY,
    UDP_ADDR_ANY,
    0
};

ECHO_STAT echoStat;


BOOLEAN EchoInit(void)
{
    static BOOLEAN init = FALSE;
    
    if (!init)
    {
        init = UdpRegister(&echoUdp);
    }

    return init;
}


ECHO_STAT *EchoStatistics(void)
{
    return &echoStat;
}



static BOOLEAN Rcve(UDP_DESCR *descr, CHAIN *chain, UDP_HDR *udpHdr, IP_HDR *ipHdr)
{
    WORD    port;
    DWORD   addr;
    BOOLEAN success = FALSE;
    
    port        = udpHdr->src;
    udpHdr->src = udpHdr->dst;
    udpHdr->dst = port;

    addr        = ipHdr->src;
    ipHdr->src  = ipHdr->dst;
    ipHdr->dst  = addr;

    success = UdpSend(chain, udpHdr, ipHdr);
    
    if (success)
        echoStat.datagrams++;
    else
        echoStat.errors++;

    return success;
}
