#ifndef _MGMT_H_
#define _MGMT_H_

#include <snmp.h>

typedef struct _MGMT        MGMT;
typedef union  _MGMT_MEDIUM MGMT_MEDIUM;
typedef struct _MGMT_PIPE   MGMT_PIPE;
typedef struct _MGMT_UDP    MGMT_UDP;

#define MGMT_TYPE_DEFAULT 0
#define MGMT_TYPE_PIPE    1
#define MGMT_TYPE_UDP     2

struct  _MGMT_PIPE
{
    USHORT  handle;
};

struct  _MGMT_UDP
{
    int     socket;
};

union   _MGMT_MEDIUM
{
    MGMT_PIPE pipe;
    MGMT_UDP  udp;
};


struct  _MGMT
{
    int         type;                           /* type of mgmt medium */
    MGMT_MEDIUM medium;                         /* medium information */
};

BOOLEAN MgmtInit(void);
MGMT    *MgmtOpen(char *agent, int medium);
BOOLEAN MgmtClose(MGMT *mgmt);
BOOLEAN MgmtRequest(MGMT        *mgmt,
                    BYTE        *comm,
                    WORD        commLen,
                    WORD        type,
                    SNMP_OBJECT *list,
                    WORD        listLen,
                    WORD        *status,
                    WORD        *index,
                    ULONG       timeout,
                    USHORT      retries);
BOOLEAN MgmtSend(MGMT *mgmt, BYTE *buffer, WORD length);
BOOLEAN MgmtRecv(MGMT *mgmt, BYTE **buffer, WORD *length, ULONG timeout);

#endif
