#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <dnpap.h>
#include <snmp.h>
#include "protocol.h"

#define REC_FRAME       0xF8        /* Marks start of a frame */

struct rec_hdr {
    BYTE  type;
    short len;
};

/* Compare DP.H _DPBUF for the first 6 items */
static struct frame {
    short Dev;                      /* Logic dev# [0..DPMAXDEV-1]  */
    LWORD ClockMs;                  /* Timestamp in micro seconds  */
    WORD Status;                    /* Status bits - internal use  */
    WORD Size;                      /* Packet length in bytes      */
    BYTE *pBuf;                     /* Pointer to packet's content */
    struct frame *pNext;            /* Pointer - internal use      */
    BYTE Data[1600];                /* Packet data contents        */
};


int ReadByteFromFile (FILE *file, BYTE *b)
{
    return ((fread(b, 1, 1, file) == 1) ? 0 : EOF);
}

int ReadIntFromFile (FILE *file, short *i)
{
    BYTE t1, t2;

    if (ReadByteFromFile(file, &t1) == EOF)
        return (EOF);
    if (ReadByteFromFile(file, &t2) == EOF)
        return (EOF);
    *i = (t2 << 8) | t1;
    return (0);
}

int ReadLongFromFile (FILE *file, long *l)
{
    BYTE t1, t2, t3, t4;

    if (ReadByteFromFile(file, &t1) == EOF)
        return (EOF);
    if (ReadByteFromFile(file, &t2) == EOF)
        return (EOF);
    if (ReadByteFromFile(file, &t3) == EOF)
        return (EOF);
    if (ReadByteFromFile(file, &t4) == EOF)
        return (EOF);
    *l = (t4 << 24) | (t3 << 16) | (t2 << 8) | t1;
    return (0);
}

void main(void)
{
    FILE *dumpfile;
    struct rec_hdr hdr;
    struct frame buf;
    PROT_PKT Pkt;
    PROT_OBJ Obj;
    BYTE Packet[1700], *Ptr;
    BYTE *StrPtr, Str[255];
    LONG ID = 0;
    LWORD Type, Class;
    WORD Len, Ind, Ind2, Number, Flag, u[4], Ether = 0;

    dumpfile = fopen("pktcapt.dmp", "r");

    if (dumpfile == NULL)
        printf("\ncan't open dumpfile: PKTCAPT.DMP\n");
    else
    {
        while ((ReadByteFromFile(dumpfile, &hdr.type) == 0) &&
               (ReadIntFromFile(dumpfile, &hdr.len) == 0))
        {
            if (hdr.type != REC_FRAME)
				fread(&buf, sizeof(BYTE), (hdr.len-3), dumpfile);
            else
            {
                if ((ReadIntFromFile (dumpfile, &buf.Dev) == 0) &&
                    (ReadLongFromFile (dumpfile, &buf.ClockMs) == 0) &&
                    (ReadIntFromFile (dumpfile, &buf.Status) == 0) &&
                    (ReadIntFromFile (dumpfile, &buf.Size) == 0) &&
                    (fread(&buf.pBuf, sizeof(buf.pBuf), 1, dumpfile) == 1) &&
                    (fread(&buf.pNext, sizeof(buf.pNext), 1, dumpfile) == 1) &&
                    (fread(&buf.Data, sizeof(BYTE), buf.Size, dumpfile) == buf.Size))
                {
                    Packet[0] = ((BYTE*) &Ether)[0];
                    Packet[1] = ((BYTE*) &Ether)[1];
                    Packet[2] = ((BYTE*) &Ether)[0];
                    Packet[3] = ((BYTE*) &Ether)[1];
                    Packet[4] = ((BYTE*) &ID)[0];
                    Packet[5] = ((BYTE*) &ID)[1];
                    Packet[6] = ((BYTE*) &ID)[2];
                    Packet[7] = ((BYTE*) &ID)[3];
                    Packet[8] = ((BYTE*) &buf.Size)[0];
                    Packet[9] = ((BYTE*) &buf.Size)[1];
                    Packet[10] = ((BYTE*) &buf.ClockMs)[0];
                    Packet[11] = ((BYTE*) &buf.ClockMs)[1];
                    Packet[12] = ((BYTE*) &buf.ClockMs)[2];
                    Packet[13] = ((BYTE*) &buf.ClockMs)[3];
                    memcpy(&Packet[14],buf.Data, 1600);

                    ProtFile (&Pkt, Packet);
                    ID++;
                    Obj.Id[0] = 9;
                    Obj.Level = 99;
                    for (Ind = 1; Ind < 4; Ind++)
                    {
                        Flag = 1;
                        Obj.Id[1] = Ind + 3;                /* number of .. */
                        if (!ProtGetField(&Pkt,&Obj))
                        {
                            printf("\nField not found");
                            Flag = 0;
                        }
                        if (Flag)
                            Number = (WORD) Obj.Syntax.LngUns;
                        else
                            Number = 0;
                        for (Ind2 = 1; Ind2 < Number + 1; Ind2++)
                        {
                            Obj.Id[1] = Ind + 7;
                            Obj.Id[2] = Ind2;
                            Obj.Id[3] = 3;
                            if (Flag && !ProtGetField(&Pkt,&Obj))
                            {
                                printf("\nField not found");
                                Flag = 0;
                            }
                            Class = Obj.Syntax.LngUns;
                            if (Flag && Class == 1L)
                            {
                                Obj.Id[3] = 2;
                                if (Flag && !ProtGetField(&Pkt,&Obj))
                                {
                                    printf("\nField not found");
                                    Flag = 0;
                                }
                                Type = Obj.Syntax.LngUns;
                                Obj.Id[3] = 1;
                                if (Flag && !ProtGetField(&Pkt,&Obj))
                                {
                                    printf("\nField not found");
                                    Flag = 0;
                                }
                                if (Flag && !ProtPrint(&Obj, &StrPtr))
                                {
                                    printf("\nPrint error");
                                    Flag = 0;
                                }
                                Obj.Id[3] = 6;
                                if (Flag && !ProtGetField(&Pkt,&Obj))
                                {
                                    printf("\nField not found");
                                    Flag = 0;
                                }
                                if (Flag)
                                {
                                    switch(Type)
                                    {
                                        case 1:
                                            Ptr = (BYTE *) Obj.Syntax.Ptr;
                                            printf("\n%s : %u.%u.%u.%u", StrPtr,
                                                *(Ptr), *(Ptr + 1),
                                                *(Ptr + 2), *(Ptr + 3));
                                            break;
                                        case 12:
                                            sscanf(StrPtr, "%u.%u.%u.%u.",&u[3],&u[2],&u[1],&u[0]);
                                            Len = 0;
                                            Ptr = (BYTE *) Obj.Syntax.Ptr;
                                            while (*Ptr)
                                            {
                                                if (*Ptr & 0xC0)
                                                    exit(1);
                                                Ptr++;
                                                memcpy(&Str[Len], Ptr, *(Ptr-1));
                                                Len += *(Ptr-1);
                                                Str[Len++]='.';
                                                Ptr += *(Ptr-1);
                                            }
                                            Str[Len] ='\0';
                                            printf("\n%s : %u.%u.%u.%u", Str, u[0],u[1],u[2],u[3]);
                                    }
                                }
                            }
                        }
                    }
                    ProtFree(&Pkt);
                }
            }
        }
        fclose(dumpfile);
    }
}

