/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TV3PropertiesDlg
extends JDialog
implements ActionListener,
ChangeListener {
    private static final int MIN_POINTS = 10;
    private static final int MAX_POINTS = 400;
    private static final int MIN_REFRESH = 5;
    private static TV3PropertiesDlg dialog;
    private JTextField server;
    private JTextField timeScale;
    private JSlider sliderRefresh;
    private int timeScaleInt;
    private int refreshInt;
    private JLabel info;
    private ActionListener actionListener;

    public static void showDialog(Component component, String string, int n, int n2, ActionListener actionListener) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        dialog = new TV3PropertiesDlg(frame, string, n, n2);
        dialog.setActionListener(actionListener);
        ((Component)dialog).setVisible(true);
    }

    private TV3PropertiesDlg(Frame frame, String string, int n, int n2) {
        super(frame, "Properties", true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 3, 10));
        JLabel jLabel = new JLabel("Server:");
        this.server = new JTextField(string, 30);
        jLabel.setLabelFor(this.server);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(this.server);
        jPanel.add(jPanel2);
        jLabel = new JLabel("Time scope (HH:MM):");
        this.timeScale = new JTextField("", 5);
        this.timeScale.setInputVerifier(new TimeVerifier());
        jLabel.setLabelFor(this.timeScale);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(this.timeScale);
        jPanel.add(jPanel2);
        jLabel = new JLabel("Refresh every... (MM:SS):");
        this.sliderRefresh = new JSlider(0);
        this.sliderRefresh.setPaintLabels(true);
        this.sliderRefresh.setPaintTicks(true);
        this.sliderRefresh.setPaintTrack(true);
        this.sliderRefresh.addChangeListener(this);
        this.info = new JLabel(" ");
        jPanel.add(jLabel);
        jPanel.add(this.sliderRefresh);
        jPanel.add(this.info);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Set");
        jButton2.setActionCommand("Set");
        jButton2.addActionListener(this);
        this.getRootPane().setDefaultButton(jButton2);
        jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel2.add(jButton2);
        jPanel2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.darkGray));
        jPanel.add(jPanel2);
        Container container = this.getContentPane();
        container.add(jPanel);
        this.refreshInt = n2;
        this.setTimeScale(n, ":");
        this.sliderRefresh.setValue(n2);
        this.pack();
        Rectangle rectangle = frame.getBounds();
        ((Component)this).setLocation((int)(rectangle.getX() + (rectangle.getWidth() - (double)this.getWidth()) / 2.0), (int)(rectangle.getY() + (rectangle.getHeight() - (double)this.getHeight()) / 2.0));
    }

    private String RefreshToStr(int n) {
        int n2 = n / 3600;
        int n3 = (n %= 3600) / 60;
        int n4 = n % 60;
        String string = n2 != 0 ? new Integer(n2).toString() + ":" : new String();
        if (n3 < 10) {
            string = string + "0";
        }
        string = string + new Integer(n3) + ":";
        if (n4 < 10) {
            string = string + "0";
        }
        string = string + new Integer(n4);
        return string;
    }

    private void setTimeScale(int n, String string) {
        if (n > 86400) {
            n = 86400;
        } else if (n < 600) {
            n = 600;
        }
        this.timeScaleInt = n;
        int n2 = n / 60 % 60;
        int n3 = n / 60 / 60;
        if (n2 < 10) {
            string = string + "0";
        }
        this.timeScale.setText(new Integer(n3).toString() + string + new Integer(n2).toString());
        int n4 = n / 10;
        int n5 = n / 400;
        if (n5 < 5) {
            n5 = 5;
        }
        this.sliderRefresh.setMaximum(n4);
        this.sliderRefresh.setMinimum(n5);
        this.sliderRefresh.setMajorTickSpacing((n4 - n5) / 60);
        this.sliderRefresh.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(n5), new JLabel(this.RefreshToStr(n5)));
        int n6 = (n5 + n4) / 2;
        hashtable.put(new Integer(n6), new JLabel(this.RefreshToStr(n6)));
        hashtable.put(new Integer(n4), new JLabel(this.RefreshToStr(n4)));
        this.sliderRefresh.setLabelTable(hashtable);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        JSlider jSlider = (JSlider)changeEvent.getSource();
        this.refreshInt = n = jSlider.getValue();
        this.info.setText("Refresh every " + new Integer(n) + " seconds, " + new Integer(this.timeScaleInt / this.refreshInt) + " points.");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Set".equals(actionEvent.getActionCommand())) {
            ActionEvent actionEvent2 = new ActionEvent(this, 0, "properties");
            this.actionListener.actionPerformed(actionEvent2);
        }
        ((Component)dialog).setVisible(false);
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public String getServer() {
        return this.server.getText();
    }

    public int getTimeScale() {
        return this.timeScaleInt;
    }

    public int getRefresh() {
        return this.refreshInt;
    }

    class TimeVerifier
    extends InputVerifier {
        TimeVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            return this.checkField(jComponent, false);
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            int n;
            String string = TV3PropertiesDlg.this.timeScale.getText().trim();
            int n2 = string.indexOf(58);
            if (n2 == -1 && (n2 = string.indexOf(46)) == -1 && (n2 = string.indexOf(47)) == -1) {
                n2 = string.indexOf(92);
            }
            int n3 = 0;
            try {
                if (n2 == -1) {
                    n = Integer.parseInt(string);
                    string = ":";
                } else {
                    n3 = Integer.parseInt(string.substring(0, n2));
                    n = Integer.parseInt(string.substring(n2 + 1));
                    string = string.substring(n2, n2 + 1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = 30;
                string = ":";
            }
            TV3PropertiesDlg.this.setTimeScale(60 * (n3 * 60 + n), string);
            TV3PropertiesDlg.this.timeScale.selectAll();
            return true;
        }

        protected boolean checkField(JComponent jComponent, boolean bl) {
            return true;
        }
    }
}

