/**************************************************************************/
/*                                                                        */
/* REMOVEOF.cmd - Procedure to remove any/all extraneous End-Of-File      */
/*                (EOF) marks from an ASCII text file.                    */
/*                                                                        */
/*                The SLIP/Dialer program APPENDS its entries to the      */
/*                connect.log file, and does not remove any EOF marks.    */
/*                The log entries will be in the file but you typically   */
/*                can not see them with the 'TYPE' command or a normal    */
/*                text editor (or with the INETTIME summary command)      */
/*                after an EOF mark.                                      */
/*                                                                        */
/*------------------------------------------------------------------------*/
/*                                                                        */
/* Copyright (c) D.A.Ritari-KNIGHT RESEARCH - 1995 - ALL RIGHTS RESERVED  */
/*                                                                        */
/* FREELY DISTRIBUTABLE FOR ANY USE OR PURPOSE.                           */
/* NO WARRANTY OF MERCHANTABILITY OR FITNESS FOR ANY PURPOSE IMPLIED.     */
/*                                                                        */
/* Version:       1.0                                                     */
/* Last Update:   March 2, 1995                                           */
/*                                                                        */
/* Contact:       Constructive comments and tips to:                      */
/*                                                                        */
/*                Internet:    dritari@ibm.net                            */
/*                Compuserve:  71301,3400                                 */
/*                                                                        */
/*------------------------------------------------------------------------*/
/*                                                                        */
/* USAGE:    REMOVEOF  <Input-file>  <Output-file>                        */
/*                                                                        */
/* Example:  REMOVEOF \TCPIP\ETC\CONNECT.LOG  \TCPIP\ETC\CONNECT.OUT      */
/*                                                                        */
/* This utility does not write back to the original log file...I advise   */
/* you to look at the output (and perhaps keep a backup of your original  */
/* until you are convinced the removal of EOF marks went ok)...then       */
/* copy the <output-file> back to CONNECT.LOG                             */
/*                                                                        */
/* How do EOF marks (HEX character 1A) get append to my CONNECT.LOG       */
/* file in the first place?  You must have edited your log with a text    */
/* editor and saved the file...MOST text editors put an EOF mark at the   */
/* end of a file. This EOF mark will cause many problems for you in the   */
/* future as you try to 'type', edit, or summarize (using INETTIME)       */
/* as these commands only read until the EOF mark...all further entries   */
/* in the log are ignored.                                                */
/*                                                                        */
/**************************************************************************/
/*********** FILE_ID.DIZ *************************/
/* INETTIME.CMD - Version 1.3 - June 19, 1995    */
/* -Small REXX proc for OS/2 to summarize        */
/*  by month all connect time to IBM's Advantis  */
/*  Internet network using the CONNECT.LOG as    */
/*  input data. (See INETTIME.TXT for details).  */
/* REMOVEOF.cmd - Version 1.0 - March 2, 1995    */
/* -Procedure to remove any/all extraneous       */
/*  End-Of-File (EOF) marks from an ASCII text   */
/*  file. (See REMOVEOF.TXT for details).        */
/* Copyright(c) D.A.Ritari-KNIGHT RESEARCH-1995  */
/*************************************************/

PARSE ARG filein fileout

say; say 'REMOVEOF - Version 1.0'
/* ------------------------ Validate filenames --------------------------*/
if filein = ''  | fileout = '' then do
    SAY; SAY "REMOVEOF - Procedure to remove any/all extraneous End-Of-File"
    SAY "          (EOF) marks from an ASCII Text file."
    SAY; SAY "USAGE:   REMOVEOF  <Input-file>  <Output-file>"; SAY
    EXIT
    END
if filein = fileout then do
    say; say "Do NOT use the same filename for input and output"
    say "Choose two distinct names"; say
    EXIT
    END
if "" == stream(filein, 'c', 'query exists') then do
    say; say 'Input file "' || filein || '" NOT FOUND!'
    say 'Please check the spelling and retry.'
    say
    EXIT
    END
if "" \== stream(fileout, 'c', 'query exists') then do
    say; say 'Output file "' || fileout || '" already exists!'
    say 'Either choose a different output name OR'
    say '    delete "' || fileout || '" first before running the REMOVEOF command.'
    say
    EXIT
    END
/*------------------------ Process the file -----------------------------*/
say; say "WORKING"; say
EOF_MARKS = 0                                        /* BINARY read      */
do while Chars(filein) > 0                           /* for entire file  */
    data1 = CharIn(filein,,1)                        /* get 1 byte       */
    if 26 \== C2D(data1) then do                     /* if NOT EOF mark  */
        rc = CharOut(fileout, data1)                 /* write 1 byte     */
        end
    else do
        EOF_MARKS = EOF_MARKS + 1
        end
    end
/*------------------------------ Exit -----------------------------------*/
say "DONE"; say
say 'Total EOF marks found in "' || filein || '": ' EOF_MARKS; say

EXIT
