/*

  REXX Script to create the InJoy desktop folder

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

say "Creating Desktop Folder..."

dir = directory() || '\'

say "Creating folder"
call SysCreateObject "WPFolder", "InJoy Internet Dialer", "<WP_DESKTOP>", "OBJECTID=<INJOYFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=10.Helv;BACKGROUND=" || dir || "back.bmp,T;ICONFILE=" || dir || "FOLDER.ICO", "replace"
call SysCreateObject "WPFolder", "Extras", "<INJOYFOLDER>", "OBJECTID=<INJOYEXTRASFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Packet Tracing", "<INJOYFOLDER>", "OBJECTID=<INJOYTRACEFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Tools", "<INJOYFOLDER>", "OBJECTID=<INJOYUTILFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Log Files", "<INJOYFOLDER>", "OBJECTID=<INJOYLOGFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Information", "<INJOYFOLDER>", "OBJECTID=<INJOYINFOFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Firewall Configuration GUI", "<INJOYFOLDER>", "OBJECTID=<INJOYFWFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "IPSec Configuration GUI", "<INJOYFOLDER>", "OBJECTID=<INJOYIPSFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"

say "Creating program objects..."


/* EXTRAS */
call SysCreateObject "WPProgram", "IP Forwarding" || d2c(10) || "(Disable)", "<INJOYEXTRASFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=" || "/C " || '"' || "ipgate off" || '"', "replace"
call SysCreateObject "WPProgram", "IP Forwarding" || d2c(10) || "(Enable)", "<INJOYEXTRASFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=" || "/C " || '"' || "ipgate on" || '"', "replace"


/* TOOLS */
call SysCreateObject "WPProgram", "Reload DHCP Server" || d2c(10) || "Configuration", "<INJOYUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-dhcpd", "replace"
call SysCreateObject "WPProgram", "Reload IPSec" || d2c(10) || "Configuration", "<INJOYUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-ipsec", "replace"
call SysCreateObject "WPProgram", "Disconnect InJoy", "<INJOYUTILFOLDER>", "EXENAME=" || dir || "SETJOY.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-D", "replace"
call SysCreateObject "WPProgram", "Connect InJoy", "<INJOYUTILFOLDER>", "EXENAME=" || dir || "SETJOY.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-CONNECT", "replace"
call SysCreateObject "WPProgram", "KillJoy", "<INJOYUTILFOLDER>", "EXENAME=" || dir || "KILLJOY.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"


/* TRACE */
call SysCreateObject "WPProgram", "Delete Trace File", "<INJOYTRACEFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=" || "/C " || '"' || "del " || dir || "packet.trc" || '"', "replace"
call SysCreateObject "WPProgram", "Format Trace" || d2c(10) || "(to Screen)", "<INJOYTRACEFOLDER>", "EXENAME=" || dir || "IPFORMAT.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-r packet.trc", "replace"
call SysCreateObject "WPProgram", "IP Trace" || d2c(10) || "(Stop)", "<INJOYTRACEFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-off:logbin", "replace"
call SysCreateObject "WPProgram", "IP Trace" || d2c(10) || "(Start)", "<INJOYTRACEFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-on:logbin", "replace"


/* LOG FILES */
call SysCreateObject "WPProgram", "DHCPd Logs", "<INJOYLOGFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\DHCPD.INI", "replace"
call SysCreateObject "WPProgram", "IPSec Logs", "<INJOYLOGFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\IPSEC.INI", "replace"
call SysCreateObject "WPProgram", "InJoy Logs", "<INJOYLOGFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\INJOY.INI", "replace"

/* FIREWALL CONFIGURATION */
call SysCreateObject "WPProgram", "Security Level", "<INJOYFWFOLDER>", "EXENAME=" || dir || "FXCFG.EXE;STARTUPDIR=" || dir || ";PARAMETERS=-seclev", "replace"
call SysCreateObject "WPProgram", "User Rules", "<INJOYFWFOLDER>", "EXENAME=" || dir || "FXCFG.EXE;STARTUPDIR=" || dir || ";PARAMETERS=-fire:1", "replace"
call SysCreateObject "WPProgram", "Blacklist Rules", "<INJOYFWFOLDER>", "EXENAME=" || dir || "FXCFG.EXE;STARTUPDIR=" || dir || ";PARAMETERS=-fire:2", "replace"
call SysCreateObject "WPProgram", "Whitelist Rules", "<INJOYFWFOLDER>", "EXENAME=" || dir || "FXCFG.EXE;STARTUPDIR=" || dir || ";PARAMETERS=-fire:3", "replace"
call SysCreateObject "WPProgram", "Sample Rules", "<INJOYFWFOLDER>", "EXENAME=" || dir || "FXCFG.EXE;STARTUPDIR=" || dir || ";PARAMETERS=-fire:4", "replace"

/* IPSEC CONFIGURATION */
call SysCreateObject "WPProgram", "IPSec VPN Wizard", "<INJOYIPSFOLDER>", "EXENAME=" || dir || "FXCFG.EXE;STARTUPDIR=" || dir || ";PARAMETERS=-wizard", "replace"
call SysCreateObject "WPProgram", "Tunnel Workshop", "<INJOYIPSFOLDER>", "EXENAME=" || dir || "FXCFG.EXE;STARTUPDIR=" || dir || ";PARAMETERS=-ipsec", "replace"
call SysCreateObject "WPProgram", "User Administration", "<INJOYIPSFOLDER>", "EXENAME=" || dir || "FXCFG.EXE;STARTUPDIR=" || dir || ";PARAMETERS=-user", "replace"

/* URL OBJECTS */
call SysCreateObject "WPUrl", "Online Documentation", "<INJOYINFOFOLDER>", "URL=http://www.fx.dk/docs", "replace"
call SysCreateObject "WPUrl", "Purchase", "<INJOYINFOFOLDER>", "URL=http://www.fx.dk/dialer_purchase", "replace"
call SysCreateObject "WPUrl", "Product Homepage", "<INJOYINFOFOLDER>", "URL=http://www.fx.dk/dialer", "replace"
call SysCreateObject "WPUrl", "F/X Communications", "<INJOYINFOFOLDER>", "URL=http://www.fx.dk", "replace"


/* MAIN PROGRAMS */
call SysCreateObject "WPProgram", "Reload Firewall" || d2c(10) || "Configuration", "<INJOYFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-firewall", "replace"
call SysCreateObject "WPProgram", "Security Logs", "<INJOYFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\FIREWALL.INI", "replace"
call SysCreateObject "WPProgram", "InJoy Dialer", "<INJOYFOLDER>", "EXENAME=" || dir || "IN-JOY.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
say "Folder creation completed!"
