/*---------------------------------------------------------------------------*\
|  Change Access Control Profiles             (C) Alain Rykaert - MAR99-MAR99 |
\*---------------------------------------------------------------------------*/
    Version = '1.01'
    Say '* CHGACL Version' Version

 /*=============================*/
    LogFileName = 'CHGACL.LOG'                             /* LOG File Name*/
 /*=============================*/

    Call Init                                                 /* Init dll's*/

    Parse Upper Arg ServerName Resource OldACP NewACP

    If ServerName = '' | Resource = '' | OldACP = '' | NewACP = ''
      Then Do
             Say '*'
             Say '* Change Access Control Profiles'
             Say '*'
             Say '* Usage: CHGACL {ServerName} {Resource} {OldACP} {NewACP}'
             Say '*'
             Say '* Sample: CHGACL SRV102 F:\DEVELOP PROG DEV'
             Say '*'
             Exit
           End
      Else Nop

    ServerName = Strip(ServerName,'L','\')

    Say '* Server Name:' '\\'ServerName
    Parse Var Resource DriveLetter ':' Rest
    UNCResource = '\\' || ServerName || '\' || DriveLetter || '$' || Rest
    Say '* UNCResource:' UNCResource
    Call SysFileTree UNCResource'\', 'Dirs', 'DO'
    If Dirs.0 > 0
      Then Do i = 1 to Dirs.0
              Call SysFileTree Dirs.i'\', 'SubDirs', 'DO'
              Say i Dirs.i SubDirs.0
           End
      Else Do
             Say '! Error: No Directories found'
             Exit
           End

    Exit

    RC = NetEnumerate(280, 'UserID', '\\'ServerName)       /* get all users*/
    If RC = 0
      Then Do
             Call RxStemSort 'UserID'                     /* sort all users*/
             Do i = 1 to UserID.0 - 2950
               Counter = '('Right(i,Length(UserID.0))'/'Right(UserID.0,Length(UserID.0))')'
               Call NetGetInfo 280, 'UserInfo', '\\'DCName, UserID.i
               If UserInfo.Home_Dir = '-none-'
                 Then Nop
                 Else Do
                        Say ' ' Counter Left(UserID.i, 10) '->' UserInfo.Home_Dir
                        If Pos(OldServer, UserInfo.Home_Dir) > 0
                          Then Do
                                 If Left(UserInfo.Home_Dir,2) = '\\'
                                   Then Do
                                          Parse Var UserInfo.Home_Dir '\\' ServerName '\' Rest
                                          NewHomeDir = '\\'NewServer'\'Rest
                                        End
                                   Else Do
                                          Parse Var UserInfo.Home_Dir Drive '\' ServerName '\' Rest
                                          NewHomeDir = Drive'\'NewServer'\'Rest
                                        End
                                 Say '09'x NewHomeDir
                                 RC = NetSetInfo(230, '\\'DCName, UserID.i, NewHomeDir)
                                 If RC = 0
                                   Then Nop
                                   Else Call ChkError RC
                               End
                          Else Nop
                      End
             End
           End
      Else Call ChkError RC

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('ComSpec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = Left(SysSearchPath('PATH', 'NET.EXE'), 2)    /* IBMLAN Drive*/
    If LSRDrive <> ''
      Then Nop
      Else Do
             Say '! Could not determine the Lan Requester path' '07'x
             Exit X2D('1604')
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
             Call RxLoadFuncs
           End
      Else Nop

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '! Error:' RCode '07'x
    Exit

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check '07'x
             Exit
           End
      Else Nop

    Return

 LOGIT:/* ------------------------------------------------------------------*/

    Parse Arg Log_Text

    Log_Text = Date('E') Time() Log_Text

    Call LineOut LogFileName, Log_Text
    Call Stream LogFileName, 'C', 'Close'

    Return


