/*---------------------------------------------------------------------------*\
|  Change Alias Name & Assignments            (C) Alain Rykaert - NOV97-DEC97 |
\*---------------------------------------------------------------------------*/
    Version = '1.02'
    Say '* CHGALIAS Version' Version

    Parse Upper Arg ServerName OldAliasName NewAliasName

    Call Init                                   /* load DLL's & other stuff*/

    If ServerName = '' | OldAliasName = ''
      Then Do
             Say '*'
             Say '* Change an Alias name & logon assignments'
             Say '*'
             Say '* Usage: CHGALIAS {PrimaryDomainController} {OldAliasName} {NewAliasName}'
             Say '*'
             Say '* Sample: CHGALIAS \\DC01 ALIAS1 ALIAS01'
             Say '*'
             Exit
           End
      Else Nop

    ServerName = Strip(ServerName,'L','\')

    Say '* Check if \\'ServerName 'is a Primary Domain Controller'
    RC = NetGetInfo(370, 'ServerModalInfo', '\\'ServerName)
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             If WordPos('Primary', ServerRole)
               Then Nop
               Else Do
                      Say '! This is not a Primary Domain Controller' '07'x
                      Exit
                    End
           End
      Else Call ChkError RC

    If NewAliasName = ''
     Then Nop
     Else Do
            Say '* Check if the new alias' NewAliasName 'already exist'
            RC = NetGetInfo(20, 'AliasInfo', '\\'ServerName, NewAliasName)
            If RC = 0
              Then Do
                     Say '! Alias' NewAliasName 'already exist' '07'x
                     Exit
                   End
              Else Nop
          End

    Say '* Get information from the old alias' OldAliasName
    RC = NetGetInfo(20, 'AliasInfo', '\\'ServerName, OldAliasName)
    If RC = 0
      Then Do
             LogFileName = OldAliasName || '.log'
             Say '* Log FileName:' LogFileName
             If Stream(LogFileName, 'C', 'Query Exists') = ''
               Then Nop
               Else 'del' LogFileName
             Call Logit LogFileName '*' Date('E') Time()
             Call Logit LogFileName '* Set' OldAliasName '<- to ->' NewAliasName
             Say '  Name       :' AliasInfo.Name
             Say '  Remark     :' AliasInfo.Remark
             Say '  Server     :' AliasInfo.Server
             Say '  NetName    :' AliasInfo.Netname
             Say '  Location   :' AliasInfo.Location
             Say '  Mode       :' AliasInfo.Mode
             Say '  Max uses   :' AliasInfo.Maxuses
             Say '  Type       :' AliasInfo.Type
             Say '  Queue      :' AliasInfo.Queue
             Say '  Path       :' AliasInfo.Path
             Say '  Priority   :' AliasInfo.Priority
             Say '  Device pool:' AliasInfo.Device_pool
             Say
             Call Logit LogFileName 'Name       :' AliasInfo.Name
             Call Logit LogFileName 'Remark     :' AliasInfo.Remark
             Call Logit LogFileName 'Server     :' AliasInfo.Server
             Call Logit LogFileName 'NetName    :' AliasInfo.Netname
             Call Logit LogFileName 'Location   :' AliasInfo.Location
             Call Logit LogFileName 'Mode       :' AliasInfo.Mode
             Call Logit LogFileName 'Max uses   :' AliasInfo.Maxuses
             Call Logit LogFileName 'Type       :' AliasInfo.Type
             Call Logit LogFileName 'Queue      :' AliasInfo.Queue
             Call Logit LogFileName 'Path       :' AliasInfo.Path
             Call Logit LogFileName 'Priority   :' AliasInfo.Priority
             Call Logit LogFileName 'Device pool:' AliasInfo.Device_pool
           End
      Else Call ChkError RC

    Say '* Get all users from \\'ServerName
    RC = NetEnumerate(280, 'UserID', '\\'ServerName)
    Say RC
    If RC = 0
      Then Do
             If RXUtils                         /* if RXutils DLL available*/
               Then Do
                      Say '* Sort all users'
                      Call RxStemSort 'UserID'
                    End
               Else Nop
             Say '* Get all users with a logon assignment to this alias'
             k = 0
             Do i = 1 to UserID.0
               Counter = '('Right(i,Length(UserID.0))'/'Right(UserID.0,Length(UserID.0))')'
               Say Counter UserID.i
               Call NetGetInfo 52, 'LogonAsnInfo', '\\'ServerName, UseriD.i
               Do j = 1 to LogonAsnInfo.Count
                 If LogonAsnInfo.j.Alias = OldAliasName
                   Then Do
                          k = k + 1
                          FoundUserID.k = UserID.i
                          FoundDevice.k = LogonAsnInfo.j.Device
                          Text = Counter Left(UserID.i,8) LogonAsnInfo.j.Device
                          Say ' ' Text
                          Call Logit LogFileName Text
                        End
                   Else Nop
                 LogonAsnInfo.j.Alias = ''
               End
             End
             FoundUserID.0 = k
           End
      Else Call ChkError RC

    If NewAliasName = ''
     Then Nop
     Else Do
            Say '* Delete old Alias definitions' OldAliasName
            RC = NetDelete(20, '\\'ServerName, OldAliasName)
            If RC = 0
              Then Call Logit LogFileName 'Alias' OldAliasName 'deleted'
              Else Call ChkError RC

            Say '* Add new Alias definitions' NewAliasName
            AliasInfo.Name = NewAliasName
            RC = NetAdd(20, 'AliasInfo', '\\'ServerName)
            If RC = 0
              Then Call Logit LogFileName 'Alias' NewAliasName 'added'
              Else Call ChkError RC

            Say '* Update logon assignments'
            Do i = 1 to FoundUserID.0
              Counter = '('Right(i,Length(FoundUserID.0))'/'Right(FoundUserID.0,Length(FoundUserID.0))')'
              Say ' ' Counter Left(FoundUserID.i,8) FoundDevice.i
              RC = NetDelete(52, '\\'ServerName, FoundUserID.i, OldAliasName)
              If RC = 0
                Then Nop
                Else Call ChkError RC
              RC = NetAdd(52, '\\'ServerName, NewAliasName, FoundDevice.i, FoundUserID.i)
              If RC = 0
                Then Nop
                Else Call ChkError RC
            End
          End

    Say '* Log File' LogFileName 'created'

    Exit

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('COMSPEC',,'OS2ENVIRONMENT'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath = Value('PATH',,'OS2ENVIRONMENT')
    x = Pos('IBMLAN\NETPROG', PPath) -3
    If x > 0
      Then LSRDrive = SubStr(PPath, x, 2)
      Else Do
             Say '* Could not determine the Lan Requester path' '07'x
             Exit
           End

    If Stream(LSRDrive'\ibmlan\netlib\lsrxut.dll', 'C', 'Query Exists') <> ''
      Then Do
             If RxFuncQuery('LoadLSRXUTFuncs')
               Then Do
                      Call RxFuncAdd LoadLsRxutFuncs, LSRXUT, LoadLsRxutFuncs
                      Call LoadLsRxutFuncs
                    End
               Else Nop
             Say '* LSRXUT.DLL Version' LSRXUTVER()
           End
      Else Do
             Say '* Could not find' LSRDrive'\IBMLAN\NETLIB\LSRXUT.DLL' '07'x
             Exit
           End

    If Stream(BootDrive'\os2\dll\rxutils.dll', 'C', 'Query Exists') <> ''
      Then Do
             If RxFuncQuery('RxLoadFuncs')
               Then Do
                      Call RxFuncAdd RxLoadFuncs, RXUTILS, RxLoadFuncs
                      Call RxLoadFuncs
                    End
               Else Nop
             Say '* RXUTILS.DLL Version' RXUtilsVer()
             RXUtils = 1
           End
      Else Do
             Say '! Could not find' BootDrive'\os2\dll\rxutils.dll'
             RXUtils = 0
           End

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '! Error:' RCode '07'x
    Exit

    Return

 LOGIT:/* -------------------------------------------------------------------*/

    Parse Arg LogFileName LogText

    Call LineOut LogFileName, LogText
    Call Stream LogFileName, 'C', 'Close'

    Return

