/*---------------------------------------------------------------------------*\
|   GET DCDB information from the Domain Controller by Drag & Drop            |
|                                                                             |
|                                            (C) Alain Rykaert - MAY96-JAN00  |
\*---------------------------------------------------------------------------*/
    Version = '1.04'

    Parse Upper Arg Mute ServerName InputName

    Say '* GetCMD Version' Version
    Say '* ServerName:' ServerName
    Say '* InputName:' InputName

    Call Init                    /* Initialisation of DLL's and other stuff*/

    Call ChkFile Directory()'\popup.exe'   /* Check for Message Box program*/

    Select
      When ServerName = ''
        Then Do
              'Start Popup "You must enter a ComputerName of a DC" "LSMT Message"'
               Exit
             End
      When InputName = ''
        Then Do
              'Start Popup "Just Drag & Drop an Output file on me" "LSMT Message"'
               Exit
             End
      Otherwise Nop
    End

    If NetGetInfo(350, 'WkstaInfo','') <> 0 & WkstaInfo.UserName = ''
      Then Do
            'Start Popup "No UserName logged on" "LSMT Message"'
             Exit
           End
      Else Say '> Admin logged on:' WkStaInfo.UserName

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'ServerName)
    If RC = 0
      Then Do
             ServerRole = ServerModalInfo.Role
             Say '> Role:' ServerRole
             If WordPos('Primary', ServerRole) > 0     /* check server role*/
               Then Nop
               Else Do
                      Say '! Error: This is not a Primary Domain Controller' '07'x
                     'Start popup "This is not a Primary Domain Controller" "LSMT Message"'
                      Exit
                    End
           End
      Else Do
             Say '! Error:' RC '07'x
            'Start popup "Error:' RC 'from Server' ServerName'" "LSMT Message"'
             Call Quit
           End

    Call Main                                          /* Do the main thing*/

    Call Quit                                         /* Quit the procedure*/

 MAIN:/* --------------------------------------------------------------------*/

    InputName = Translate(InputName)

 /* Determine the Filename.Extension */

    TempName = InputName

    x = LastPos('\', InputName) + 1
    FileName = SubStr(InputName, x)

 /* Select & start the associated program */

    Select

     When FileName = 'SERVERS.CSV'
       Then Do
              Say '* Getting all Servers from' ServerName
             'Call getsrvs /m /srv:'ServerName '/out:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'USERS.CSV'
       Then Do
              Say '* Getting all Users from' ServerName
             'Call getusers /m /srv:'ServerName '/out:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'GROUPS1.CSV'
       Then Do
              Say '* Getting all Groups from' ServerName
             'Call getgrps1 /m /srv:'ServerName '/out:'InputName '/log:'CurDir'\lsmt.log'
            End

     When FileName = 'GROUPS2.CSV'
       Then Do
              Say '* Getting all Group & Members from' ServerName
             'Call getgrps2 /m /srv:'ServerName '/out:'InputName '/log:'CurDir'\lsmt.log'
           End

     When FileName = 'ALIAS.CSV'
       Then Do
              Say '* Getting all Aliases from' ServerName
             'Call getalias /m /srv:'ServerName '/out:'InputName '/log:'CurDir'\lsmt.log'
           End

     When FileName = 'ACL.CSV'
       Then Do
              Say '* Getting all Access Control Lists from' ServerName
             'Call getacl /m /srv:'ServerName '/out:'InputName '/log:'CurDir'\lsmt.log'
           End

     When FileName = 'ASSGN.CSV'
       Then Do
              Say '* Getting all Logon Assingments from' ServerName
             'Call getassgn /m /srv:'ServerName '/out:'InputName '/log:'CurDir'\lsmt.log'
           End

     When FileName = 'APPL.CSV'
       Then Do
              Say '* Getting all Applications from' ServerName
             'Call getappl /m /srv:'ServerName '/out:'InputName '/log:'CurDir'\lsmt.log'
           End

     When FileName = 'SELECTOR.CSV'
       Then Do
              Say '* Getting all Application Selectors Servers from' ServerName
             'Call getsel /m /srv:'ServerName '/out:'InputName '/log:'CurDir'\lsmt.log'
           End

     When FileName = 'USERS.PWD'
       Then Do
              Say '* Getting all User Passwords from' ServerName
             'Call getpwd /m /srv:'ServerName '/out:'InputName '/log:'CurDir'\lsmt.log'
           End

     Otherwise Say ' Nothing To Do'

    End

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'

    CurDir = Directory()                 /* Determine the current directory*/

    If Stream('RGUTIL.CMD', 'C', 'Query Exists') = ''
      Then 'cd..'
      Else Nop

    Call RgUtil   '/M'                                    /* Rexx Utilities*/
    Call RgLSRXUT '/M'                             /* Lan Server Rexx Utils*/

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg FileName

    If Stream(FileName, 'C', 'Query Exists') = ''
      Then Do
             Say '! Error: file' FileName 'not found' '07'x
             Call Quit
          End
      Else Nop

    Return

 QUIT:/* --------------------------------------------------------------------*/

    Say
    Say '* Done. Press the [Enter] key to leave'
    Pull

    Exit

