/*--------------------------------------------------------------------------*\
|   LLOGIT.CMD                 (C) Alain Rykaert - IBM Belgium - OCT95-MAY96 |
\*--------------------------------------------------------------------------*/

    if ARG(1) = ''
     then do
             say 'Invalid options'
             exit
          end

    LOGF = ARG(1)                                               /* LOG File*/
    PIPN = ARG(2)                                        /* Named Pipe Name*/
    ADMN = ARG(3)                                     /* Administrator Name*/
    PRGN = ARG(4)                                /* Originated program name*/
    FUNC = ARG(5)                                               /* Function*/
    INFO = ARG(6)                                            /* Information*/
    RCOD = ARG(7)                                    /* Return & Error Code*/

    AL = 8                                /* Length of the Admin_Name field*/
    PL = 8                              /* Length of the Program_Name field*/
    FL = 20                            /* Length of the Function_Name field*/
    EL = 40                      /* Length of the Return_Code & Error field*/

    if RCOD = ''                             /* If an Error is encountered,*/
     then ERR = ' '                        /* put an '*' in the Error field*/
     else do                      /* and make the Return_Code & Error field*/
             ERR = '*'
             Call Beep 1000, 50
             RCOD = '['Left(RCOD,EL,' ')']'
          end

 /*-----------------------------------------------------------------------*\
 | LOG format sample :                                                     |
 | *04/10/95 10:15 ALAINADM        SETUSERS Update User    :     (cont...) |
 |                         A948R34 [2245 Could not modify User definition] |
 \*-----------------------------------------------------------------------*/
    ESC = '1B'x
    say ESC'[0;1m' || ERR || ESC'[0;1;32m'FUNC ':' INFO RCOD ESC'[0m'
/*  say FUNC ':' INFO RCOD */

    LOGT = ERR || Date('E') Left(Time(),5) Left(ADMN,AL,' '),
           Left(PRGN,PL,' ') Left(FUNC,FL,' ') ':' INFO RCOD

    Call LineOut LOGF, LOGT
    Call Stream  LOGF, 'C', 'CLOSE'

    if PIPN <> ''
     then do
             Call RgNPipes '/M'
             Parse Value RxNPOpen(PIPN) with RC HANDLE .
             if RC <> 0
              then Return RC
              else do
                      RC = RxNPWrite(HANDLE, LOGT)
                      if RC <> 0
                       then Return RC
                       else Call RxNPClose HANDLE
                   end
           end
     else Nop

    ReturnCode = 0

    Exit ReturnCode

