/*---------------------------------------------------------------------------*\
|  Get/Set Access Control List                (C) Alain Rykaert - AUG95-FEB98 |
\*---------------------------------------------------------------------------*/
    Version = '3.01'
    Say '* LSACL Version' Version

    Call Init                                                 /* init dll's*/

    Parse Upper Arg Option

    Call ChkOption                                     /* check the options*/

    ServerName = Strip(ServerName,'L','\')

    Say '* ServerName:' ServerName
    Say '* Resource:' Resource
    Say '* Log FileName:' LogFileName
    Say '* FileName:' FileName
    Say '* Tree:' Tree

 GET:/* ---------------------------------------------------------------------*/

    Resource = '\\'ServerName'\'Left(Resource,1)'$'SubStr(Resource,3)
    Resource = Strip(Resource,'T','\')
    Say '* UNC Resource:' Resource

    If File = 0                                         /* acl on dir level*/
      Then Do
             If Tree = 1
               Then Do
                      Resource = Resource || '\'
                      Say '* Getting a DIR SysFileTree, please wait...'
                      Call SysFileTree Resource, 'Result', 'DOS'
                    End
               Else Call SysFileTree Resource, 'Result', 'DO'
           End
      Else Do
             If Tree = 1                               /* acl on file level*/
               Then Do
                      Resource = Resource || '\'
                      Say '* Getting a FILE SysFileTree, please wait...'
                      Call SysFileTree Resource, 'Result', 'FOS'
                    End
               Else Call SysFileTree Resource, 'Result', 'FO'
           End

    If Result.0 > 0
      Then Do i = 1 to Result.0
             Counter = '('Right(i,Length(Result.0))'/'Right(Result.0,Length(Result.0))')'
             RC = NetGetInfo(10, 'Access', '\\'ServerName, Result.i)/* get acp*/
             If RC = 0
               Then Do
                      AccessList = ''
                      Do j = 1 to Access.Count
                        AccessList = AccessList || Access.j.UgName || ':' || Access.j.Access || ' '
                      End
                      LogText = Counter Result.i '('Access.Count')' AccessList
                    End
               Else LogText = Counter Result.i '(0) -none-'

             Say LogText                    /* display the result on screen*/
             If FileName = ''
               Then Nop
               Else Call Logit FileName LogText /* write the result to file*/
           End
      Else Say '! Dir not found'

    Exit

 SETACL:/* ------------------------------------------------------------------*/

    Parse Arg PathToSet UserID

    DirToSet.0 = 2
    DirToSet.1 = PathToSet
    DirToSet.2 = PathToSet || '\BATCH'

    Do j = 1 to DirToSet.0
   /* Delete */
      LogText = 'Del ACL on' DirToSet.j
      Say '09'x LogText
      RC = NetDelete(10, '\\'DCName, DirToSet.j)
      Call Logit LogText RC

   /* Set */
      Call Logit 'Adding ACL on:' DirToSet.j UserID':'DefaultACP
      ACL.Count    = 1
      ACL.1.Ugname = UserID
      ACL.1.Access = DefaultACP

      LogText = 'Set ACL on' DirToSet.j ACL.1.UgName || ':' || ACL.1.Access
      Say '09'x LogText
      RC = NetAdd(10, 'ACL', '\\'ServerName, DirToSet.j)
      If RC = 0
        Then Call Logit LogText
        Else Do
               Say '!' LogText '07'x
               Call Logit '! Error:' LogText RC
             End
    End

    Return

 INIT:/* --------------------------------------------------------------------*/

   '@echo off'
    BootDrive = Left(Value('ComSpec',,'OS2Environment'),2)

    If RxFuncQuery('SysLoadFuncs')
      Then Do
             Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
             Call SysLoadFuncs
           End
      Else Nop

    LSRDrive = ''                      /* Check for Lan Server Drive Letter*/
    PPath.i = Translate(Value('Path',,'OS2Environment'))
    x = Pos('\IBMLAN\NETPROG;', PPath.i) -2
    If x > 0
      Then LSRDrive = SubStr(PPath.i, x, 2)
      Else Do
             Say '! Could not determine the Lan Requester DirToSet.i' '07'x
             Exit
           End

    Call ChkFile LSRDrive'\ibmlan\netlib\lsrxut.dll'
    If RxFuncQuery('LoadLSRXUTFuncs')
      Then Do
             Call RxFuncAdd LoadLsRxutFuncs, LSRXUT, LoadLsRxutFuncs
             Call LoadLsRxutFuncs
           End
      Else Nop

    Call ChkFile BootDrive'\os2\dll\rxutils.dll'
    If RxFuncQuery('RxLoadFuncs')
      Then Do
             Call RxFuncAdd RxLoadFuncs, RXUTILS, RxLoadFuncs
             Call RxLoadFuncs
           End
      Else Nop

    Return

 CHKOPTION:/* ---------------------------------------------------------------*/

    ServerName = ''
    Source = ''
    FileName = ''
    LogFileName = 'LSACL.LOG'
    Dir = 1
    File = 0
    Get = 0
    Set = 0
    Tree = 0

    Do While Option <> ''
      Parse Value Option With Argument ' ' Option
      Select
        When Left(Argument,5) = '/SRV:' Then ServerName = Substr(Argument,6)
        When Left(Argument,5) = '/RES:' Then Resource = Substr(Argument,6)
        When Left(Argument,3) = '/F:' Then FileName = Substr(Argument,4)
        When Left(Argument,3) = '/L:' Then LogFileName = Substr(Argument,4)
        When Left(Argument,5) = '/FILE' Then Do
                                               Dir = 0
                                               File = 1
                                             End
        When Left(Argument,4) = '/GET' Then Get = 1
        When Left(Argument,4) = '/SET' Then Set = 1
        When Left(Argument,5) = '/TREE' Then Tree = 1
        Otherwise Nop
      End
    End

    If ServerName = '' | Resource = '' | Get = 0 & Set = 0
      Then Do
             Say '*'
             Say '* Get/Set Access Control Profiles to/from an ASCII file'
             Say '*'
             Say '* Usage: LSACL /SRV:ServerName'
             Say '*              /RES:Resource'
             Say '*              /F:FileName'
             Say '*              /L:LogFileName'
             Say '*              /FILE (get ACL on file base - Directory is default)'
             Say '*              /GET'
             Say '*              /SET'
             Say '*              /TREE'
             Say '*'
             Say '* Sample: LSACL /SRV:BEDDC01 /RES:E:\HOMEDIR /L:HOMEDIR.LOG /GET /TREE'
             Say '*'
             Exit
          End
      Else Nop

    Return

 CHKERROR:/* ----------------------------------------------------------------*/

    Parse Arg RCode

    Say '! Error:' RCode '07'x
    Exit

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File_To_Check

    If Stream(File_To_Check, 'C', 'Query Exists') = ''
      Then Do
             Say '! File not found:' File_To_Check '07'x
             Exit
           End
      Else Nop

    Return

 LOGIT:/* ------------------------------------------------------------------*/

    Parse Arg Log_FileName Log_Text

    Log_Text = Date('E') Time() Log_Text

    If LineOut(Log_FileName, Log_Text) = 0
      Then Call Stream Log_FileName, 'C', 'Close'
      Else Say '! Error while writing to' Log_FileName

    Return

