/* NETACC          (C) Jacques Van den Ende - SEP99-NOV99 */
/* It's hard to say but thanks to AR                      */
    Red = ESC'[0;1;41m'
    Blue = ESC'[0;1;44m'
    Reset = ESC'[0m'

    Version = '2.01'
    Parse Arg '/s:' SourceDir .
    Parse Arg '/a:' Action .
    Parse Arg '/u:' User .
    Parse Arg '/r:' Right .
    Parse Arg '/l:' LogFile .
    SourceDir = Translate(SourceDir)
    Action = Translate(Action)
    User = Translate(User)
    Right = Translate(Right)
    If SourceDir = '' | ((Action <> 'TREE' & Action <> 'DELETE') & (Action <> 'SET' | User == '' | Right == '' | Verify(Right,'RWCXDA') <> 0))
      Then Do
             Say
             Say '! Error: Invalid Syntax'
             Say '*'
             Say '* NETACC ' Version
             Say '*'
             Say '* netacc Path /a:Action [/r:[/L:Logfile]'
             Say '*'
             Say '* Sample: netacc /s:g:\sharea /a:tree [/l:d:\temp\netacc.log]'
             Say '* Sample: netacc /s:g:\sharea /a:delete [/l:d:\temp\netacc.log]'
             Say '* Sample: netacc /s:g:\sharea /a:set /u:User /r:RWCXDA /l:d:\temp\netacc.log]'
             Exit
           End
      Else Nop

    Signal On Halt Name Quit                   /* Quit if CTRL-C is pressed*/

    If LogFile <> ''
       Then Log = 1
       Else Log = 0

    szlogFile = Stream(LogFile,'C','Query Exists')
    If Rc <> ''
       Then Rc = SysFileDelete(szLogFile)
       Else NOP

    Call Init

   '@echo off'

    Dirs.0.0 = 1
    Dirs.0.1 = SourceDir
    Call Doit 0 1

    Exit

  Doit: Procedure Expose Dirs. Action User Right LogFile Log/* -------------------------------*/

    Parse Arg x y

    Parse Value RxScreenSize() With oldRow ',' oldCol
    Col = oldCol -1

    Select 
      When Action == 'TREE'
           Then Rc = Tree(Dirs.x.y,'DoIt',,,Col)
      When Action == 'DELETE'
           Then Rc = Delete(Dirs.x.y,'DoIt',,,Col)
      When Action == 'SET'
           Then Rc = Set(Dirs.x.y,'DoIt',User,Right,Col)
      Otherwise
    End
    j = x + 1
    z = 'Dirs.'j
    Call SysFileTree Dirs.x.y'\', z, 'DO'
    If Dirs.j.0 > 0
       Then Do a = 1 to Dirs.j.0
              Call Doit j a
            End
       Else Nop

    Return

 TREE: /* --------------------------------------------------------------------*/

    Parse Arg Path,Source_Proc,,,Col

    NETACCESS = 10
    SrvName = ''

    MyRc = NetGetInfo(NETACCESS, 'Access', SrvName, Path)

    If Source_Proc == 'DoIt'
       Then Do
              If MyRc == 0
                 Then Do
                        i = 1
                        Do While i <= Access.count
                           Call RxSay Copies(" ",Col)
                           Call RxSay D2C(13)
                           Call RxSay Access.i.ugname Access.i.access Path
                           If Log
                              Then Rc = LineOut(logFile,';' Access.i.ugname ';' Left(Access.i.access,6) ';' Path)
                              Else NOP
                           Call RxSay D2C(13)
                           i = i + 1
                        End
                      End
                 Else Do
                        Call RxSay Copies(" ",Col)
                        Call RxSay D2C(13)
                        Call RxSay 'No Access on 'Path
                        If Log
                           Then Rc = LineOut(LogFile,'No Access on 'Path)
                           Else NOP
                        Call RxSay D2C(13)
                      End
              End

    Return(MyRc)

 DELETE:/* --------------------------------------------------------------------*/

    Parse Arg Path,Source_Proc,,,Col
/*Say Path*/

    NETACCESS = 10
    SrvName = ''

    MyRc = Tree(Path,Delete,,,Col)
    If MyRc == 0
       Then Do
              MyRc = NetDelete(NETACCESS, SrvName, Path)
              If MyRc == 0
                 Then Do
                        Call RxSay Copies(" ",Col)
                        Call RxSay D2C(13)
                        Call RxSay 'ACL deleted on 'Path
                        If Log
                           Then Rc = LineOut(LogFile,'ACL deleted on 'Path)
                           Else NOP
                        Call RxSay D2C(13)
                      End
                 Else NOP
            End
       Else Do
              Call RxSay Copies(" ",Col)
              Call RxSay D2C(13)
              Call RxSay 'ACL already deleted on 'Path
              If Log
                 Then Rc = LineOut(LogFile,'ACL already deleted on 'Path)
                 Else NOP
              Call RxSay D2C(13)
            End

    Return(MyRc)


 SET:/* --------------------------------------------------------------------*/

    Parse Arg Path,Source_Proc,User,Right,Col
/*Say Path*/

    NETACCESS = 10
    SrvName = ''

    ModifyAcl.count=1
    ModifyAcl.1.UgName=User
    ModifyAcl.1.Access=Right

    MyRc = Tree(Path,Set,,,Col)
    If MyRc == '2222 Could not get Net Access Information'
       Then MyRc = NetAdd(NETACCESS, 'ModifyACL', SrvName, Path)
       Else MyRc = NetSetInfo(NETACCESS, 'ModifyACL', SrvName, Path)

  
    If myRc <> '0'
       Then Do
              Say 'Got error from NetSetInfo() ' myRc
              Exit 9
            End
       Else Do
              Call RxSay Copies(" ",Col)
              Call RxSay D2C(13)
              Call RxSay User Right Path
              If Log
                 Then Rc = LineOut(LogFile,';' User ';' Left(Right,6) ';' Path)
                 Else NOP
              Call RxSay D2C(13)
            End
  


    Return(MyRc)

 INIT:/* --------------------------------------------------------------------*/

    If RxFuncQuery('RxUtils')
      Then Do
             Call RxFuncAdd 'RxLoadFuncs','RXUTILS','RxLoadFuncs'
             Call RxLoadFuncs("Quiet")
           End
      Else Nop

    Red = ESC'[0;1;41m'
    Blue = ESC'[0;1;44m'
    Reset = ESC'[0m'

    Return


 QUIT:/* --------------------------------------------------------------------*/

    Say
    Say '...Interupted by User...'

    Exit

